/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;

class IntArray {
    private int[] m_ints;

    public IntArray(int n2) {
        this.m_ints = new int[n2];
    }

    public IntArray(int[] nArray) {
        this.m_ints = nArray;
    }

    public IntArray(BigInteger bigInteger) {
        this(bigInteger, 0);
    }

    public IntArray(BigInteger bigInteger, int n2) {
        int n3;
        int n4;
        int n5;
        if (bigInteger.signum() == -1) {
            throw new IllegalArgumentException("Only positive Integers allowed");
        }
        if (bigInteger.equals(ECConstants.ZERO)) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n6 = byArray.length;
        int n7 = 0;
        if (byArray[0] == 0) {
            --n6;
            n7 = 1;
        }
        this.m_ints = (n5 = (n6 + 3) / 4) < n2 ? new int[n2] : new int[n5];
        int n8 = n5 - 1;
        int n9 = n6 % 4 + n7;
        int n10 = 0;
        if (n7 < n9) {
            for (n4 = n7; n4 < n9; ++n4) {
                n10 <<= 8;
                n3 = byArray[n4];
                if (n3 < 0) {
                    n3 += 256;
                }
                n10 |= n3;
            }
            this.m_ints[n8--] = n10;
        }
        while (n8 >= 0) {
            n10 = 0;
            for (n3 = 0; n3 < 4; ++n3) {
                int n11;
                n10 <<= 8;
                if ((n11 = byArray[n4++]) < 0) {
                    n11 += 256;
                }
                n10 |= n11;
            }
            this.m_ints[n8] = n10;
            --n8;
        }
    }

    public boolean isZero() {
        return this.m_ints.length == 0 || this.m_ints[0] == 0 && this.getUsedLength() == 0;
    }

    public int getUsedLength() {
        int n2 = this.m_ints.length;
        if (n2 < 1) {
            return 0;
        }
        if (this.m_ints[0] != 0) {
            while (this.m_ints[--n2] == 0) {
            }
            return n2 + 1;
        }
        do {
            if (this.m_ints[--n2] == 0) continue;
            return n2 + 1;
        } while (n2 > 0);
        return 0;
    }

    public int bitLength() {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 - 1;
        int n4 = this.m_ints[n3];
        int n5 = (n3 << 5) + 1;
        if ((n4 & 0xFFFF0000) != 0) {
            if ((n4 & 0xFF000000) != 0) {
                n5 += 24;
                n4 >>>= 24;
            } else {
                n5 += 16;
                n4 >>>= 16;
            }
        } else if (n4 > 255) {
            n5 += 8;
            n4 >>>= 8;
        }
        while (n4 != 1) {
            ++n5;
            n4 >>>= 1;
        }
        return n5;
    }

    private int[] resizedInts(int n2) {
        int[] nArray = new int[n2];
        int n3 = this.m_ints.length;
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.m_ints, 0, nArray, 0, n4);
        return nArray;
    }

    public BigInteger toBigInteger() {
        int n2;
        int n3;
        int n4 = this.getUsedLength();
        if (n4 == 0) {
            return ECConstants.ZERO;
        }
        int n5 = this.m_ints[n4 - 1];
        byte[] byArray = new byte[4];
        int n6 = 0;
        boolean bl2 = false;
        for (n3 = 3; n3 >= 0; --n3) {
            byte by2 = (byte)(n5 >>> 8 * n3);
            if (!bl2 && by2 == 0) continue;
            bl2 = true;
            byArray[n6++] = by2;
        }
        n3 = 4 * (n4 - 1) + n6;
        byte[] byArray2 = new byte[n3];
        for (n2 = 0; n2 < n6; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        for (n2 = n4 - 2; n2 >= 0; --n2) {
            for (int i2 = 3; i2 >= 0; --i2) {
                byArray2[n6++] = (byte)(this.m_ints[n2] >>> 8 * i2);
            }
        }
        return new BigInteger(1, byArray2);
    }

    public void shiftLeft() {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return;
        }
        if (this.m_ints[n2 - 1] < 0 && ++n2 > this.m_ints.length) {
            this.m_ints = this.resizedInts(this.m_ints.length + 1);
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl3 = this.m_ints[i2] < 0;
            int n3 = i2;
            this.m_ints[n3] = this.m_ints[n3] << 1;
            if (bl2) {
                int n4 = i2;
                this.m_ints[n4] = this.m_ints[n4] | 1;
            }
            bl2 = bl3;
        }
    }

    public IntArray shiftLeft(int n2) {
        int n3 = this.getUsedLength();
        if (n3 == 0) {
            return this;
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 > 31) {
            throw new IllegalArgumentException("shiftLeft() for max 31 bits , " + n2 + "bit shift is not possible");
        }
        int[] nArray = new int[n3 + 1];
        int n4 = 32 - n2;
        nArray[0] = this.m_ints[0] << n2;
        for (int i2 = 1; i2 < n3; ++i2) {
            nArray[i2] = this.m_ints[i2] << n2 | this.m_ints[i2 - 1] >>> n4;
        }
        nArray[n3] = this.m_ints[n3 - 1] >>> n4;
        return new IntArray(nArray);
    }

    public void addShifted(IntArray intArray, int n2) {
        int n3 = intArray.getUsedLength();
        int n4 = n3 + n2;
        if (n4 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n4);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 + n2;
            this.m_ints[n5] = this.m_ints[n5] ^ intArray.m_ints[i2];
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public boolean testBit(int n2) {
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        int n5 = 1 << n4;
        return (this.m_ints[n3] & n5) != 0;
    }

    public void flipBit(int n2) {
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        int n5 = 1 << n4;
        int n6 = n3;
        this.m_ints[n6] = this.m_ints[n6] ^ n5;
    }

    public void setBit(int n2) {
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        int n5 = 1 << n4;
        int n6 = n3;
        this.m_ints[n6] = this.m_ints[n6] | n5;
    }

    public IntArray multiply(IntArray intArray, int n2) {
        int n3 = n2 + 31 >> 5;
        if (this.m_ints.length < n3) {
            this.m_ints = this.resizedInts(n3);
        }
        IntArray intArray2 = new IntArray(intArray.resizedInts(intArray.getLength() + 1));
        IntArray intArray3 = new IntArray(n2 + n2 + 31 >> 5);
        int n4 = 1;
        for (int i2 = 0; i2 < 32; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if ((this.m_ints[i3] & n4) == 0) continue;
                intArray3.addShifted(intArray2, i3);
            }
            n4 <<= 1;
            intArray2.shiftLeft();
        }
        return intArray3;
    }

    public void reduce(int n2, int[] nArray) {
        for (int i2 = n2 + n2 - 2; i2 >= n2; --i2) {
            if (!this.testBit(i2)) continue;
            int n3 = i2 - n2;
            this.flipBit(n3);
            this.flipBit(i2);
            int n4 = nArray.length;
            while (--n4 >= 0) {
                this.flipBit(nArray[n4] + n3);
            }
        }
        this.m_ints = this.resizedInts(n2 + 31 >> 5);
    }

    public IntArray square(int n2) {
        int[] nArray = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85};
        int n3 = n2 + 31 >> 5;
        if (this.m_ints.length < n3) {
            this.m_ints = this.resizedInts(n3);
        }
        IntArray intArray = new IntArray(n3 + n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            for (n6 = 0; n6 < 4; ++n6) {
                n7 >>>= 8;
                n5 = this.m_ints[i2] >>> n6 * 4 & 0xF;
                n4 = nArray[n5] << 24;
                n7 |= n4;
            }
            intArray.m_ints[i2 + i2] = n7;
            n7 = 0;
            n6 = this.m_ints[i2] >>> 16;
            for (n5 = 0; n5 < 4; ++n5) {
                n7 >>>= 8;
                n4 = n6 >>> n5 * 4 & 0xF;
                int n8 = nArray[n4] << 24;
                n7 |= n8;
            }
            intArray.m_ints[i2 + i2 + 1] = n7;
        }
        return intArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        int n2 = this.getUsedLength();
        if (intArray.getUsedLength() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.m_ints[i2] == intArray.m_ints[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.getUsedLength();
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 31 + this.m_ints[i2];
        }
        return n3;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.m_ints[n2 - 1]));
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            String string = Integer.toBinaryString(this.m_ints[i2]);
            for (int i3 = string.length(); i3 < 8; ++i3) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

