/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WorldSettings;

public class WorldData {
    private long seed;
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long time;
    private long lastPlayed;
    private long sizeOnDisk;
    private NBTTagCompound playerData;
    private int dimension;
    private String name;
    private int version;
    private boolean isRaining;
    private int rainTicks;
    private boolean isThundering;
    private int thunderTicks;
    private int gameType;
    private boolean useMapFeatures;
    private boolean hardcore = false;

    public WorldData(NBTTagCompound nBTTagCompound) {
        this.seed = nBTTagCompound.getLong("RandomSeed");
        this.gameType = nBTTagCompound.f("GameType");
        this.useMapFeatures = nBTTagCompound.hasKey("MapFeatures") ? nBTTagCompound.n("MapFeatures") : true;
        this.spawnX = nBTTagCompound.f("SpawnX");
        this.spawnY = nBTTagCompound.f("SpawnY");
        this.spawnZ = nBTTagCompound.f("SpawnZ");
        this.time = nBTTagCompound.getLong("Time");
        this.lastPlayed = nBTTagCompound.getLong("LastPlayed");
        this.sizeOnDisk = nBTTagCompound.getLong("SizeOnDisk");
        this.name = nBTTagCompound.getString("LevelName");
        this.version = nBTTagCompound.f("version");
        this.rainTicks = nBTTagCompound.f("rainTime");
        this.isRaining = nBTTagCompound.n("raining");
        this.thunderTicks = nBTTagCompound.f("thunderTime");
        this.isThundering = nBTTagCompound.n("thundering");
        this.hardcore = nBTTagCompound.n("hardcore");
        if (nBTTagCompound.hasKey("Player")) {
            this.playerData = nBTTagCompound.l("Player");
            this.dimension = this.playerData.f("Dimension");
        }
    }

    public WorldData(WorldSettings worldSettings, String string) {
        this.seed = worldSettings.a();
        this.gameType = worldSettings.b();
        this.useMapFeatures = worldSettings.d();
        this.name = string;
        this.hardcore = worldSettings.c();
    }

    public WorldData(WorldData worldData) {
        this.seed = worldData.seed;
        this.gameType = worldData.gameType;
        this.useMapFeatures = worldData.useMapFeatures;
        this.spawnX = worldData.spawnX;
        this.spawnY = worldData.spawnY;
        this.spawnZ = worldData.spawnZ;
        this.time = worldData.time;
        this.lastPlayed = worldData.lastPlayed;
        this.sizeOnDisk = worldData.sizeOnDisk;
        this.playerData = worldData.playerData;
        this.dimension = worldData.dimension;
        this.name = worldData.name;
        this.version = worldData.version;
        this.rainTicks = worldData.rainTicks;
        this.isRaining = worldData.isRaining;
        this.thunderTicks = worldData.thunderTicks;
        this.isThundering = worldData.isThundering;
        this.hardcore = worldData.hardcore;
    }

    public NBTTagCompound a() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.a(nBTTagCompound, this.playerData);
        return nBTTagCompound;
    }

    public NBTTagCompound a(List list) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        EntityHuman entityHuman = null;
        NBTTagCompound nBTTagCompound2 = null;
        if (list.size() > 0) {
            entityHuman = (EntityHuman)list.get(0);
        }
        if (entityHuman != null) {
            nBTTagCompound2 = new NBTTagCompound();
            entityHuman.d(nBTTagCompound2);
        }
        this.a(nBTTagCompound, nBTTagCompound2);
        return nBTTagCompound;
    }

    private void a(NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2) {
        nBTTagCompound.setLong("RandomSeed", this.seed);
        nBTTagCompound.a("GameType", this.gameType);
        nBTTagCompound.a("MapFeatures", this.useMapFeatures);
        nBTTagCompound.a("SpawnX", this.spawnX);
        nBTTagCompound.a("SpawnY", this.spawnY);
        nBTTagCompound.a("SpawnZ", this.spawnZ);
        nBTTagCompound.setLong("Time", this.time);
        nBTTagCompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nBTTagCompound.setLong("LastPlayed", System.currentTimeMillis());
        nBTTagCompound.setString("LevelName", this.name);
        nBTTagCompound.a("version", this.version);
        nBTTagCompound.a("rainTime", this.rainTicks);
        nBTTagCompound.a("raining", this.isRaining);
        nBTTagCompound.a("thunderTime", this.thunderTicks);
        nBTTagCompound.a("thundering", this.isThundering);
        nBTTagCompound.a("hardcore", this.hardcore);
        if (nBTTagCompound2 != null) {
            nBTTagCompound.a("Player", nBTTagCompound2);
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public int c() {
        return this.spawnX;
    }

    public int d() {
        return this.spawnY;
    }

    public int e() {
        return this.spawnZ;
    }

    public long f() {
        return this.time;
    }

    public long g() {
        return this.sizeOnDisk;
    }

    public int h() {
        return this.dimension;
    }

    public void a(long l) {
        this.time = l;
    }

    public void b(long l) {
        this.sizeOnDisk = l;
    }

    public void setSpawn(int n, int n2, int n3) {
        this.spawnX = n;
        this.spawnY = n2;
        this.spawnZ = n3;
    }

    public void a(String string) {
        this.name = string;
    }

    public int i() {
        return this.version;
    }

    public void a(int n) {
        this.version = n;
    }

    public boolean isThundering() {
        return this.isThundering;
    }

    public void setThundering(boolean bl) {
        this.isThundering = bl;
    }

    public int getThunderDuration() {
        return this.thunderTicks;
    }

    public void setThunderDuration(int n) {
        this.thunderTicks = n;
    }

    public boolean hasStorm() {
        return this.isRaining;
    }

    public void setStorm(boolean bl) {
        this.isRaining = bl;
    }

    public int getWeatherDuration() {
        return this.rainTicks;
    }

    public void setWeatherDuration(int n) {
        this.rainTicks = n;
    }

    public int getGameType() {
        return this.gameType;
    }

    public boolean o() {
        return this.useMapFeatures;
    }

    public void setGameType(int n) {
        this.gameType = n;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }
}

