/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet50PreChunk;
import net.minecraft.server.Packet51MapChunk;
import net.minecraft.server.Packet52MultiBlockChange;
import net.minecraft.server.Packet53BlockChange;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.TileEntity;
import net.minecraft.server.WorldServer;

class PlayerInstance {
    private List b = new ArrayList();
    private int chunkX;
    private int chunkZ;
    private ChunkCoordIntPair location;
    private short[] dirtyBlocks = new short[10];
    private int dirtyCount = 0;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    final /* synthetic */ PlayerManager playerManager;

    public PlayerInstance(PlayerManager playerManager, int n, int n2) {
        this.playerManager = playerManager;
        this.chunkX = n;
        this.chunkZ = n2;
        this.location = new ChunkCoordIntPair(n, n2);
        playerManager.a().chunkProviderServer.getChunkAt(n, n2);
    }

    public void a(EntityPlayer entityPlayer) {
        if (this.b.contains(entityPlayer)) {
            throw new IllegalStateException("Failed to add player. " + entityPlayer + " already is in chunk " + this.chunkX + ", " + this.chunkZ);
        }
        entityPlayer.playerChunkCoordIntPairs.add(this.location);
        entityPlayer.netServerHandler.sendPacket(new Packet50PreChunk(this.location.x, this.location.z, true));
        this.b.add(entityPlayer);
        entityPlayer.chunkCoordIntPairQueue.add(this.location);
    }

    public void b(EntityPlayer entityPlayer) {
        if (!this.b.contains(entityPlayer)) {
            return;
        }
        this.b.remove(entityPlayer);
        if (this.b.size() == 0) {
            long l = (long)this.chunkX + Integer.MAX_VALUE | (long)this.chunkZ + Integer.MAX_VALUE << 32;
            PlayerManager.a(this.playerManager).remove(l);
            if (this.dirtyCount > 0) {
                PlayerManager.b(this.playerManager).remove(this);
            }
            this.playerManager.a().chunkProviderServer.queueUnload(this.chunkX, this.chunkZ);
        }
        entityPlayer.chunkCoordIntPairQueue.remove(this.location);
        if (entityPlayer.playerChunkCoordIntPairs.contains(this.location)) {
            entityPlayer.netServerHandler.sendPacket(new Packet50PreChunk(this.chunkX, this.chunkZ, false));
        }
    }

    public void a(int n, int n2, int n3) {
        if (this.dirtyCount == 0) {
            PlayerManager.b(this.playerManager).add(this);
            this.h = this.i = n;
            this.j = this.k = n2;
            this.l = this.m = n3;
        }
        if (this.h > n) {
            this.h = n;
        }
        if (this.i < n) {
            this.i = n;
        }
        if (this.j > n2) {
            this.j = n2;
        }
        if (this.k < n2) {
            this.k = n2;
        }
        if (this.l > n3) {
            this.l = n3;
        }
        if (this.m < n3) {
            this.m = n3;
        }
        if (this.dirtyCount < 10) {
            short s = (short)(n << 12 | n3 << 8 | n2);
            for (int i = 0; i < this.dirtyCount; ++i) {
                if (this.dirtyBlocks[i] != s) continue;
                return;
            }
            this.dirtyBlocks[this.dirtyCount++] = s;
        }
    }

    public void sendAll(Packet packet) {
        for (int i = 0; i < this.b.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.b.get(i);
            if (!entityPlayer.playerChunkCoordIntPairs.contains(this.location)) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void a() {
        WorldServer worldServer = this.playerManager.a();
        if (this.dirtyCount == 0) {
            return;
        }
        if (this.dirtyCount == 1) {
            int n = this.chunkX * 16 + this.h;
            int n2 = this.j;
            int n3 = this.chunkZ * 16 + this.l;
            this.sendAll(new Packet53BlockChange(n, n2, n3, worldServer));
            if (Block.isTileEntity[worldServer.getTypeId(n, n2, n3)]) {
                this.sendTileEntity(worldServer.getTileEntity(n, n2, n3));
            }
        } else if (this.dirtyCount == 10) {
            this.j = this.j / 2 * 2;
            this.k = (this.k / 2 + 1) * 2;
            int n = this.h + this.chunkX * 16;
            int n4 = this.j;
            int n5 = this.l + this.chunkZ * 16;
            int n6 = this.i - this.h + 1;
            int n7 = this.k - this.j + 2;
            int n8 = this.m - this.l + 1;
            this.sendAll(new Packet51MapChunk(n, n4, n5, n6, n7, n8, worldServer));
            List list = worldServer.getTileEntities(n, n4, n5, n + n6, n4 + n7, n5 + n8);
            for (int i = 0; i < list.size(); ++i) {
                this.sendTileEntity((TileEntity)list.get(i));
            }
        } else {
            this.sendAll(new Packet52MultiBlockChange(this.chunkX, this.chunkZ, this.dirtyBlocks, this.dirtyCount, worldServer));
            for (int i = 0; i < this.dirtyCount; ++i) {
                int n = this.chunkX * 16 + (this.dirtyCount >> 12 & 0xF);
                int n9 = this.dirtyCount & 0xFF;
                int n10 = this.chunkZ * 16 + (this.dirtyCount >> 8 & 0xF);
                if (!Block.isTileEntity[worldServer.getTypeId(n, n9, n10)]) continue;
                System.out.println("Sending!");
                this.sendTileEntity(worldServer.getTileEntity(n, n9, n10));
            }
        }
        this.dirtyCount = 0;
    }

    private void sendTileEntity(TileEntity tileEntity) {
        Packet packet;
        if (tileEntity != null && (packet = tileEntity.k()) != null) {
            this.sendAll(packet);
        }
    }
}

