/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityList;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.FontAllowedCharacters;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.InventoryPlayer;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NetHandler;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet0KeepAlive;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet102WindowClick;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet106Transaction;
import net.minecraft.server.Packet107SetCreativeSlot;
import net.minecraft.server.Packet108;
import net.minecraft.server.Packet10Flying;
import net.minecraft.server.Packet130UpdateSign;
import net.minecraft.server.Packet13PlayerLookMove;
import net.minecraft.server.Packet14BlockDig;
import net.minecraft.server.Packet15Place;
import net.minecraft.server.Packet16BlockItemSwitch;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet19EntityAction;
import net.minecraft.server.Packet255KickDisconnect;
import net.minecraft.server.Packet27;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet53BlockChange;
import net.minecraft.server.Packet7UseEntity;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.Slot;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.WorldServer;

public class NetServerHandler
extends NetHandler
implements ICommandListener {
    public static Logger a = Logger.getLogger("Minecraft");
    public NetworkManager networkManager;
    public boolean disconnected = false;
    private MinecraftServer minecraftServer;
    private EntityPlayer player;
    private int f;
    private int g;
    private boolean h;
    private int i;
    private long j;
    private static Random k = new Random();
    private long l;
    private double x;
    private double y;
    private double z;
    private boolean checkMovement = true;
    private EntityList q = new EntityList();

    public NetServerHandler(MinecraftServer minecraftServer, NetworkManager networkManager, EntityPlayer entityPlayer) {
        this.minecraftServer = minecraftServer;
        this.networkManager = networkManager;
        networkManager.a(this);
        this.player = entityPlayer;
        entityPlayer.netServerHandler = this;
    }

    public void a() {
        this.h = false;
        ++this.f;
        this.networkManager.b();
        if ((long)this.f - this.l > 20L) {
            this.l = this.f;
            this.j = System.nanoTime() / 1000000L;
            this.i = k.nextInt();
            this.sendPacket(new Packet0KeepAlive(this.i));
        }
    }

    public void disconnect(String string) {
        this.player.E();
        this.sendPacket(new Packet255KickDisconnect(string));
        this.networkManager.d();
        this.minecraftServer.serverConfigurationManager.sendAll(new Packet3Chat("\u00a7e" + this.player.name + " left the game."));
        this.minecraftServer.serverConfigurationManager.disconnect(this.player);
        this.disconnected = true;
    }

    public void a(Packet27 packet27) {
        this.player.a(packet27.c(), packet27.e(), packet27.g(), packet27.h(), packet27.d(), packet27.f());
    }

    public void a(Packet10Flying packet10Flying) {
        double d;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        this.h = true;
        if (this.player.j) {
            return;
        }
        if (!this.checkMovement) {
            d = packet10Flying.y - this.y;
            if (packet10Flying.x == this.x && d * d < 0.01 && packet10Flying.z == this.z) {
                this.checkMovement = true;
            }
        }
        if (this.checkMovement) {
            boolean bl;
            boolean bl2;
            double d2;
            if (this.player.vehicle != null) {
                float f = this.player.yaw;
                float f2 = this.player.pitch;
                this.player.vehicle.i();
                double d3 = this.player.locX;
                double d4 = this.player.locY;
                double d5 = this.player.locZ;
                double d6 = 0.0;
                double d7 = 0.0;
                if (packet10Flying.hasLook) {
                    f = packet10Flying.yaw;
                    f2 = packet10Flying.pitch;
                }
                if (packet10Flying.h && packet10Flying.y == -999.0 && packet10Flying.stance == -999.0) {
                    d6 = packet10Flying.x;
                    d7 = packet10Flying.z;
                }
                this.player.onGround = packet10Flying.g;
                this.player.a(true);
                this.player.move(d6, 0.0, d7);
                this.player.setLocation(d3, d4, d5, f, f2);
                this.player.motX = d6;
                this.player.motZ = d7;
                if (this.player.vehicle != null) {
                    worldServer.vehicleEnteredWorld(this.player.vehicle, true);
                }
                if (this.player.vehicle != null) {
                    this.player.vehicle.i();
                }
                this.minecraftServer.serverConfigurationManager.d(this.player);
                this.x = this.player.locX;
                this.y = this.player.locY;
                this.z = this.player.locZ;
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            if (this.player.isSleeping()) {
                this.player.a(true);
                this.player.setLocation(this.x, this.y, this.z, this.player.yaw, this.player.pitch);
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            d = this.player.locY;
            this.x = this.player.locX;
            this.y = this.player.locY;
            this.z = this.player.locZ;
            double d8 = this.player.locX;
            double d9 = this.player.locY;
            double d10 = this.player.locZ;
            float f = this.player.yaw;
            float f3 = this.player.pitch;
            if (packet10Flying.h && packet10Flying.y == -999.0 && packet10Flying.stance == -999.0) {
                packet10Flying.h = false;
            }
            if (packet10Flying.h) {
                d8 = packet10Flying.x;
                d9 = packet10Flying.y;
                d10 = packet10Flying.z;
                d2 = packet10Flying.stance - packet10Flying.y;
                if (!this.player.isSleeping() && (d2 > 1.65 || d2 < 0.1)) {
                    this.disconnect("Illegal stance");
                    a.warning(this.player.name + " had an illegal stance: " + d2);
                    return;
                }
                if (Math.abs(packet10Flying.x) > 3.2E7 || Math.abs(packet10Flying.z) > 3.2E7) {
                    this.disconnect("Illegal position");
                    return;
                }
            }
            if (packet10Flying.hasLook) {
                f = packet10Flying.yaw;
                f3 = packet10Flying.pitch;
            }
            this.player.a(true);
            this.player.bL = 0.0f;
            this.player.setLocation(this.x, this.y, this.z, f, f3);
            if (!this.checkMovement) {
                return;
            }
            d2 = d8 - this.player.locX;
            double d11 = d9 - this.player.locY;
            double d12 = d10 - this.player.locZ;
            double d13 = d2 * d2 + d11 * d11 + d12 * d12;
            if (d13 > 100.0) {
                a.warning(this.player.name + " moved too quickly!");
                this.disconnect("You moved too quickly :( (Hacking?)");
                return;
            }
            float f4 = 0.0625f;
            boolean bl3 = bl2 = worldServer.getEntities(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).size() == 0;
            if (this.player.onGround && !packet10Flying.g && d11 > 0.0) {
                this.player.c(0.2f);
            }
            this.player.move(d2, d11, d12);
            this.player.onGround = packet10Flying.g;
            this.player.b(d2, d11, d12);
            double d14 = d11;
            d2 = d8 - this.player.locX;
            d11 = d9 - this.player.locY;
            if (d11 > -0.5 || d11 < 0.5) {
                d11 = 0.0;
            }
            d12 = d10 - this.player.locZ;
            d13 = d2 * d2 + d11 * d11 + d12 * d12;
            boolean bl4 = false;
            if (d13 > 0.0625 && !this.player.isSleeping() && !this.player.itemInWorldManager.b()) {
                bl4 = true;
                a.warning(this.player.name + " moved wrongly!");
                System.out.println("Got position " + d8 + ", " + d9 + ", " + d10);
                System.out.println("Expected " + this.player.locX + ", " + this.player.locY + ", " + this.player.locZ);
            }
            this.player.setLocation(d8, d9, d10, f, f3);
            boolean bl5 = bl = worldServer.getEntities(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).size() == 0;
            if (bl2 && (bl4 || !bl) && !this.player.isSleeping()) {
                this.a(this.x, this.y, this.z, f, f3);
                return;
            }
            AxisAlignedBB axisAlignedBB = this.player.boundingBox.clone().b(f4, f4, f4).a(0.0, -0.55, 0.0);
            if (!(this.minecraftServer.allowFlight || this.player.itemInWorldManager.b() || worldServer.b(axisAlignedBB))) {
                if (d14 >= -0.03125) {
                    ++this.g;
                    if (this.g > 80) {
                        a.warning(this.player.name + " was kicked for floating too long!");
                        this.disconnect("Flying is not enabled on this server");
                        return;
                    }
                }
            } else {
                this.g = 0;
            }
            this.player.onGround = packet10Flying.g;
            this.minecraftServer.serverConfigurationManager.d(this.player);
            this.player.b(this.player.locY - d, packet10Flying.g);
        }
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        this.checkMovement = false;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.player.setLocation(d, d2, d3, f, f2);
        this.player.netServerHandler.sendPacket(new Packet13PlayerLookMove(d, d2 + (double)1.62f, d2, d3, f, f2, false));
    }

    public void a(Packet14BlockDig packet14BlockDig) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        double d5;
        double d6;
        double d7;
        double d8;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        if (packet14BlockDig.e == 4) {
            this.player.N();
            return;
        }
        if (packet14BlockDig.e == 5) {
            this.player.I();
            return;
        }
        worldServer.weirdIsOpCache = worldServer.worldProvider.dimension != 0 || this.minecraftServer.serverConfigurationManager.isOp(this.player.name);
        boolean bl = worldServer.weirdIsOpCache;
        boolean bl2 = false;
        if (packet14BlockDig.e == 0) {
            bl2 = true;
        }
        if (packet14BlockDig.e == 2) {
            bl2 = true;
        }
        int n2 = packet14BlockDig.a;
        int n3 = packet14BlockDig.b;
        int n4 = packet14BlockDig.c;
        if (bl2 && (d8 = (d7 = this.player.locX - ((double)n2 + 0.5)) * d7 + (d6 = this.player.locY - ((double)n3 + 0.5) + 1.5) * d6 + (d5 = this.player.locZ - ((double)n4 + 0.5)) * d5) > 36.0) {
            return;
        }
        ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
        int n5 = MathHelper.a(n2 - chunkCoordinates.x);
        if (n5 > (n = MathHelper.a(n4 - chunkCoordinates.z))) {
            n = n5;
        }
        if (packet14BlockDig.e == 0) {
            if (n > 16 || bl) {
                this.player.itemInWorldManager.dig(n2, n3, n4, packet14BlockDig.face);
            } else {
                this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            }
        } else if (packet14BlockDig.e == 2) {
            this.player.itemInWorldManager.a(n2, n3, n4);
            if (worldServer.getTypeId(n2, n3, n4) != 0) {
                this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            }
        } else if (packet14BlockDig.e == 3 && (d4 = (d3 = this.player.locX - ((double)n2 + 0.5)) * d3 + (d2 = this.player.locY - ((double)n3 + 0.5)) * d2 + (d = this.player.locZ - ((double)n4 + 0.5)) * d) < 256.0) {
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
        }
        worldServer.weirdIsOpCache = false;
    }

    public void a(Packet15Place packet15Place) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        ItemStack itemStack = this.player.inventory.getItemInHand();
        worldServer.weirdIsOpCache = worldServer.worldProvider.dimension != 0 || this.minecraftServer.serverConfigurationManager.isOp(this.player.name);
        boolean bl = worldServer.weirdIsOpCache;
        if (packet15Place.face == 255) {
            if (itemStack == null) {
                return;
            }
            this.player.itemInWorldManager.useItem(this.player, worldServer, itemStack);
        } else {
            int n;
            int n2 = packet15Place.a;
            int n3 = packet15Place.b;
            int n4 = packet15Place.c;
            int n5 = packet15Place.face;
            ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
            int n6 = MathHelper.a(n2 - chunkCoordinates.x);
            if (n6 > (n = MathHelper.a(n4 - chunkCoordinates.z))) {
                n = n6;
            }
            if (this.checkMovement && this.player.e((double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5) < 64.0 && (n > 16 || bl)) {
                this.player.itemInWorldManager.interact(this.player, worldServer, itemStack, n2, n3, n4, n5);
            }
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            if (n5 == 0) {
                --n3;
            }
            if (n5 == 1) {
                ++n3;
            }
            if (n5 == 2) {
                --n4;
            }
            if (n5 == 3) {
                ++n4;
            }
            if (n5 == 4) {
                --n2;
            }
            if (n5 == 5) {
                ++n2;
            }
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
        }
        itemStack = this.player.inventory.getItemInHand();
        if (itemStack != null && itemStack.count == 0) {
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = null;
            itemStack = null;
        }
        if (itemStack == null || itemStack.l() == 0) {
            this.player.h = true;
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = ItemStack.b(this.player.inventory.items[this.player.inventory.itemInHandIndex]);
            Slot slot = this.player.activeContainer.a(this.player.inventory, this.player.inventory.itemInHandIndex);
            this.player.activeContainer.a();
            this.player.h = false;
            if (!ItemStack.equals(this.player.inventory.getItemInHand(), packet15Place.itemstack)) {
                this.sendPacket(new Packet103SetSlot(this.player.activeContainer.windowId, slot.c, this.player.inventory.getItemInHand()));
            }
        }
        worldServer.weirdIsOpCache = false;
    }

    public void a(String string, Object[] objectArray) {
        a.info(this.player.name + " lost connection: " + string);
        this.minecraftServer.serverConfigurationManager.sendAll(new Packet3Chat("\u00a7e" + this.player.name + " left the game."));
        this.minecraftServer.serverConfigurationManager.disconnect(this.player);
        this.disconnected = true;
    }

    public void a(Packet packet) {
        a.warning(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.disconnect("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.networkManager.queue(packet);
    }

    public void a(Packet16BlockItemSwitch packet16BlockItemSwitch) {
        if (packet16BlockItemSwitch.itemInHandIndex < 0 || packet16BlockItemSwitch.itemInHandIndex >= InventoryPlayer.h()) {
            a.warning(this.player.name + " tried to set an invalid carried item");
            return;
        }
        this.player.inventory.itemInHandIndex = packet16BlockItemSwitch.itemInHandIndex;
    }

    public void a(Packet3Chat packet3Chat) {
        String string = packet3Chat.message;
        if (string.length() > 100) {
            this.disconnect("Chat message too long");
            return;
        }
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            if (FontAllowedCharacters.allowedCharacters.indexOf(string.charAt(i)) >= 0) continue;
            this.disconnect("Illegal characters in chat");
            return;
        }
        if (string.startsWith("/")) {
            this.handleCommand(string);
        } else {
            string = "<" + this.player.name + "> " + string;
            a.info(string);
            this.minecraftServer.serverConfigurationManager.sendAll(new Packet3Chat(string));
        }
    }

    private void handleCommand(String string) {
        if (string.toLowerCase().startsWith("/me ")) {
            string = "* " + this.player.name + " " + string.substring(string.indexOf(" ")).trim();
            a.info(string);
            this.minecraftServer.serverConfigurationManager.sendAll(new Packet3Chat(string));
        } else if (string.toLowerCase().startsWith("/kill")) {
            this.player.damageEntity(DamageSource.GENERIC, 1000);
        } else if (string.toLowerCase().startsWith("/tell ")) {
            String[] stringArray = string.split(" ");
            if (stringArray.length >= 3) {
                string = string.substring(string.indexOf(" ")).trim();
                string = string.substring(string.indexOf(" ")).trim();
                string = "\u00a77" + this.player.name + " whispers " + string;
                a.info(string + " to " + stringArray[1]);
                if (!this.minecraftServer.serverConfigurationManager.a(stringArray[1], new Packet3Chat(string))) {
                    this.sendPacket(new Packet3Chat("\u00a7cThere's no player by that name online."));
                }
            }
        } else if (this.minecraftServer.serverConfigurationManager.isOp(this.player.name)) {
            String string2 = string.substring(1);
            a.info(this.player.name + " issued server command: " + string2);
            this.minecraftServer.issueCommand(string2, this);
        } else {
            String string3 = string.substring(1);
            a.info(this.player.name + " tried command: " + string3);
        }
    }

    public void a(Packet18ArmAnimation packet18ArmAnimation) {
        if (packet18ArmAnimation.b == 1) {
            this.player.r_();
        }
    }

    public void a(Packet19EntityAction packet19EntityAction) {
        if (packet19EntityAction.animation == 1) {
            this.player.setSneak(true);
        } else if (packet19EntityAction.animation == 2) {
            this.player.setSneak(false);
        } else if (packet19EntityAction.animation == 4) {
            this.player.setSprinting(true);
        } else if (packet19EntityAction.animation == 5) {
            this.player.setSprinting(false);
        } else if (packet19EntityAction.animation == 3) {
            this.player.a(false, true, true);
            this.checkMovement = false;
        }
    }

    public void a(Packet255KickDisconnect packet255KickDisconnect) {
        this.networkManager.a("disconnect.quitting", new Object[0]);
    }

    public int b() {
        return this.networkManager.e();
    }

    public void sendMessage(String string) {
        this.sendPacket(new Packet3Chat("\u00a77" + string));
    }

    public String getName() {
        return this.player.name;
    }

    public void a(Packet7UseEntity packet7UseEntity) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        Entity entity = worldServer.getEntity(packet7UseEntity.target);
        if (entity != null && this.player.g(entity) && this.player.i(entity) < 36.0) {
            if (packet7UseEntity.c == 0) {
                this.player.e(entity);
            } else if (packet7UseEntity.c == 1) {
                this.player.f(entity);
            }
        }
    }

    public void a(Packet9Respawn packet9Respawn) {
        if (this.player.j) {
            this.player = this.minecraftServer.serverConfigurationManager.moveToWorld(this.player, 0, true);
        } else {
            if (this.player.getHealth() > 0) {
                return;
            }
            this.player = this.minecraftServer.serverConfigurationManager.moveToWorld(this.player, 0, false);
        }
    }

    public void a(Packet101CloseWindow packet101CloseWindow) {
        this.player.D();
    }

    public void a(Packet102WindowClick packet102WindowClick) {
        if (this.player.activeContainer.windowId == packet102WindowClick.a && this.player.activeContainer.c(this.player)) {
            ItemStack itemStack = this.player.activeContainer.a(packet102WindowClick.b, packet102WindowClick.c, packet102WindowClick.f, this.player);
            if (ItemStack.equals(packet102WindowClick.e, itemStack)) {
                this.player.netServerHandler.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, true));
                this.player.h = true;
                this.player.activeContainer.a();
                this.player.C();
                this.player.h = false;
            } else {
                this.q.a(this.player.activeContainer.windowId, packet102WindowClick.d);
                this.player.netServerHandler.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, false));
                this.player.activeContainer.a((EntityHuman)this.player, false);
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                for (int i = 0; i < this.player.activeContainer.e.size(); ++i) {
                    arrayList.add(((Slot)this.player.activeContainer.e.get(i)).getItem());
                }
                this.player.a(this.player.activeContainer, arrayList);
            }
        }
    }

    public void a(Packet108 packet108) {
        if (this.player.activeContainer.windowId == packet108.a && this.player.activeContainer.c(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, packet108.b);
            this.player.activeContainer.a();
        }
    }

    public void a(Packet107SetCreativeSlot packet107SetCreativeSlot) {
        if (this.player.itemInWorldManager.b()) {
            boolean bl;
            boolean bl2 = packet107SetCreativeSlot.a < 0;
            ItemStack itemStack = packet107SetCreativeSlot.b;
            boolean bl3 = packet107SetCreativeSlot.a >= 36 && packet107SetCreativeSlot.a < 36 + InventoryPlayer.h();
            boolean bl4 = itemStack == null || itemStack.id < Item.byId.length && itemStack.id >= 0 && Item.byId[itemStack.id] != null;
            boolean bl5 = bl = itemStack == null || itemStack.getData() >= 0 && itemStack.getData() >= 0 && itemStack.count <= 64 && itemStack.count > 0;
            if (bl3 && bl4 && bl) {
                if (itemStack == null) {
                    this.player.defaultContainer.a(packet107SetCreativeSlot.a, null);
                } else {
                    this.player.defaultContainer.a(packet107SetCreativeSlot.a, itemStack);
                }
                this.player.defaultContainer.a((EntityHuman)this.player, true);
            } else if (bl2 && bl4 && bl) {
                this.player.b(itemStack);
            }
        }
    }

    public void a(Packet106Transaction packet106Transaction) {
        Short s = (Short)this.q.a(this.player.activeContainer.windowId);
        if (s != null && packet106Transaction.b == s && this.player.activeContainer.windowId == packet106Transaction.a && !this.player.activeContainer.c(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, true);
        }
    }

    public void a(Packet130UpdateSign packet130UpdateSign) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        if (worldServer.isLoaded(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z)) {
            int n;
            int n2;
            int n3;
            TileEntitySign tileEntitySign;
            TileEntity tileEntity = worldServer.getTileEntity(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z);
            if (tileEntity instanceof TileEntitySign && !(tileEntitySign = (TileEntitySign)tileEntity).c()) {
                this.minecraftServer.warning("Player " + this.player.name + " just tried to change non-editable sign");
                return;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 1;
                if (packet130UpdateSign.lines[n3].length() > 15) {
                    n2 = 0;
                } else {
                    for (n = 0; n < packet130UpdateSign.lines[n3].length(); ++n) {
                        if (FontAllowedCharacters.allowedCharacters.indexOf(packet130UpdateSign.lines[n3].charAt(n)) >= 0) continue;
                        n2 = 0;
                    }
                }
                if (n2 != 0) continue;
                packet130UpdateSign.lines[n3] = "!?";
            }
            if (tileEntity instanceof TileEntitySign) {
                n3 = packet130UpdateSign.x;
                n2 = packet130UpdateSign.y;
                n = packet130UpdateSign.z;
                TileEntitySign tileEntitySign2 = (TileEntitySign)tileEntity;
                for (int i = 0; i < 4; ++i) {
                    tileEntitySign2.lines[i] = packet130UpdateSign.lines[i];
                }
                tileEntitySign2.update();
                worldServer.notify(n3, n2, n);
            }
        }
    }

    public void a(Packet0KeepAlive packet0KeepAlive) {
        if (packet0KeepAlive.a == this.i) {
            int n = (int)(System.nanoTime() / 1000000L - this.j);
            this.player.i = (this.player.i * 3 + n) / 4;
        }
    }

    public boolean c() {
        return true;
    }
}

