/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.Item;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public final class ItemStack {
    public int count = 0;
    public int b;
    public int id;
    public NBTTagCompound tag;
    private int damage;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int n) {
        this(block.id, n, 0);
    }

    public ItemStack(Block block, int n, int n2) {
        this(block.id, n, n2);
    }

    public ItemStack(Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(Item item, int n) {
        this(item.id, n, 0);
    }

    public ItemStack(Item item, int n, int n2) {
        this(item.id, n, n2);
    }

    public ItemStack(int n, int n2, int n3) {
        this.id = n;
        this.count = n2;
        this.damage = n3;
    }

    public static ItemStack a(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = new ItemStack();
        itemStack.c(nBTTagCompound);
        return itemStack.getItem() != null ? itemStack : null;
    }

    private ItemStack() {
    }

    public ItemStack a(int n) {
        ItemStack itemStack = new ItemStack(this.id, n, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.b();
        }
        this.count -= n;
        return itemStack;
    }

    public Item getItem() {
        return Item.byId[this.id];
    }

    public boolean placeItem(EntityHuman entityHuman, World world, int n, int n2, int n3, int n4) {
        boolean bl = this.getItem().a(this, entityHuman, world, n, n2, n3, n4);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
        return bl;
    }

    public float a(Block block) {
        return this.getItem().a(this, block);
    }

    public ItemStack a(World world, EntityHuman entityHuman) {
        return this.getItem().a(this, world, entityHuman);
    }

    public ItemStack b(World world, EntityHuman entityHuman) {
        return this.getItem().b(this, world, entityHuman);
    }

    public NBTTagCompound b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("id", (short)this.id);
        nBTTagCompound.a("Count", (byte)this.count);
        nBTTagCompound.a("Damage", (short)this.damage);
        if (this.tag != null) {
            nBTTagCompound.a("tag", (NBTBase)this.tag);
        }
        return nBTTagCompound;
    }

    public void c(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.e("id");
        this.count = nBTTagCompound.d("Count");
        this.damage = nBTTagCompound.e("Damage");
        if (nBTTagCompound.hasKey("tag")) {
            this.tag = nBTTagCompound.l("tag");
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.d() || !this.f());
    }

    public boolean d() {
        return Item.byId[this.id].getMaxDurability() > 0;
    }

    public boolean usesData() {
        return Item.byId[this.id].e();
    }

    public boolean f() {
        return this.d() && this.damage > 0;
    }

    public int g() {
        return this.damage;
    }

    public int getData() {
        return this.damage;
    }

    public void b(int n) {
        this.damage = n;
    }

    public int i() {
        return Item.byId[this.id].getMaxDurability();
    }

    public void damage(int n, EntityLiving entityLiving) {
        int n2;
        if (!this.d()) {
            return;
        }
        if (n > 0 && entityLiving instanceof EntityHuman && (n2 = EnchantmentManager.c(((EntityHuman)entityLiving).inventory)) > 0 && entityLiving.world.random.nextInt(n2 + 1) > 0) {
            return;
        }
        this.damage += n;
        if (this.damage > this.i()) {
            entityLiving.c(this);
            if (entityLiving instanceof EntityHuman) {
                ((EntityHuman)entityLiving).a(StatisticList.F[this.id], 1);
            }
            --this.count;
            if (this.count < 0) {
                this.count = 0;
            }
            this.damage = 0;
        }
    }

    public void a(EntityLiving entityLiving, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, entityLiving, (EntityLiving)entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public void a(int n, int n2, int n3, int n4, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, n, n2, n3, n4, entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public int a(Entity entity) {
        return Item.byId[this.id].a(entity);
    }

    public boolean b(Block block) {
        return Item.byId[this.id].a(block);
    }

    public void a(EntityHuman entityHuman) {
    }

    public void a(EntityLiving entityLiving) {
        Item.byId[this.id].a(this, entityLiving);
    }

    public ItemStack cloneItemStack() {
        ItemStack itemStack = new ItemStack(this.id, this.count, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.b();
            if (!itemStack.tag.equals(this.tag)) {
                return itemStack;
            }
        }
        return itemStack;
    }

    public static boolean equals(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null && itemStack2 == null) {
            return true;
        }
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        return itemStack.d(itemStack2);
    }

    private boolean d(ItemStack itemStack) {
        if (this.count != itemStack.count) {
            return false;
        }
        if (this.id != itemStack.id) {
            return false;
        }
        if (this.damage != itemStack.damage) {
            return false;
        }
        if (this.tag == null && itemStack.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals(itemStack.tag);
    }

    public boolean doMaterialsMatch(ItemStack itemStack) {
        return this.id == itemStack.id && this.damage == itemStack.damage;
    }

    public String k() {
        return Item.byId[this.id].a(this);
    }

    public static ItemStack b(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.cloneItemStack();
    }

    public String toString() {
        return this.count + "x" + Item.byId[this.id].b() + "@" + this.damage;
    }

    public void a(World world, Entity entity, int n, boolean bl) {
        if (this.b > 0) {
            --this.b;
        }
        Item.byId[this.id].a(this, world, entity, n, bl);
    }

    public void c(World world, EntityHuman entityHuman) {
        entityHuman.a(StatisticList.D[this.id], this.count);
        Item.byId[this.id].d(this, world, entityHuman);
    }

    public boolean c(ItemStack itemStack) {
        return this.id == itemStack.id && this.count == itemStack.count && this.damage == itemStack.damage;
    }

    public int l() {
        return this.getItem().c(this);
    }

    public EnumAnimation m() {
        return this.getItem().d(this);
    }

    public void a(World world, EntityHuman entityHuman, int n) {
        this.getItem().a(this, world, entityHuman, n);
    }

    public boolean n() {
        return this.tag != null;
    }

    public NBTTagCompound o() {
        return this.tag;
    }

    public NBTTagList p() {
        if (this.tag == null) {
            return null;
        }
        return (NBTTagList)this.tag.b("ench");
    }

    public void d(NBTTagCompound nBTTagCompound) {
        if (Item.byId[this.id].getMaxStackSize() != 1) {
            throw new IllegalArgumentException("Cannot add tag data to a stackable item");
        }
        this.tag = nBTTagCompound;
    }

    public boolean q() {
        if (!this.getItem().e(this)) {
            return false;
        }
        return !this.r();
    }

    public void a(Enchantment enchantment, int n) {
        if (this.tag == null) {
            this.d(new NBTTagCompound());
        }
        if (!this.tag.hasKey("ench")) {
            this.tag.a("ench", new NBTTagList("ench"));
        }
        NBTTagList nBTTagList = (NBTTagList)this.tag.b("ench");
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.a("id", (short)enchantment.id);
        nBTTagCompound.a("lvl", (short)((byte)n));
        nBTTagList.a(nBTTagCompound);
    }

    public boolean r() {
        return this.tag != null && this.tag.hasKey("ench");
    }
}

