/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.Item;
import net.minecraft.server.ItemFood;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathEntity;
import net.minecraft.server.World;

public class EntityWolf
extends EntityAnimal {
    private boolean a = false;
    private float b;
    private float c;
    private boolean g;
    private boolean h;
    private float i;
    private float j;

    public EntityWolf(World world) {
        super(world);
        this.texture = "/mob/wolf.png";
        this.b(0.8f, 0.8f);
        this.aY = 1.1f;
    }

    public int getMaxHealth() {
        if (this.isTamed()) {
            return 20;
        }
        return 8;
    }

    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)0);
        this.datawatcher.a(17, "");
        this.datawatcher.a(18, new Integer(this.getHealth()));
    }

    protected boolean g_() {
        return false;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Angry", this.isAngry());
        nBTTagCompound.a("Sitting", this.isSitting());
        if (this.getOwnerName() == null) {
            nBTTagCompound.setString("Owner", "");
        } else {
            nBTTagCompound.setString("Owner", this.getOwnerName());
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setAngry(nBTTagCompound.n("Angry"));
        this.setSitting(nBTTagCompound.n("Sitting"));
        String string = nBTTagCompound.getString("Owner");
        if (string.length() > 0) {
            this.setOwnerName(string);
            this.setTamed(true);
        }
    }

    protected boolean d_() {
        return this.isAngry();
    }

    protected String c_() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTamed() && this.datawatcher.getInt(18) < 10) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    protected String m() {
        return "mob.wolf.hurt";
    }

    protected String n() {
        return "mob.wolf.death";
    }

    protected float o() {
        return 0.4f;
    }

    protected int e() {
        return -1;
    }

    protected void m_() {
        List list;
        super.m_();
        if (!this.e && !this.D() && this.isTamed() && this.vehicle == null) {
            EntityHuman entityHuman = this.world.a(this.getOwnerName());
            if (entityHuman != null) {
                float f = entityHuman.h(this);
                if (f > 5.0f) {
                    this.c(entityHuman, f);
                }
            } else if (!this.az()) {
                this.setSitting(true);
            }
        } else if (!(this.target != null || this.D() || this.isTamed() || this.world.random.nextInt(100) != 0 || (list = this.world.a(EntitySheep.class, AxisAlignedBB.b(this.locX, this.locY, this.locZ, this.locX + 1.0, this.locY + 1.0, this.locZ + 1.0).b(16.0, 4.0, 16.0))).isEmpty())) {
            this.setTarget((Entity)list.get(this.world.random.nextInt(list.size())));
        }
        if (this.az()) {
            this.setSitting(false);
        }
        if (!this.world.isStatic) {
            this.datawatcher.watch(18, this.getHealth());
        }
    }

    public void d() {
        Entity entity;
        super.d();
        this.a = false;
        if (this.al() && !this.D() && !this.isAngry() && (entity = this.am()) instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)entity;
            ItemStack itemStack = entityHuman.inventory.getItemInHand();
            if (itemStack != null) {
                if (!this.isTamed() && itemStack.id == Item.BONE.id) {
                    this.a = true;
                } else if (this.isTamed() && Item.byId[itemStack.id] instanceof ItemFood) {
                    this.a = ((ItemFood)Item.byId[itemStack.id]).p();
                }
            }
        }
        if (!this.aj && this.g && !this.h && !this.D() && this.onGround) {
            this.h = true;
            this.i = 0.0f;
            this.j = 0.0f;
            this.world.a(this, (byte)8);
        }
    }

    public void w_() {
        super.w_();
        this.c = this.b;
        this.b = this.a ? (this.b += (1.0f - this.b) * 0.4f) : (this.b += (0.0f - this.b) * 0.4f);
        if (this.a) {
            this.aZ = 10;
        }
        if (this.ay()) {
            this.g = true;
            this.h = false;
            this.i = 0.0f;
            this.j = 0.0f;
        } else if ((this.g || this.h) && this.h) {
            if (this.i == 0.0f) {
                this.world.makeSound(this, "mob.wolf.shake", this.o(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.j = this.i;
            this.i += 0.05f;
            if (this.j >= 2.0f) {
                this.g = false;
                this.h = false;
                this.j = 0.0f;
                this.i = 0.0f;
            }
            if (this.i > 0.4f) {
                float f = (float)this.boundingBox.b;
                int n = (int)(MathHelper.sin((this.i - 0.4f) * (float)Math.PI) * 7.0f);
                for (int i = 0; i < n; ++i) {
                    float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length * 0.5f;
                    float f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length * 0.5f;
                    this.world.a("splash", this.locX + (double)f2, f + 0.8f, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
            }
        }
    }

    public float x() {
        return this.width * 0.8f;
    }

    protected int q_() {
        if (this.isSitting()) {
            return 20;
        }
        return super.q_();
    }

    private void c(Entity entity, float f) {
        PathEntity pathEntity = this.world.findPath(this, entity, 16.0f);
        if (pathEntity == null && f > 12.0f) {
            int n = MathHelper.floor(entity.locX) - 2;
            int n2 = MathHelper.floor(entity.locZ) - 2;
            int n3 = MathHelper.floor(entity.boundingBox.b);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    if (i >= 1 && j >= 1 && i <= 3 && j <= 3 || !this.world.e(n + i, n3 - 1, n2 + j) || this.world.e(n + i, n3, n2 + j) || this.world.e(n + i, n3 + 1, n2 + j)) continue;
                    this.setPositionRotation((float)(n + i) + 0.5f, n3, (float)(n2 + j) + 0.5f, this.yaw, this.pitch);
                    return;
                }
            }
        } else {
            this.setPathEntity(pathEntity);
        }
    }

    protected boolean w() {
        return this.isSitting() || this.h;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        Entity entity = damageSource.getEntity();
        this.setSitting(false);
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            n = (n + 1) / 2;
        }
        if (super.damageEntity(damageSource, n)) {
            if (!this.isTamed() && !this.isAngry()) {
                if (entity instanceof EntityHuman) {
                    this.setAngry(true);
                    this.target = entity;
                }
                if (entity instanceof EntityArrow && ((EntityArrow)entity).shooter != null) {
                    entity = ((EntityArrow)entity).shooter;
                }
                if (entity instanceof EntityLiving) {
                    List list = this.world.a(EntityWolf.class, AxisAlignedBB.b(this.locX, this.locY, this.locZ, this.locX + 1.0, this.locY + 1.0, this.locZ + 1.0).b(16.0, 4.0, 16.0));
                    for (Entity entity2 : list) {
                        EntityWolf entityWolf = (EntityWolf)entity2;
                        if (entityWolf.isTamed() || entityWolf.target != null) continue;
                        entityWolf.target = entity;
                        if (!(entity instanceof EntityHuman)) continue;
                        entityWolf.setAngry(true);
                    }
                }
            } else if (entity != this && entity != null) {
                if (this.isTamed() && entity instanceof EntityHuman && ((EntityHuman)entity).name.equalsIgnoreCase(this.getOwnerName())) {
                    return true;
                }
                this.target = entity;
            }
            return true;
        }
        return false;
    }

    protected Entity findTarget() {
        if (this.isAngry()) {
            return this.world.findNearbyPlayer(this, 16.0);
        }
        return null;
    }

    protected void a(Entity entity, float f) {
        if (f > 2.0f && f < 6.0f && this.random.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                float f2 = MathHelper.a(d * d + d2 * d2);
                this.motX = d / (double)f2 * 0.5 * (double)0.8f + this.motX * (double)0.2f;
                this.motZ = d2 / (double)f2 * 0.5 * (double)0.8f + this.motZ * (double)0.2f;
                this.motY = 0.4f;
            }
        } else if ((double)f < 1.5 && entity.boundingBox.e > this.boundingBox.b && entity.boundingBox.b < this.boundingBox.e) {
            this.attackTicks = 20;
            int n = 2;
            if (this.isTamed()) {
                n = 4;
            }
            entity.damageEntity(DamageSource.mobAttack(this), n);
        }
    }

    public boolean b(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (!this.isTamed()) {
            if (itemStack != null && itemStack.id == Item.BONE.id && !this.isAngry()) {
                --itemStack.count;
                if (itemStack.count <= 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                if (!this.world.isStatic) {
                    if (this.random.nextInt(3) == 0) {
                        this.setTamed(true);
                        this.setPathEntity(null);
                        this.setSitting(true);
                        this.setHealth(20);
                        this.setOwnerName(entityHuman.name);
                        this.a(true);
                        this.world.a(this, (byte)7);
                    } else {
                        this.a(false);
                        this.world.a(this, (byte)6);
                    }
                }
                return true;
            }
        } else {
            ItemFood itemFood;
            if (itemStack != null && Item.byId[itemStack.id] instanceof ItemFood && (itemFood = (ItemFood)Item.byId[itemStack.id]).p() && this.datawatcher.getInt(18) < 20) {
                --itemStack.count;
                this.d(itemFood.n());
                if (itemStack.count <= 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                return true;
            }
            if (entityHuman.name.equalsIgnoreCase(this.getOwnerName())) {
                if (!this.world.isStatic) {
                    this.setSitting(!this.isSitting());
                    this.aW = false;
                    this.setPathEntity(null);
                }
                return true;
            }
        }
        return super.b(entityHuman);
    }

    void a(boolean bl) {
        String string = "heart";
        if (!bl) {
            string = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            this.world.a(string, this.locX + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, this.locY + 0.5 + (double)(this.random.nextFloat() * this.width), this.locZ + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, d, d2, d3);
        }
    }

    public int p() {
        return 8;
    }

    public String getOwnerName() {
        return this.datawatcher.getString(17);
    }

    public void setOwnerName(String string) {
        this.datawatcher.watch(17, string);
    }

    public boolean isSitting() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setSitting(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFE));
        }
    }

    public boolean isAngry() {
        return (this.datawatcher.getByte(16) & 2) != 0;
    }

    public void setAngry(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 2));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFD));
        }
    }

    public boolean isTamed() {
        return (this.datawatcher.getByte(16) & 4) != 0;
    }

    public void setTamed(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 4));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFB));
        }
    }

    protected EntityAnimal createChild(EntityAnimal entityAnimal) {
        return new EntityWolf(this.world);
    }
}

