/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityPig
extends EntityAnimal {
    public EntityPig(World world) {
        super(world);
        this.texture = "/mob/pig.png";
        this.b(0.9f, 0.9f);
    }

    public int getMaxHealth() {
        return 10;
    }

    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)0);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Saddle", this.hasSaddle());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSaddle(nBTTagCompound.n("Saddle"));
    }

    protected String c_() {
        return "mob.pig";
    }

    protected String m() {
        return "mob.pig";
    }

    protected String n() {
        return "mob.pigdeath";
    }

    public boolean b(EntityHuman entityHuman) {
        if (!super.b(entityHuman)) {
            if (this.hasSaddle() && !this.world.isStatic && (this.passenger == null || this.passenger == entityHuman)) {
                entityHuman.mount(this);
                return true;
            }
            return false;
        }
        return true;
    }

    protected int e() {
        if (this.z()) {
            return Item.GRILLED_PORK.id;
        }
        return Item.PORK.id;
    }

    public boolean hasSaddle() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setSaddle(boolean bl) {
        if (bl) {
            this.datawatcher.watch(16, (byte)1);
        } else {
            this.datawatcher.watch(16, (byte)0);
        }
    }

    public void a(EntityWeatherStorm entityWeatherStorm) {
        if (this.world.isStatic) {
            return;
        }
        EntityPigZombie entityPigZombie = new EntityPigZombie(this.world);
        entityPigZombie.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        this.world.addEntity(entityPigZombie);
        this.die();
    }

    protected void b(float f) {
        super.b(f);
        if (f > 5.0f && this.passenger instanceof EntityHuman) {
            ((EntityHuman)this.passenger).a(AchievementList.u);
        }
    }

    protected EntityAnimal createChild(EntityAnimal entityAnimal) {
        return new EntityPig(this.world);
    }
}

