/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockMinecartTrack;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] items = new ItemStack[36];
    private int e = 0;
    private boolean f = false;
    public int type;
    public double b;
    public double c;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int h;
    private double i;
    private double j;
    private double k;
    private double l;
    private double m;

    public EntityMinecart(World world) {
        super(world);
        this.bc = true;
        this.b(0.98f, 0.7f);
        this.height = this.width / 2.0f;
    }

    protected boolean g_() {
        return false;
    }

    protected void b() {
        this.datawatcher.a(16, new Byte(0));
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(1));
        this.datawatcher.a(19, new Integer(0));
    }

    public AxisAlignedBB a_(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB h_() {
        return null;
    }

    public boolean f_() {
        return true;
    }

    public EntityMinecart(World world, double d, double d2, double d3, int n) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
        this.type = n;
    }

    public double q() {
        return (double)this.width * 0.0 - (double)0.3f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic || this.dead) {
            return true;
        }
        this.d(-this.m());
        this.c(10);
        this.aB();
        this.setDamage(this.getDamage() + n * 10);
        if (this.getDamage() > 40) {
            if (this.passenger != null) {
                this.passenger.mount(this);
            }
            this.die();
            this.a(Item.MINECART.id, 1, 0.0f);
            if (this.type == 1) {
                EntityMinecart entityMinecart = this;
                for (int i = 0; i < entityMinecart.getSize(); ++i) {
                    ItemStack itemStack = entityMinecart.getItem(i);
                    if (itemStack == null) continue;
                    float f = this.random.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                    float f3 = this.random.nextFloat() * 0.8f + 0.1f;
                    while (itemStack.count > 0) {
                        int n2 = this.random.nextInt(21) + 10;
                        if (n2 > itemStack.count) {
                            n2 = itemStack.count;
                        }
                        itemStack.count -= n2;
                        EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n2, itemStack.getData()));
                        float f4 = 0.05f;
                        entityItem.motX = (float)this.random.nextGaussian() * f4;
                        entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                        entityItem.motZ = (float)this.random.nextGaussian() * f4;
                        this.world.addEntity(entityItem);
                    }
                }
                this.a(Block.CHEST.id, 1, 0.0f);
            } else if (this.type == 2) {
                this.a(Block.FURNACE.id, 1, 0.0f);
            }
        }
        return true;
    }

    public boolean e_() {
        return !this.dead;
    }

    public void die() {
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            float f3 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemStack.count > 0) {
                int n = this.random.nextInt(21) + 10;
                if (n > itemStack.count) {
                    n = itemStack.count;
                }
                itemStack.count -= n;
                EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n, itemStack.getData()));
                float f4 = 0.05f;
                entityItem.motX = (float)this.random.nextGaussian() * f4;
                entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                entityItem.motZ = (float)this.random.nextGaussian() * f4;
                this.world.addEntity(entityItem);
            }
        }
        super.die();
    }

    public void w_() {
        double d;
        int n;
        int n2;
        if (this.l() > 0) {
            this.c(this.l() - 1);
        }
        if (this.getDamage() > 0) {
            this.setDamage(this.getDamage() - 1);
        }
        if (this.j() && this.random.nextInt(4) == 0) {
            this.world.a("largesmoke", this.locX, this.locY + 0.8, this.locZ, 0.0, 0.0, 0.0);
        }
        if (this.world.isStatic) {
            if (this.h > 0) {
                double d2;
                double d3 = this.locX + (this.i - this.locX) / (double)this.h;
                double d4 = this.locY + (this.j - this.locY) / (double)this.h;
                double d5 = this.locZ + (this.k - this.locZ) / (double)this.h;
                for (d2 = this.l - (double)this.yaw; d2 < -180.0; d2 += 360.0) {
                }
                while (d2 >= 180.0) {
                    d2 -= 360.0;
                }
                this.yaw = (float)((double)this.yaw + d2 / (double)this.h);
                this.pitch = (float)((double)this.pitch + (this.m - (double)this.pitch) / (double)this.h);
                --this.h;
                this.setPosition(d3, d4, d5);
                this.c(this.yaw, this.pitch);
            } else {
                this.setPosition(this.locX, this.locY, this.locZ);
                this.c(this.yaw, this.pitch);
            }
            return;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.04f;
        int n3 = MathHelper.floor(this.locX);
        if (BlockMinecartTrack.g(this.world, n3, (n2 = MathHelper.floor(this.locY)) - 1, n = MathHelper.floor(this.locZ))) {
            --n2;
        }
        double d6 = 0.4;
        double d7 = 0.0078125;
        int n4 = this.world.getTypeId(n3, n2, n);
        if (BlockMinecartTrack.d(n4)) {
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            Vec3D vec3D = this.h(this.locX, this.locY, this.locZ);
            int n5 = this.world.getData(n3, n2, n);
            this.locY = n2;
            boolean bl = false;
            boolean bl2 = false;
            if (n4 == Block.GOLDEN_RAIL.id) {
                bl = (n5 & 8) != 0;
                boolean bl3 = bl2 = !bl;
            }
            if (((BlockMinecartTrack)Block.byId[n4]).h()) {
                n5 &= 7;
            }
            if (n5 >= 2 && n5 <= 5) {
                this.locY = n2 + 1;
            }
            if (n5 == 2) {
                this.motX -= d7;
            }
            if (n5 == 3) {
                this.motX += d7;
            }
            if (n5 == 4) {
                this.motZ += d7;
            }
            if (n5 == 5) {
                this.motZ -= d7;
            }
            int[][] nArray = matrix[n5];
            double d13 = nArray[1][0] - nArray[0][0];
            double d14 = nArray[1][2] - nArray[0][2];
            double d15 = Math.sqrt(d13 * d13 + d14 * d14);
            double d16 = this.motX * d13 + this.motZ * d14;
            if (d16 < 0.0) {
                d13 = -d13;
                d14 = -d14;
            }
            double d17 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            this.motX = d17 * d13 / d15;
            this.motZ = d17 * d14 / d15;
            if (bl2) {
                d12 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                if (d12 < 0.03) {
                    this.motX *= 0.0;
                    this.motY *= 0.0;
                    this.motZ *= 0.0;
                } else {
                    this.motX *= 0.5;
                    this.motY *= 0.0;
                    this.motZ *= 0.5;
                }
            }
            d12 = 0.0;
            double d18 = (double)n3 + 0.5 + (double)nArray[0][0] * 0.5;
            double d19 = (double)n + 0.5 + (double)nArray[0][2] * 0.5;
            double d20 = (double)n3 + 0.5 + (double)nArray[1][0] * 0.5;
            double d21 = (double)n + 0.5 + (double)nArray[1][2] * 0.5;
            d13 = d20 - d18;
            d14 = d21 - d19;
            if (d13 == 0.0) {
                this.locX = (double)n3 + 0.5;
                d12 = this.locZ - (double)n;
            } else if (d14 == 0.0) {
                this.locZ = (double)n + 0.5;
                d12 = this.locX - (double)n3;
            } else {
                d11 = this.locX - d18;
                d10 = this.locZ - d19;
                d12 = d9 = (d11 * d13 + d10 * d14) * 2.0;
            }
            this.locX = d18 + d13 * d12;
            this.locZ = d19 + d14 * d12;
            this.setPosition(this.locX, this.locY + (double)this.height, this.locZ);
            d11 = this.motX;
            d10 = this.motZ;
            if (this.passenger != null) {
                d11 *= 0.75;
                d10 *= 0.75;
            }
            if (d11 < -d6) {
                d11 = -d6;
            }
            if (d11 > d6) {
                d11 = d6;
            }
            if (d10 < -d6) {
                d10 = -d6;
            }
            if (d10 > d6) {
                d10 = d6;
            }
            this.move(d11, 0.0, d10);
            if (nArray[0][1] != 0 && MathHelper.floor(this.locX) - n3 == nArray[0][0] && MathHelper.floor(this.locZ) - n == nArray[0][2]) {
                this.setPosition(this.locX, this.locY + (double)nArray[0][1], this.locZ);
            } else if (nArray[1][1] != 0 && MathHelper.floor(this.locX) - n3 == nArray[1][0] && MathHelper.floor(this.locZ) - n == nArray[1][2]) {
                this.setPosition(this.locX, this.locY + (double)nArray[1][1], this.locZ);
            }
            if (this.passenger != null) {
                this.motX *= (double)0.997f;
                this.motY *= 0.0;
                this.motZ *= (double)0.997f;
            } else {
                if (this.type == 2) {
                    d9 = MathHelper.a(this.b * this.b + this.c * this.c);
                    if (d9 > 0.01) {
                        this.b /= d9;
                        this.c /= d9;
                        double d22 = 0.04;
                        this.motX *= (double)0.8f;
                        this.motY *= 0.0;
                        this.motZ *= (double)0.8f;
                        this.motX += this.b * d22;
                        this.motZ += this.c * d22;
                    } else {
                        this.motX *= (double)0.9f;
                        this.motY *= 0.0;
                        this.motZ *= (double)0.9f;
                    }
                }
                this.motX *= (double)0.96f;
                this.motY *= 0.0;
                this.motZ *= (double)0.96f;
            }
            Vec3D vec3D2 = this.h(this.locX, this.locY, this.locZ);
            if (vec3D2 != null && vec3D != null) {
                double d23 = (vec3D.b - vec3D2.b) * 0.05;
                d17 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                if (d17 > 0.0) {
                    this.motX = this.motX / d17 * (d17 + d23);
                    this.motZ = this.motZ / d17 * (d17 + d23);
                }
                this.setPosition(this.locX, vec3D2.b, this.locZ);
            }
            int n6 = MathHelper.floor(this.locX);
            int n7 = MathHelper.floor(this.locZ);
            if (n6 != n3 || n7 != n) {
                d17 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                this.motX = d17 * (double)(n6 - n3);
                this.motZ = d17 * (double)(n7 - n);
            }
            if (this.type == 2 && (d8 = (double)MathHelper.a(this.b * this.b + this.c * this.c)) > 0.01 && this.motX * this.motX + this.motZ * this.motZ > 0.001) {
                this.b /= d8;
                this.c /= d8;
                if (this.b * this.motX + this.c * this.motZ < 0.0) {
                    this.b = 0.0;
                    this.c = 0.0;
                } else {
                    this.b = this.motX;
                    this.c = this.motZ;
                }
            }
            if (bl) {
                d8 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                if (d8 > 0.01) {
                    double d24 = 0.06;
                    this.motX += this.motX / d8 * d24;
                    this.motZ += this.motZ / d8 * d24;
                } else if (n5 == 1) {
                    if (this.world.e(n3 - 1, n2, n)) {
                        this.motX = 0.02;
                    } else if (this.world.e(n3 + 1, n2, n)) {
                        this.motX = -0.02;
                    }
                } else if (n5 == 0) {
                    if (this.world.e(n3, n2, n - 1)) {
                        this.motZ = 0.02;
                    } else if (this.world.e(n3, n2, n + 1)) {
                        this.motZ = -0.02;
                    }
                }
            }
        } else {
            if (this.motX < -d6) {
                this.motX = -d6;
            }
            if (this.motX > d6) {
                this.motX = d6;
            }
            if (this.motZ < -d6) {
                this.motZ = -d6;
            }
            if (this.motZ > d6) {
                this.motZ = d6;
            }
            if (this.onGround) {
                this.motX *= 0.5;
                this.motY *= 0.5;
                this.motZ *= 0.5;
            }
            this.move(this.motX, this.motY, this.motZ);
            if (!this.onGround) {
                this.motX *= (double)0.95f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.95f;
            }
        }
        this.pitch = 0.0f;
        double d25 = this.lastX - this.locX;
        double d26 = this.lastZ - this.locZ;
        if (d25 * d25 + d26 * d26 > 0.001) {
            this.yaw = (float)(Math.atan2(d26, d25) * 180.0 / Math.PI);
            if (this.f) {
                this.yaw += 180.0f;
            }
        }
        for (d = (double)(this.yaw - this.lastYaw); d >= 180.0; d -= 360.0) {
        }
        while (d < -180.0) {
            d += 360.0;
        }
        if (d < -170.0 || d >= 170.0) {
            this.yaw += 180.0f;
            this.f = !this.f;
        }
        this.c(this.yaw, this.pitch);
        List list = this.world.b((Entity)this, this.boundingBox.b(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == this.passenger || !entity.f_() || !(entity instanceof EntityMinecart)) continue;
                entity.collide(this);
            }
        }
        if (this.passenger != null && this.passenger.dead) {
            if (this.passenger.vehicle == this) {
                this.passenger.vehicle = null;
            }
            this.passenger = null;
        }
        if (this.e > 0) {
            --this.e;
        }
        if (this.e <= 0) {
            this.c = 0.0;
            this.b = 0.0;
        }
        this.a(this.e > 0);
    }

    public Vec3D h(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4 = MathHelper.floor(d);
        if (BlockMinecartTrack.g(this.world, n4, (n3 = MathHelper.floor(d2)) - 1, n2 = MathHelper.floor(d3))) {
            --n3;
        }
        if (BlockMinecartTrack.d(n = this.world.getTypeId(n4, n3, n2))) {
            int n5 = this.world.getData(n4, n3, n2);
            d2 = n3;
            if (((BlockMinecartTrack)Block.byId[n]).h()) {
                n5 &= 7;
            }
            if (n5 >= 2 && n5 <= 5) {
                d2 = n3 + 1;
            }
            int[][] nArray = matrix[n5];
            double d4 = 0.0;
            double d5 = (double)n4 + 0.5 + (double)nArray[0][0] * 0.5;
            double d6 = (double)n3 + 0.5 + (double)nArray[0][1] * 0.5;
            double d7 = (double)n2 + 0.5 + (double)nArray[0][2] * 0.5;
            double d8 = (double)n4 + 0.5 + (double)nArray[1][0] * 0.5;
            double d9 = (double)n3 + 0.5 + (double)nArray[1][1] * 0.5;
            double d10 = (double)n2 + 0.5 + (double)nArray[1][2] * 0.5;
            double d11 = d8 - d5;
            double d12 = (d9 - d6) * 2.0;
            double d13 = d10 - d7;
            if (d11 == 0.0) {
                d = (double)n4 + 0.5;
                d4 = d3 - (double)n2;
            } else if (d13 == 0.0) {
                d3 = (double)n2 + 0.5;
                d4 = d - (double)n4;
            } else {
                double d14;
                double d15 = d - d5;
                double d16 = d3 - d7;
                d4 = d14 = (d15 * d11 + d16 * d13) * 2.0;
            }
            d = d5 + d11 * d4;
            d2 = d6 + d12 * d4;
            d3 = d7 + d13 * d4;
            if (d12 < 0.0) {
                d2 += 1.0;
            }
            if (d12 > 0.0) {
                d2 += 0.5;
            }
            return Vec3D.create(d, d2, d3);
        }
        return null;
    }

    protected void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Type", this.type);
        if (this.type == 2) {
            nBTTagCompound.a("PushX", this.b);
            nBTTagCompound.a("PushZ", this.c);
            nBTTagCompound.a("Fuel", (short)this.e);
        } else if (this.type == 1) {
            NBTTagList nBTTagList = new NBTTagList();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.a("Slot", (byte)i);
                this.items[i].b(nBTTagCompound2);
                nBTTagList.a(nBTTagCompound2);
            }
            nBTTagCompound.a("Items", nBTTagList);
        }
    }

    protected void a(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.f("Type");
        if (this.type == 2) {
            this.b = nBTTagCompound.i("PushX");
            this.c = nBTTagCompound.i("PushZ");
            this.e = nBTTagCompound.e("Fuel");
        } else if (this.type == 1) {
            NBTTagList nBTTagList = nBTTagCompound.m("Items");
            this.items = new ItemStack[this.getSize()];
            for (int i = 0; i < nBTTagList.d(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.a(i);
                int n = nBTTagCompound2.d("Slot") & 0xFF;
                if (n < 0 || n >= this.items.length) continue;
                this.items[n] = ItemStack.a(nBTTagCompound2);
            }
        }
    }

    public void collide(Entity entity) {
        double d;
        double d2;
        double d3;
        if (this.world.isStatic) {
            return;
        }
        if (entity == this.passenger) {
            return;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityHuman) && this.type == 0 && this.motX * this.motX + this.motZ * this.motZ > 0.01 && this.passenger == null && entity.vehicle == null) {
            entity.mount(this);
        }
        if ((d3 = (d2 = entity.locX - this.locX) * d2 + (d = entity.locZ - this.locZ) * d) >= (double)1.0E-4f) {
            d3 = MathHelper.a(d3);
            d2 /= d3;
            d /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d2 *= d4;
            d *= d4;
            d2 *= (double)0.1f;
            d *= (double)0.1f;
            d2 *= (double)(1.0f - this.bO);
            d *= (double)(1.0f - this.bO);
            d2 *= 0.5;
            d *= 0.5;
            if (entity instanceof EntityMinecart) {
                Vec3D vec3D;
                double d5 = entity.locX - this.locX;
                double d6 = entity.locZ - this.locZ;
                Vec3D vec3D2 = Vec3D.create(d5, 0.0, d6).b();
                double d7 = Math.abs(vec3D2.a(vec3D = Vec3D.create(MathHelper.cos(this.yaw * (float)Math.PI / 180.0f), 0.0, MathHelper.sin(this.yaw * (float)Math.PI / 180.0f)).b()));
                if (d7 < (double)0.8f) {
                    return;
                }
                double d8 = entity.motX + this.motX;
                double d9 = entity.motZ + this.motZ;
                if (((EntityMinecart)entity).type == 2 && this.type != 2) {
                    this.motX *= (double)0.2f;
                    this.motZ *= (double)0.2f;
                    this.b_(entity.motX - d2, 0.0, entity.motZ - d);
                    entity.motX *= (double)0.95f;
                    entity.motZ *= (double)0.95f;
                } else if (((EntityMinecart)entity).type != 2 && this.type == 2) {
                    entity.motX *= (double)0.2f;
                    entity.motZ *= (double)0.2f;
                    entity.b_(this.motX + d2, 0.0, this.motZ + d);
                    this.motX *= (double)0.95f;
                    this.motZ *= (double)0.95f;
                } else {
                    this.motX *= (double)0.2f;
                    this.motZ *= (double)0.2f;
                    this.b_((d8 /= 2.0) - d2, 0.0, (d9 /= 2.0) - d);
                    entity.motX *= (double)0.2f;
                    entity.motZ *= (double)0.2f;
                    entity.b_(d8 + d2, 0.0, d9 + d);
                }
            } else {
                this.b_(-d2, 0.0, -d);
                entity.b_(d2 / 4.0, 0.0, d / 4.0);
            }
        }
    }

    public int getSize() {
        return 27;
    }

    public ItemStack getItem(int n) {
        return this.items[n];
    }

    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    public String getName() {
        return "Minecart";
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void update() {
    }

    public boolean b(EntityHuman entityHuman) {
        if (this.type == 0) {
            if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
                return true;
            }
            if (!this.world.isStatic) {
                entityHuman.mount(this);
            }
        } else if (this.type == 1) {
            if (!this.world.isStatic) {
                entityHuman.a(this);
            }
        } else if (this.type == 2) {
            ItemStack itemStack = entityHuman.inventory.getItemInHand();
            if (itemStack != null && itemStack.id == Item.COAL.id) {
                if (--itemStack.count == 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                this.e += 3600;
            }
            this.b = this.locX - entityHuman.locX;
            this.c = this.locZ - entityHuman.locZ;
        }
        return true;
    }

    public boolean a(EntityHuman entityHuman) {
        if (this.dead) {
            return false;
        }
        return !(entityHuman.i(this) > 64.0);
    }

    protected boolean j() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    protected void a(boolean bl) {
        if (bl) {
            this.datawatcher.watch(16, (byte)(this.datawatcher.getByte(16) | 1));
        } else {
            this.datawatcher.watch(16, (byte)(this.datawatcher.getByte(16) & 0xFFFFFFFE));
        }
    }

    public void f() {
    }

    public void g() {
    }

    public void setDamage(int n) {
        this.datawatcher.watch(19, n);
    }

    public int getDamage() {
        return this.datawatcher.getInt(19);
    }

    public void c(int n) {
        this.datawatcher.watch(17, n);
    }

    public int l() {
        return this.datawatcher.getInt(17);
    }

    public void d(int n) {
        this.datawatcher.watch(18, n);
    }

    public int m() {
        return this.datawatcher.getInt(18);
    }
}

