/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentDamage;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PotionBrewer;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityLiving
extends Entity {
    public int maxNoDamageTicks = 20;
    public float T;
    public float U;
    public float V = 0.0f;
    public float W = 0.0f;
    protected float X;
    protected float Y;
    protected float Z;
    protected float aa;
    protected boolean ab = true;
    protected String texture = "/mob/char.png";
    protected boolean ad = true;
    protected float ae = 0.0f;
    protected String af = null;
    protected float ag = 1.0f;
    protected int ah = 0;
    protected float ai = 0.0f;
    public boolean aj = false;
    public float ak = 0.1f;
    public float al = 0.02f;
    public float am;
    public float an;
    protected int health;
    public int ap;
    protected int aq;
    private int a;
    public int hurtTicks;
    public int as;
    public float at = 0.0f;
    public int deathTicks = 0;
    public int attackTicks = 0;
    public float aw;
    public float ax;
    protected boolean ay = false;
    protected int az;
    public int aA = -1;
    public float aB = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float aC;
    public float aD;
    public float aE;
    protected EntityHuman aF = null;
    protected int aG = 0;
    public int aH = 0;
    public int aI = 0;
    protected HashMap effects = new HashMap();
    private boolean b = true;
    private int c;
    protected int aK;
    protected double aL;
    protected double aM;
    protected double aN;
    protected double aO;
    protected double aP;
    float aQ = 0.0f;
    protected int lastDamage = 0;
    protected int aS = 0;
    protected float aT;
    protected float aU;
    protected float aV;
    protected boolean aW = false;
    protected float aX = 0.0f;
    protected float aY = 0.7f;
    private int d = 0;
    private Entity e;
    protected int aZ = 0;

    public EntityLiving(World world) {
        super(world);
        this.health = this.getMaxHealth();
        this.bc = true;
        this.U = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.T = (float)Math.random() * 12398.0f;
        this.yaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.bM = 0.5f;
    }

    protected void b() {
        this.datawatcher.a(8, this.c);
    }

    public boolean g(Entity entity) {
        return this.world.a(Vec3D.create(this.locX, this.locY + (double)this.x(), this.locZ), Vec3D.create(entity.locX, entity.locY + (double)entity.x(), entity.locZ)) == null;
    }

    public boolean e_() {
        return !this.dead;
    }

    public boolean f_() {
        return !this.dead;
    }

    public float x() {
        return this.width * 0.85f;
    }

    public int h() {
        return 80;
    }

    public void ae() {
        String string = this.c_();
        if (string != null) {
            this.world.makeSound(this, string, this.o(), this.w());
        }
    }

    public void af() {
        this.am = this.an;
        super.af();
        MethodProfiler.a("mobBaseTick");
        if (this.random.nextInt(1000) < this.a++) {
            this.a = -this.h();
            this.ae();
        }
        if (!this.aj() || !this.T() || this.damageEntity(DamageSource.STUCK, 1)) {
            // empty if block
        }
        if (this.ax() || this.world.isStatic) {
            this.aw();
        }
        if (this.aj() && this.a(Material.WATER) && !this.f() && !this.effects.containsKey(MobEffectList.WATER_BREATHING.id)) {
            this.setAirTicks(this.f(this.getAirTicks()));
            if (this.getAirTicks() == -20) {
                this.setAirTicks(0);
                for (int i = 0; i < 8; ++i) {
                    float f = this.random.nextFloat() - this.random.nextFloat();
                    float f2 = this.random.nextFloat() - this.random.nextFloat();
                    float f3 = this.random.nextFloat() - this.random.nextFloat();
                    this.world.a("bubble", this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
                this.damageEntity(DamageSource.DROWN, 2);
            }
            this.aw();
        } else {
            this.setAirTicks(300);
        }
        this.aw = this.ax;
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        if (this.health <= 0) {
            this.ag();
        }
        if (this.aG > 0) {
            --this.aG;
        } else {
            this.aF = null;
        }
        this.aq();
        this.aa = this.Z;
        this.W = this.V;
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        MethodProfiler.a();
    }

    protected void ag() {
        ++this.deathTicks;
        if (this.deathTicks == 20) {
            int n;
            if (!(this.world.isStatic || this.aG <= 0 && !this.ac() || this.l())) {
                int n2;
                for (n = this.a(this.aF); n > 0; n -= n2) {
                    n2 = EntityExperienceOrb.b(n);
                    this.world.addEntity(new EntityExperienceOrb(this.world, this.locX, this.locY, this.locZ, n2));
                }
            }
            this.an();
            this.die();
            for (n = 0; n < 20; ++n) {
                double d = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = this.random.nextGaussian() * 0.02;
                this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, this.locY + (double)(this.random.nextFloat() * this.width), this.locZ + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, d, d2, d3);
            }
        }
    }

    protected int f(int n) {
        return n - 1;
    }

    protected int a(EntityHuman entityHuman) {
        return this.az;
    }

    protected boolean ac() {
        return false;
    }

    public void ah() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            double d4 = 10.0;
            this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length - d * d4, this.locY + (double)(this.random.nextFloat() * this.width) - d2 * d4, this.locZ + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length - d3 * d4, d, d2, d3);
        }
    }

    public void M() {
        super.M();
        this.X = this.Y;
        this.Y = 0.0f;
        this.fallDistance = 0.0f;
    }

    public void w_() {
        boolean bl;
        float f;
        float f2;
        super.w_();
        if (this.aH > 0) {
            if (this.aI <= 0) {
                this.aI = 60;
            }
            --this.aI;
            if (this.aI <= 0) {
                --this.aH;
            }
        }
        this.d();
        double d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f3 = MathHelper.a(d * d + d2 * d2);
        float f4 = this.V;
        float f5 = 0.0f;
        this.X = this.Y;
        float f6 = 0.0f;
        if (!(f3 <= 0.05f)) {
            f6 = 1.0f;
            f5 = f3 * 3.0f;
            f4 = (float)Math.atan2(d2, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.an > 0.0f) {
            f4 = this.yaw;
        }
        if (!this.onGround) {
            f6 = 0.0f;
        }
        this.Y += (f6 - this.Y) * 0.3f;
        for (f2 = f4 - this.V; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        this.V += f2 * 0.3f;
        for (f = this.yaw - this.V; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        boolean bl2 = bl = f < -90.0f || f >= 90.0f;
        if (f < -75.0f) {
            f = -75.0f;
        }
        if (f >= 75.0f) {
            f = 75.0f;
        }
        this.V = this.yaw - f;
        if (f * f > 2500.0f) {
            this.V += f * 0.2f;
        }
        if (bl) {
            f5 *= -1.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        while (this.V - this.W < -180.0f) {
            this.W -= 360.0f;
        }
        while (this.V - this.W >= 180.0f) {
            this.W += 360.0f;
        }
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        this.Z += f5;
    }

    protected void b(float f, float f2) {
        super.b(f, f2);
    }

    public void d(int n) {
        if (this.health <= 0) {
            return;
        }
        this.health += n;
        if (this.health > this.getMaxHealth()) {
            this.health = this.getMaxHealth();
        }
        this.noDamageTicks = this.maxNoDamageTicks / 2;
    }

    public abstract int getMaxHealth();

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int n) {
        this.health = n;
        if (n > this.getMaxHealth()) {
            n = this.getMaxHealth();
        }
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic) {
            return false;
        }
        this.aS = 0;
        if (this.health <= 0) {
            return false;
        }
        if (damageSource.k() && this.hasEffect(MobEffectList.FIRE_RESISTANCE)) {
            return false;
        }
        this.aD = 1.5f;
        boolean bl = true;
        if ((float)this.noDamageTicks > (float)this.maxNoDamageTicks / 2.0f) {
            if (n <= this.lastDamage) {
                return false;
            }
            this.c(damageSource, n - this.lastDamage);
            this.lastDamage = n;
            bl = false;
        } else {
            this.lastDamage = n;
            this.ap = this.health;
            this.noDamageTicks = this.maxNoDamageTicks;
            this.c(damageSource, n);
            this.as = 10;
            this.hurtTicks = 10;
        }
        this.at = 0.0f;
        Entity entity = damageSource.getEntity();
        if (entity != null) {
            EntityWolf entityWolf;
            if (entity instanceof EntityHuman) {
                this.aG = 60;
                this.aF = (EntityHuman)entity;
            } else if (entity instanceof EntityWolf && (entityWolf = (EntityWolf)entity).isTamed()) {
                this.aG = 60;
                this.aF = null;
            }
        }
        if (bl) {
            this.world.a(this, (byte)2);
            this.aB();
            if (entity != null) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                while (d * d + d2 * d2 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.at = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - this.yaw;
                this.a(entity, n, d, d2);
            } else {
                this.at = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (bl) {
                this.world.makeSound(this, this.n(), this.o(), this.w());
            }
            this.die(damageSource);
        } else if (bl) {
            this.world.makeSound(this, this.m(), this.o(), this.w());
        }
        return true;
    }

    private float w() {
        if (this.l()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected int O() {
        return 0;
    }

    protected void g(int n) {
    }

    protected int d(DamageSource damageSource, int n) {
        if (!damageSource.ignoresArmor()) {
            int n2 = 25 - this.O();
            int n3 = n * n2 + this.aq;
            this.g(n);
            n = n3 / 25;
            this.aq = n3 % 25;
        }
        return n;
    }

    protected int b(DamageSource damageSource, int n) {
        if (this.hasEffect(MobEffectList.RESISTANCE)) {
            int n2 = (this.getEffect(MobEffectList.RESISTANCE).getAmplifier() + 1) * 5;
            int n3 = 25 - n2;
            int n4 = n * n3 + this.aq;
            n = n4 / 25;
            this.aq = n4 % 25;
        }
        return n;
    }

    protected void c(DamageSource damageSource, int n) {
        n = this.d(damageSource, n);
        n = this.b(damageSource, n);
        this.health -= n;
    }

    protected float o() {
        return 1.0f;
    }

    protected String c_() {
        return null;
    }

    protected String m() {
        return "damage.hurtflesh";
    }

    protected String n() {
        return "damage.hurtflesh";
    }

    public void a(Entity entity, int n, double d, double d2) {
        this.cb = true;
        float f = MathHelper.a(d * d + d2 * d2);
        float f2 = 0.4f;
        this.motX /= 2.0;
        this.motY /= 2.0;
        this.motZ /= 2.0;
        this.motX -= d / (double)f * (double)f2;
        this.motY += (double)0.4f;
        this.motZ -= d2 / (double)f * (double)f2;
        if (this.motY > (double)0.4f) {
            this.motY = 0.4f;
        }
    }

    public void die(DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (this.ah >= 0 && entity != null) {
            entity.b(this, this.ah);
        }
        if (entity != null) {
            entity.a(this);
        }
        this.ay = true;
        if (!this.world.isStatic) {
            int n = 0;
            if (entity instanceof EntityHuman) {
                n = EnchantmentManager.f(((EntityHuman)entity).inventory);
            }
            if (!this.l()) {
                this.a(this.aG > 0, n);
            }
        }
        this.world.a(this, (byte)3);
    }

    protected void a(boolean bl, int n) {
        int n2 = this.e();
        if (n2 > 0) {
            int n3 = this.random.nextInt(3);
            if (n > 0) {
                n3 += this.random.nextInt(n + 1);
            }
            for (int i = 0; i < n3; ++i) {
                this.b(n2, 1);
            }
        }
    }

    protected int e() {
        return 0;
    }

    protected void b(float f) {
        super.b(f);
        int n = (int)Math.ceil(f - 3.0f);
        if (n > 0) {
            if (n > 4) {
                this.world.makeSound(this, "damage.fallbig", 1.0f, 1.0f);
            } else {
                this.world.makeSound(this, "damage.fallsmall", 1.0f, 1.0f);
            }
            this.damageEntity(DamageSource.FALL, n);
            int n2 = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY - (double)0.2f - (double)this.height), MathHelper.floor(this.locZ));
            if (n2 > 0) {
                StepSound stepSound = Block.byId[n2].stepSound;
                this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.5f, stepSound.getVolume2() * 0.75f);
            }
        }
    }

    public void a(float f, float f2) {
        double d;
        if (this.az()) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= (double)0.8f;
            this.motY *= (double)0.8f;
            this.motZ *= (double)0.8f;
            this.motY -= 0.02;
            if (this.positionChanged && this.d(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else if (this.aA()) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
            this.motY -= 0.02;
            if (this.positionChanged && this.d(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else {
            float f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            float f4 = 0.16277136f / (f3 * f3 * f3);
            float f5 = this.onGround ? this.ak * f4 : this.al;
            this.a(f, f2, f5);
            f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            if (this.r()) {
                float f6 = 0.15f;
                if (this.motX < (double)(-f6)) {
                    this.motX = -f6;
                }
                if (this.motX > (double)f6) {
                    this.motX = f6;
                }
                if (this.motZ < (double)(-f6)) {
                    this.motZ = -f6;
                }
                if (this.motZ > (double)f6) {
                    this.motZ = f6;
                }
                this.fallDistance = 0.0f;
                if (this.motY < -0.15) {
                    this.motY = -0.15;
                }
                if (this.isSneaking() && this.motY < 0.0) {
                    this.motY = 0.0;
                }
            }
            this.move(this.motX, this.motY, this.motZ);
            if (this.positionChanged && this.r()) {
                this.motY = 0.2;
            }
            this.motY -= 0.08;
            this.motY *= (double)0.98f;
            this.motX *= (double)f3;
            this.motZ *= (double)f3;
        }
        this.aC = this.aD;
        d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f7 = MathHelper.a(d * d + d2 * d2) * 4.0f;
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        this.aD += (f7 - this.aD) * 0.4f;
        this.aE += this.aD;
    }

    public boolean r() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        return this.world.getTypeId(n3, n2 = MathHelper.floor(this.boundingBox.b), n = MathHelper.floor(this.locZ)) == Block.LADDER.id;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Health", (short)this.health);
        nBTTagCompound.a("HurtTime", (short)this.hurtTicks);
        nBTTagCompound.a("DeathTime", (short)this.deathTicks);
        nBTTagCompound.a("AttackTime", (short)this.attackTicks);
        if (!this.effects.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (MobEffect mobEffect : this.effects.values()) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.a("Id", (byte)mobEffect.getEffectId());
                nBTTagCompound2.a("Amplifier", (byte)mobEffect.getAmplifier());
                nBTTagCompound2.a("Duration", mobEffect.getDuration());
                nBTTagList.a(nBTTagCompound2);
            }
            nBTTagCompound.a("ActiveEffects", nBTTagList);
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.health = nBTTagCompound.e("Health");
        if (!nBTTagCompound.hasKey("Health")) {
            this.health = this.getMaxHealth();
        }
        this.hurtTicks = nBTTagCompound.e("HurtTime");
        this.deathTicks = nBTTagCompound.e("DeathTime");
        this.attackTicks = nBTTagCompound.e("AttackTime");
        if (nBTTagCompound.hasKey("ActiveEffects")) {
            NBTTagList nBTTagList = nBTTagCompound.m("ActiveEffects");
            for (int i = 0; i < nBTTagList.d(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.a(i);
                byte by = nBTTagCompound2.d("Id");
                byte by2 = nBTTagCompound2.d("Amplifier");
                int n = nBTTagCompound2.f("Duration");
                this.effects.put(Integer.valueOf(by), new MobEffect(by, n, by2));
            }
        }
    }

    public boolean aj() {
        return !this.dead && this.health > 0;
    }

    public boolean f() {
        return false;
    }

    public void d() {
        if (this.d > 0) {
            --this.d;
        }
        if (this.aK > 0) {
            double d;
            double d2 = this.locX + (this.aL - this.locX) / (double)this.aK;
            double d3 = this.locY + (this.aM - this.locY) / (double)this.aK;
            double d4 = this.locZ + (this.aN - this.locZ) / (double)this.aK;
            for (d = this.aO - (double)this.yaw; d < -180.0; d += 360.0) {
            }
            while (d >= 180.0) {
                d -= 360.0;
            }
            this.yaw = (float)((double)this.yaw + d / (double)this.aK);
            this.pitch = (float)((double)this.pitch + (this.aP - (double)this.pitch) / (double)this.aK);
            --this.aK;
            this.setPosition(d2, d3, d4);
            this.c(this.yaw, this.pitch);
            List list = this.world.getEntities(this, this.boundingBox.shrink(0.03125, 0.0, 0.03125));
            if (list.size() > 0) {
                double d5 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    AxisAlignedBB axisAlignedBB = (AxisAlignedBB)list.get(i);
                    if (!(axisAlignedBB.e > d5)) continue;
                    d5 = axisAlignedBB.e;
                }
                this.setPosition(d2, d3 += d5 - this.boundingBox.b, d4);
            }
        }
        MethodProfiler.a("ai");
        if (this.L()) {
            this.aW = false;
            this.aT = 0.0f;
            this.aU = 0.0f;
            this.aV = 0.0f;
        } else if (!this.aj) {
            this.m_();
        }
        MethodProfiler.a();
        boolean bl = this.az();
        boolean bl2 = this.aA();
        if (this.aW) {
            if (bl) {
                this.motY += (double)0.04f;
            } else if (bl2) {
                this.motY += (double)0.04f;
            } else if (this.onGround && this.d == 0) {
                this.X();
                this.d = 10;
            }
        } else {
            this.d = 0;
        }
        this.aT *= 0.98f;
        this.aU *= 0.98f;
        this.aV *= 0.9f;
        float f = this.ak;
        this.ak *= this.F();
        this.a(this.aT, this.aU);
        this.ak = f;
        MethodProfiler.a("push");
        List list = this.world.b((Entity)this, this.boundingBox.b(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.f_()) continue;
                entity.collide(this);
            }
        }
        MethodProfiler.a();
    }

    protected boolean L() {
        return this.health <= 0;
    }

    public boolean K() {
        return false;
    }

    protected void X() {
        this.motY = 0.42f;
        if (this.hasEffect(MobEffectList.JUMP)) {
            this.motY += (double)((float)(this.getEffect(MobEffectList.JUMP).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.yaw * ((float)Math.PI / 180);
            this.motX -= (double)(MathHelper.sin(f) * 0.2f);
            this.motZ += (double)(MathHelper.cos(f) * 0.2f);
        }
        this.cb = true;
    }

    protected boolean d_() {
        return true;
    }

    protected void ak() {
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        if (entityHuman != null) {
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locY - this.locY;
            double d3 = entityHuman.locZ - this.locZ;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (this.d_() && d4 > 16384.0) {
                this.die();
            }
            if (this.aS > 600 && this.random.nextInt(800) == 0 && d4 > 1024.0 && this.d_()) {
                this.die();
            } else if (d4 < 1024.0) {
                this.aS = 0;
            }
        }
    }

    protected void m_() {
        ++this.aS;
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        this.ak();
        this.aT = 0.0f;
        this.aU = 0.0f;
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            entityHuman = this.world.findNearbyPlayer(this, f);
            if (entityHuman != null) {
                this.e = entityHuman;
                this.aZ = 10 + this.random.nextInt(20);
            } else {
                this.aV = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.e != null) {
            this.a(this.e, 10.0f, (float)this.q_());
            if (this.aZ-- <= 0 || this.e.dead || this.e.i(this) > (double)(f * f)) {
                this.e = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.aV = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yaw += this.aV;
            this.pitch = this.aX;
        }
        boolean bl = this.az();
        boolean bl2 = this.aA();
        if (bl || bl2) {
            this.aW = this.random.nextFloat() < 0.8f;
        }
    }

    protected int q_() {
        return 40;
    }

    public void a(Entity entity, float f, float f2) {
        double d;
        double d2 = entity.locX - this.locX;
        double d3 = entity.locZ - this.locZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            d = this.locY + (double)this.x() - (entityLiving.locY + (double)entityLiving.x());
        } else {
            d = (entity.boundingBox.b + entity.boundingBox.e) / 2.0 - (this.locY + (double)this.x());
        }
        double d4 = MathHelper.a(d2 * d2 + d3 * d3);
        float f3 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d, d4) * 180.0 / 3.1415927410125732));
        this.pitch = -this.b(this.pitch, f4, f2);
        this.yaw = this.b(this.yaw, f3, f);
    }

    public boolean al() {
        return this.e != null;
    }

    public Entity am() {
        return this.e;
    }

    private float b(float f, float f2, float f3) {
        float f4;
        for (f4 = f2 - f; f4 < -180.0f; f4 += 360.0f) {
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    public void an() {
    }

    public boolean g() {
        return this.world.containsEntity(this.boundingBox) && this.world.getEntities(this, this.boundingBox).size() == 0 && !this.world.c(this.boundingBox);
    }

    protected void ao() {
        this.damageEntity(DamageSource.OUT_OF_WORLD, 4);
    }

    public Vec3D ap() {
        return this.d(1.0f);
    }

    public Vec3D d(float f) {
        if (f == 1.0f) {
            float f2 = MathHelper.cos(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f3 = MathHelper.sin(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = -MathHelper.cos(-this.pitch * ((float)Math.PI / 180));
            float f5 = MathHelper.sin(-this.pitch * ((float)Math.PI / 180));
            return Vec3D.create(f3 * f4, f5, f2 * f4);
        }
        float f6 = this.lastPitch + (this.pitch - this.lastPitch) * f;
        float f7 = this.lastYaw + (this.yaw - this.lastYaw) * f;
        float f8 = MathHelper.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = MathHelper.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = -MathHelper.cos(-f6 * ((float)Math.PI / 180));
        float f11 = MathHelper.sin(-f6 * ((float)Math.PI / 180));
        return Vec3D.create(f9 * f10, f11, f8 * f10);
    }

    public int p() {
        return 4;
    }

    public boolean isSleeping() {
        return false;
    }

    protected void aq() {
        int n;
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n2);
            if (mobEffect.tick(this) || this.world.isStatic) continue;
            iterator.remove();
            this.d(mobEffect);
        }
        if (this.b) {
            if (!this.world.isStatic) {
                if (!this.effects.isEmpty()) {
                    int n3 = PotionBrewer.a(this.effects.values());
                    this.datawatcher.watch(8, n3);
                } else {
                    this.datawatcher.watch(8, 0);
                }
            }
            this.b = false;
        }
        if (this.random.nextBoolean() && (n = this.datawatcher.getInt(8)) > 0) {
            double d = (double)(n >> 16 & 0xFF) / 255.0;
            double d2 = (double)(n >> 8 & 0xFF) / 255.0;
            double d3 = (double)(n >> 0 & 0xFF) / 255.0;
            this.world.a("mobSpell", this.locX + (this.random.nextDouble() - 0.5) * (double)this.length, this.locY + this.random.nextDouble() * (double)this.width - (double)this.height, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.length, d, d2, d3);
        }
    }

    public void ar() {
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n);
            if (this.world.isStatic) continue;
            iterator.remove();
            this.d(mobEffect);
        }
    }

    public Collection getEffects() {
        return this.effects.values();
    }

    public boolean hasEffect(MobEffectList mobEffectList) {
        return this.effects.containsKey(mobEffectList.id);
    }

    public MobEffect getEffect(MobEffectList mobEffectList) {
        return (MobEffect)this.effects.get(mobEffectList.id);
    }

    public void addEffect(MobEffect mobEffect) {
        if (!this.a(mobEffect)) {
            return;
        }
        if (this.effects.containsKey(mobEffect.getEffectId())) {
            ((MobEffect)this.effects.get(mobEffect.getEffectId())).a(mobEffect);
            this.c((MobEffect)this.effects.get(mobEffect.getEffectId()));
        } else {
            this.effects.put(mobEffect.getEffectId(), mobEffect);
            this.b(mobEffect);
        }
    }

    public boolean a(MobEffect mobEffect) {
        int n;
        return this.t() != EnchantmentDamage.b || (n = mobEffect.getEffectId()) != MobEffectList.REGENERATION.id && n != MobEffectList.POISON.id;
    }

    public boolean at() {
        return this.t() == EnchantmentDamage.b;
    }

    protected void b(MobEffect mobEffect) {
        this.b = true;
    }

    protected void c(MobEffect mobEffect) {
        this.b = true;
    }

    protected void d(MobEffect mobEffect) {
        this.b = true;
    }

    protected float F() {
        float f = 1.0f;
        if (this.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            f *= 1.0f + 0.2f * (float)(this.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier() + 1);
        }
        if (this.hasEffect(MobEffectList.SLOWER_MOVEMENT)) {
            f *= 1.0f - 0.15f * (float)(this.getEffect(MobEffectList.SLOWER_MOVEMENT).getAmplifier() + 1);
        }
        return f;
    }

    public void a_(double d, double d2, double d3) {
        this.setPositionRotation(d, d2, d3, this.yaw, this.pitch);
    }

    public boolean l() {
        return false;
    }

    public EnchantmentDamage t() {
        return EnchantmentDamage.a;
    }

    public void c(ItemStack itemStack) {
        this.world.makeSound(this, "random.break", 0.8f, 0.8f + this.world.random.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            Vec3D vec3D = Vec3D.create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
            Vec3D vec3D2 = Vec3D.create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
            vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
            vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.x(), this.locZ);
            this.world.a("iconcrack_" + itemStack.getItem().id, vec3D2.a, vec3D2.b, vec3D2.c, vec3D.a, vec3D.b + 0.05, vec3D.c);
        }
    }
}

