/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockBed;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerPlayer;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumBedError;
import net.minecraft.server.FoodMetaData;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IInventory;
import net.minecraft.server.InventoryPlayer;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PlayerAbilities;
import net.minecraft.server.Statistic;
import net.minecraft.server.StatisticList;
import net.minecraft.server.TileEntityBrewingStand;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityHuman
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public Container defaultContainer;
    public Container activeContainer;
    protected FoodMetaData foodData = new FoodMetaData();
    protected int o = 0;
    public byte p = 0;
    public int q = 0;
    public float r;
    public float s;
    public boolean t = false;
    public int u = 0;
    public String name;
    public int dimension;
    public int x = 0;
    public double y;
    public double z;
    public double A;
    public double B;
    public double C;
    public double D;
    protected boolean sleeping;
    public ChunkCoordinates F;
    private int sleepTicks;
    public float G;
    public float H;
    private ChunkCoordinates b;
    private ChunkCoordinates c;
    public int I = 20;
    protected boolean J = false;
    public float K;
    public PlayerAbilities abilities = new PlayerAbilities();
    public int expTotal;
    public int exp;
    public float expLevel;
    private ItemStack d;
    private int e;
    protected float P = 0.1f;
    protected float Q = 0.02f;
    public EntityFishingHook hookedFish = null;

    public EntityHuman(World world) {
        super(world);
        this.activeContainer = this.defaultContainer = new ContainerPlayer(this.inventory, !world.isStatic);
        this.height = 1.62f;
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        this.setPositionRotation((double)chunkCoordinates.x + 0.5, chunkCoordinates.y + 1, (double)chunkCoordinates.z + 0.5, 0.0f, 0.0f);
        this.af = "humanoid";
        this.ae = 180.0f;
        this.maxFireTicks = 20;
        this.texture = "/mob/char.png";
    }

    public int getMaxHealth() {
        return 20;
    }

    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)0);
        this.datawatcher.a(17, (byte)0);
    }

    public boolean H() {
        return this.d != null;
    }

    public void I() {
        if (this.d != null) {
            this.d.a(this.world, this, this.e);
        }
        this.J();
    }

    public void J() {
        this.d = null;
        this.e = 0;
        if (!this.world.isStatic) {
            this.g(false);
        }
    }

    public boolean K() {
        return this.H() && Item.byId[this.d.id].d(this.d) == EnumAnimation.d;
    }

    public void w_() {
        if (this.d != null) {
            ItemStack itemStack = this.inventory.getItemInHand();
            if (itemStack != this.d) {
                this.J();
            } else {
                if (this.e <= 25 && this.e % 4 == 0) {
                    this.b(itemStack, 5);
                }
                if (--this.e == 0 && !this.world.isStatic) {
                    this.G();
                }
            }
        }
        if (this.x > 0) {
            --this.x;
        }
        if (this.isSleeping()) {
            ++this.sleepTicks;
            if (this.sleepTicks > 100) {
                this.sleepTicks = 100;
            }
            if (!this.world.isStatic) {
                if (!this.C()) {
                    this.a(true, true, false);
                } else if (this.world.e()) {
                    this.a(false, true, true);
                }
            }
        } else if (this.sleepTicks > 0) {
            ++this.sleepTicks;
            if (this.sleepTicks >= 110) {
                this.sleepTicks = 0;
            }
        }
        super.w_();
        if (!this.world.isStatic && this.activeContainer != null && !this.activeContainer.b(this)) {
            this.closeInventory();
            this.activeContainer = this.defaultContainer;
        }
        if (this.abilities.isFlying) {
            for (int i = 0; i < 8; ++i) {
            }
        }
        if (this.z() && this.abilities.isInvulnerable) {
            this.aw();
        }
        this.y = this.B;
        this.z = this.C;
        this.A = this.D;
        double d = this.locX - this.B;
        double d2 = this.locY - this.C;
        double d3 = this.locZ - this.D;
        double d4 = 10.0;
        if (d > d4) {
            this.y = this.B = this.locX;
        }
        if (d3 > d4) {
            this.A = this.D = this.locZ;
        }
        if (d2 > d4) {
            this.z = this.C = this.locY;
        }
        if (d < -d4) {
            this.y = this.B = this.locX;
        }
        if (d3 < -d4) {
            this.A = this.D = this.locZ;
        }
        if (d2 < -d4) {
            this.z = this.C = this.locY;
        }
        this.B += d * 0.25;
        this.D += d3 * 0.25;
        this.C += d2 * 0.25;
        this.a(StatisticList.k, 1);
        if (this.vehicle == null) {
            this.c = null;
        }
        if (!this.world.isStatic) {
            this.foodData.a(this);
        }
    }

    protected void b(ItemStack itemStack, int n) {
        if (itemStack.m() == EnumAnimation.c) {
            this.world.makeSound(this, "random.drink", 0.5f, this.world.random.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack.m() == EnumAnimation.b) {
            for (int i = 0; i < n; ++i) {
                Vec3D vec3D = Vec3D.create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
                Vec3D vec3D2 = Vec3D.create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
                vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
                vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.x(), this.locZ);
                this.world.a("iconcrack_" + itemStack.getItem().id, vec3D2.a, vec3D2.b, vec3D2.c, vec3D.a, vec3D.b + 0.05, vec3D.c);
            }
            this.world.makeSound(this, "random.eat", 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected void G() {
        if (this.d != null) {
            this.b(this.d, 16);
            int n = this.d.count;
            ItemStack itemStack = this.d.b(this.world, this);
            if (itemStack != this.d || itemStack != null && itemStack.count != n) {
                this.inventory.items[this.inventory.itemInHandIndex] = itemStack;
                if (itemStack.count == 0) {
                    this.inventory.items[this.inventory.itemInHandIndex] = null;
                }
            }
            this.J();
        }
    }

    protected boolean L() {
        return this.getHealth() <= 0 || this.isSleeping();
    }

    protected void closeInventory() {
        this.activeContainer = this.defaultContainer;
    }

    public void M() {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        super.M();
        this.r = this.s;
        this.s = 0.0f;
        this.h(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    private int A() {
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            return 6 - (1 + this.getEffect(MobEffectList.FASTER_DIG).getAmplifier()) * 1;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            return 6 + (1 + this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier()) * 2;
        }
        return 6;
    }

    protected void m_() {
        int n = this.A();
        if (this.t) {
            ++this.u;
            if (this.u >= n) {
                this.u = 0;
                this.t = false;
            }
        } else {
            this.u = 0;
        }
        this.an = (float)this.u / (float)n;
    }

    public void d() {
        List list;
        if (this.o > 0) {
            --this.o;
        }
        if (this.world.difficulty == 0 && this.getHealth() < this.getMaxHealth() && this.ticksLived % 20 * 12 == 0) {
            this.d(1);
        }
        this.inventory.i();
        this.r = this.s;
        super.d();
        this.ak = this.P;
        this.al = this.Q;
        if (this.isSprinting()) {
            this.ak = (float)((double)this.ak + (double)this.P * 0.3);
            this.al = (float)((double)this.al + (double)this.Q * 0.3);
        }
        float f = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
        float f2 = (float)Math.atan(-this.motY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f2 = 0.0f;
        }
        this.s += (f - this.s) * 0.4f;
        this.ax += (f2 - this.ax) * 0.8f;
        if (this.getHealth() > 0 && (list = this.world.b((Entity)this, this.boundingBox.b(1.0, 0.0, 1.0))) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.dead) continue;
                this.k(entity);
            }
        }
    }

    private void k(Entity entity) {
        entity.a_(this);
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.b(0.2f, 0.2f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.motY = 0.1f;
        if (this.name.equals("Notch")) {
            this.a(new ItemStack(Item.APPLE, 1), true);
        }
        this.inventory.k();
        if (damageSource != null) {
            this.motX = -MathHelper.cos((this.at + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motZ = -MathHelper.sin((this.at + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motZ = 0.0;
            this.motX = 0.0;
        }
        this.height = 0.1f;
        this.a(StatisticList.y, 1);
    }

    public void b(Entity entity, int n) {
        this.q += n;
        if (entity instanceof EntityHuman) {
            this.a(StatisticList.A, 1);
        } else {
            this.a(StatisticList.z, 1);
        }
    }

    protected int f(int n) {
        int n2 = EnchantmentManager.a(this.inventory);
        if (n2 > 0 && this.random.nextInt(n2 + 1) > 0) {
            return n;
        }
        return super.f(n);
    }

    public void N() {
        this.a(this.inventory.splitStack(this.inventory.itemInHandIndex, 1), false);
    }

    public void b(ItemStack itemStack) {
        this.a(itemStack, false);
    }

    public void a(ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return;
        }
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY - (double)0.3f + (double)this.x(), this.locZ, itemStack);
        entityItem.pickupDelay = 40;
        float f = 0.1f;
        if (bl) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX = -MathHelper.sin(f3) * f2;
            entityItem.motZ = MathHelper.cos(f3) * f2;
            entityItem.motY = 0.2f;
        } else {
            f = 0.3f;
            entityItem.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI) * f + 0.1f;
            f = 0.02f;
            float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX += Math.cos(f4) * (double)(f *= this.random.nextFloat());
            entityItem.motY += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            entityItem.motZ += Math.sin(f4) * (double)f;
        }
        this.a(entityItem);
        this.a(StatisticList.v, 1);
    }

    protected void a(EntityItem entityItem) {
        this.world.addEntity(entityItem);
    }

    public float a(Block block) {
        float f;
        float f2 = f = this.inventory.a(block);
        int n = EnchantmentManager.b(this.inventory);
        if (n > 0 && this.inventory.b(block)) {
            f2 += (float)(n * n + 1);
        }
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            f2 *= 1.0f + (float)(this.getEffect(MobEffectList.FASTER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            f2 *= 1.0f - (float)(this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.a(Material.WATER) && !EnchantmentManager.g(this.inventory)) {
            f2 /= 5.0f;
        }
        if (!this.onGround) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean b(Block block) {
        return this.inventory.b(block);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.m("Inventory");
        this.inventory.b(nBTTagList);
        this.dimension = nBTTagCompound.f("Dimension");
        this.sleeping = nBTTagCompound.n("Sleeping");
        this.sleepTicks = nBTTagCompound.e("SleepTimer");
        this.expLevel = nBTTagCompound.h("XpP");
        this.expTotal = nBTTagCompound.f("XpLevel");
        this.exp = nBTTagCompound.f("XpTotal");
        if (this.sleeping) {
            this.F = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.a(true, true, false);
        }
        if (nBTTagCompound.hasKey("SpawnX") && nBTTagCompound.hasKey("SpawnY") && nBTTagCompound.hasKey("SpawnZ")) {
            this.b = new ChunkCoordinates(nBTTagCompound.f("SpawnX"), nBTTagCompound.f("SpawnY"), nBTTagCompound.f("SpawnZ"));
        }
        this.foodData.a(nBTTagCompound);
        this.abilities.b(nBTTagCompound);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Inventory", this.inventory.a(new NBTTagList()));
        nBTTagCompound.a("Dimension", this.dimension);
        nBTTagCompound.a("Sleeping", this.sleeping);
        nBTTagCompound.a("SleepTimer", (short)this.sleepTicks);
        nBTTagCompound.a("XpP", this.expLevel);
        nBTTagCompound.a("XpLevel", this.expTotal);
        nBTTagCompound.a("XpTotal", this.exp);
        if (this.b != null) {
            nBTTagCompound.a("SpawnX", this.b.x);
            nBTTagCompound.a("SpawnY", this.b.y);
            nBTTagCompound.a("SpawnZ", this.b.z);
        }
        this.foodData.b(nBTTagCompound);
        this.abilities.a(nBTTagCompound);
    }

    public void a(IInventory iInventory) {
    }

    public void c(int n, int n2, int n3) {
    }

    public void b(int n, int n2, int n3) {
    }

    public void receive(Entity entity, int n) {
    }

    public float x() {
        return 0.12f;
    }

    protected void w() {
        this.height = 1.62f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        Entity entity;
        if (this.abilities.isInvulnerable && !damageSource.ignoresInvulnerability()) {
            return false;
        }
        this.aS = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        if (this.isSleeping() && !this.world.isStatic) {
            this.a(true, true, false);
        }
        if ((entity = damageSource.getEntity()) instanceof EntityMonster || entity instanceof EntityArrow) {
            if (this.world.difficulty == 0) {
                n = 0;
            }
            if (this.world.difficulty == 1) {
                n = n / 2 + 1;
            }
            if (this.world.difficulty == 3) {
                n = n * 3 / 2;
            }
        }
        if (n == 0) {
            return false;
        }
        Entity entity2 = entity;
        if (entity2 instanceof EntityArrow && ((EntityArrow)entity2).shooter != null) {
            entity2 = ((EntityArrow)entity2).shooter;
        }
        if (entity2 instanceof EntityLiving) {
            this.a((EntityLiving)entity2, false);
        }
        this.a(StatisticList.x, n);
        return super.damageEntity(damageSource, n);
    }

    protected int b(DamageSource damageSource, int n) {
        int n2 = super.b(damageSource, n);
        if (n2 <= 0) {
            return 0;
        }
        int n3 = EnchantmentManager.a(this.inventory, damageSource);
        if (n3 > 20) {
            n3 = 20;
        }
        if (n3 > 0 && n3 <= 20) {
            int n4 = 25 - n3;
            int n5 = n2 * n4 + this.aq;
            n2 = n5 / 25;
            this.aq = n5 % 25;
        }
        return n2;
    }

    protected boolean y() {
        return false;
    }

    protected void a(EntityLiving entityLiving, boolean bl) {
        Object object;
        if (entityLiving instanceof EntityCreeper || entityLiving instanceof EntityGhast) {
            return;
        }
        if (entityLiving instanceof EntityWolf && ((EntityWolf)(object = (EntityWolf)entityLiving)).isTamed() && this.name.equals(((EntityWolf)object).getOwnerName())) {
            return;
        }
        if (entityLiving instanceof EntityHuman && !this.y()) {
            return;
        }
        object = this.world.a(EntityWolf.class, AxisAlignedBB.b(this.locX, this.locY, this.locZ, this.locX + 1.0, this.locY + 1.0, this.locZ + 1.0).b(16.0, 4.0, 16.0));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            EntityWolf entityWolf = (EntityWolf)entity;
            if (!entityWolf.isTamed() || entityWolf.E() != null || !this.name.equals(entityWolf.getOwnerName()) || bl && entityWolf.isSitting()) continue;
            entityWolf.setSitting(false);
            entityWolf.setTarget(entityLiving);
        }
    }

    protected void g(int n) {
        this.inventory.d(n);
    }

    protected int O() {
        return this.inventory.j();
    }

    protected void c(DamageSource damageSource, int n) {
        if (!damageSource.ignoresArmor() && this.K()) {
            n = 1 + n >> 1;
        }
        n = this.d(damageSource, n);
        n = this.b(damageSource, n);
        this.c(damageSource.e());
        super.c(damageSource, n);
    }

    public void a(TileEntityFurnace tileEntityFurnace) {
    }

    public void a(TileEntityDispenser tileEntityDispenser) {
    }

    public void a(TileEntitySign tileEntitySign) {
    }

    public void a(TileEntityBrewingStand tileEntityBrewingStand) {
    }

    public void e(Entity entity) {
        if (entity.b(this)) {
            return;
        }
        ItemStack itemStack = this.P();
        if (itemStack != null && entity instanceof EntityLiving) {
            itemStack.a((EntityLiving)entity);
            if (itemStack.count <= 0) {
                itemStack.a(this);
                this.Q();
            }
        }
    }

    public ItemStack P() {
        return this.inventory.getItemInHand();
    }

    public void Q() {
        this.inventory.setItem(this.inventory.itemInHandIndex, null);
    }

    public double R() {
        return this.height - 0.5f;
    }

    public void r_() {
        if (!this.t || this.u >= this.A() / 2 || this.u < 0) {
            this.u = -1;
            this.t = true;
        }
    }

    public void f(Entity entity) {
        int n = this.inventory.a(entity);
        if (this.hasEffect(MobEffectList.INCREASE_DAMAGE)) {
            n += 3 << this.getEffect(MobEffectList.INCREASE_DAMAGE).getAmplifier();
        }
        if (this.hasEffect(MobEffectList.WEAKNESS)) {
            n -= 2 << this.getEffect(MobEffectList.WEAKNESS).getAmplifier();
        }
        int n2 = 0;
        int n3 = 0;
        if (entity instanceof EntityLiving) {
            n3 = EnchantmentManager.a(this.inventory, (EntityLiving)entity);
            n2 += EnchantmentManager.b(this.inventory, (EntityLiving)entity);
        }
        if (this.isSprinting()) {
            ++n2;
        }
        if (n > 0 || n3 > 0) {
            ItemStack itemStack;
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = this.fallDistance > 0.0f && !this.onGround && !this.r() && !this.az() && !this.hasEffect(MobEffectList.BLINDNESS) && this.vehicle == null && entity instanceof EntityLiving;
            if (bl2) {
                n += this.random.nextInt(n / 2 + 2);
            }
            if (bl = entity.damageEntity(DamageSource.playerAttack(this), n += n3)) {
                if (n2 > 0) {
                    entity.b_(-MathHelper.sin(this.yaw * (float)Math.PI / 180.0f) * (float)n2 * 0.5f, 0.1, MathHelper.cos(this.yaw * (float)Math.PI / 180.0f) * (float)n2 * 0.5f);
                    this.motX *= 0.6;
                    this.motZ *= 0.6;
                    this.setSprinting(false);
                }
                if (bl2) {
                    this.c(entity);
                }
                if (n3 > 0) {
                    this.d(entity);
                }
                if (n >= 18) {
                    this.a(AchievementList.E);
                }
            }
            if ((itemStack = this.P()) != null && entity instanceof EntityLiving) {
                itemStack.a((EntityLiving)entity, this);
                if (itemStack.count <= 0) {
                    itemStack.a(this);
                    this.Q();
                }
            }
            if (entity instanceof EntityLiving) {
                if (entity.aj()) {
                    this.a((EntityLiving)entity, true);
                }
                this.a(StatisticList.w, n);
                int n4 = EnchantmentManager.c(this.inventory, (EntityLiving)entity);
                if (n4 > 0) {
                    entity.j(n4 * 4);
                }
            }
            this.c(0.3f);
        }
    }

    public void c(Entity entity) {
    }

    public void d(Entity entity) {
    }

    public void a(ItemStack itemStack) {
    }

    public void die() {
        super.die();
        this.defaultContainer.a(this);
        if (this.activeContainer != null) {
            this.activeContainer.a(this);
        }
    }

    public boolean T() {
        return !this.sleeping && super.T();
    }

    public EnumBedError a(int n, int n2, int n3) {
        if (!this.world.isStatic) {
            if (this.isSleeping() || !this.aj()) {
                return EnumBedError.OTHER_PROBLEM;
            }
            if (this.world.worldProvider.c) {
                return EnumBedError.NOT_POSSIBLE_HERE;
            }
            if (this.world.e()) {
                return EnumBedError.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.locX - (double)n) > 3.0 || Math.abs(this.locY - (double)n2) > 2.0 || Math.abs(this.locZ - (double)n3) > 3.0) {
                return EnumBedError.TOO_FAR_AWAY;
            }
            double d = 8.0;
            double d2 = 5.0;
            List list = this.world.a(EntityMonster.class, AxisAlignedBB.b((double)n - d, (double)n2 - d2, (double)n3 - d, (double)n + d, (double)n2 + d2, (double)n3 + d));
            if (!list.isEmpty()) {
                return EnumBedError.NOT_SAFE;
            }
        }
        this.b(0.2f, 0.2f);
        this.height = 0.2f;
        if (this.world.isLoaded(n, n2, n3)) {
            int n4 = this.world.getData(n, n2, n3);
            int n5 = BlockBed.d(n4);
            float f = 0.5f;
            float f2 = 0.5f;
            switch (n5) {
                case 0: {
                    f2 = 0.9f;
                    break;
                }
                case 2: {
                    f2 = 0.1f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            this.c(n5);
            this.setPosition((float)n + f, (float)n2 + 0.9375f, (float)n3 + f2);
        } else {
            this.setPosition((float)n + 0.5f, (float)n2 + 0.9375f, (float)n3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTicks = 0;
        this.F = new ChunkCoordinates(n, n2, n3);
        this.motY = 0.0;
        this.motZ = 0.0;
        this.motX = 0.0;
        if (!this.world.isStatic) {
            this.world.everyoneSleeping();
        }
        return EnumBedError.OK;
    }

    private void c(int n) {
        this.G = 0.0f;
        this.H = 0.0f;
        switch (n) {
            case 0: {
                this.H = -1.8f;
                break;
            }
            case 2: {
                this.H = 1.8f;
                break;
            }
            case 1: {
                this.G = 1.8f;
                break;
            }
            case 3: {
                this.G = -1.8f;
            }
        }
    }

    public void a(boolean bl, boolean bl2, boolean bl3) {
        this.b(0.6f, 1.8f);
        this.w();
        ChunkCoordinates chunkCoordinates = this.F;
        ChunkCoordinates chunkCoordinates2 = this.F;
        if (chunkCoordinates != null && this.world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) == Block.BED.id) {
            BlockBed.a(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, false);
            chunkCoordinates2 = BlockBed.f(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
            if (chunkCoordinates2 == null) {
                chunkCoordinates2 = new ChunkCoordinates(chunkCoordinates.x, chunkCoordinates.y + 1, chunkCoordinates.z);
            }
            this.setPosition((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + this.height + 0.1f, (float)chunkCoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isStatic && bl2) {
            this.world.everyoneSleeping();
        }
        this.sleepTicks = bl ? 0 : 100;
        if (bl3) {
            this.a(this.F);
        }
    }

    private boolean C() {
        return this.world.getTypeId(this.F.x, this.F.y, this.F.z) == Block.BED.id;
    }

    public static ChunkCoordinates getBed(World world, ChunkCoordinates chunkCoordinates) {
        IChunkProvider iChunkProvider = world.p();
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z + 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z + 3 >> 4);
        if (world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) != Block.BED.id) {
            return null;
        }
        ChunkCoordinates chunkCoordinates2 = BlockBed.f(world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
        return chunkCoordinates2;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public boolean isDeeplySleeping() {
        return this.sleeping && this.sleepTicks >= 100;
    }

    public void a(String string) {
    }

    public ChunkCoordinates getBed() {
        return this.b;
    }

    public void a(ChunkCoordinates chunkCoordinates) {
        this.b = chunkCoordinates != null ? new ChunkCoordinates(chunkCoordinates) : null;
    }

    public void a(Statistic statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic statistic, int n) {
    }

    protected void X() {
        super.X();
        this.a(StatisticList.u, 1);
        if (this.isSprinting()) {
            this.c(0.8f);
        } else {
            this.c(0.2f);
        }
    }

    public void a(float f, float f2) {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        if (this.abilities.isFlying) {
            double d4 = this.motY;
            float f3 = this.al;
            this.al = 0.05f;
            super.a(f, f2);
            this.motY = d4 * 0.6;
            this.al = f3;
        } else {
            super.a(f, f2);
        }
        this.b(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    public void b(double d, double d2, double d3) {
        if (this.vehicle != null) {
            return;
        }
        if (this.a(Material.WATER)) {
            int n = Math.round(MathHelper.a(d * d + d2 * d2 + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.q, n);
                this.c(0.015f * (float)n * 0.01f);
            }
        } else if (this.az()) {
            int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.m, n);
                this.c(0.015f * (float)n * 0.01f);
            }
        } else if (this.r()) {
            if (d2 > 0.0) {
                this.a(StatisticList.o, (int)Math.round(d2 * 100.0));
            }
        } else if (this.onGround) {
            int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.l, n);
                if (this.isSprinting()) {
                    this.c(0.099999994f * (float)n * 0.01f);
                } else {
                    this.c(0.01f * (float)n * 0.01f);
                }
            }
        } else {
            int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
            if (n > 25) {
                this.a(StatisticList.p, n);
            }
        }
    }

    private void h(double d, double d2, double d3) {
        int n;
        if (this.vehicle != null && (n = Math.round(MathHelper.a(d * d + d2 * d2 + d3 * d3) * 100.0f)) > 0) {
            if (this.vehicle instanceof EntityMinecart) {
                this.a(StatisticList.r, n);
                if (this.c == null) {
                    this.c = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
                } else if (this.c.a(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) >= 1000.0) {
                    this.a(AchievementList.q, 1);
                }
            } else if (this.vehicle instanceof EntityBoat) {
                this.a(StatisticList.s, n);
            } else if (this.vehicle instanceof EntityPig) {
                this.a(StatisticList.t, n);
            }
        }
    }

    protected void b(float f) {
        if (this.abilities.canFly) {
            return;
        }
        if (f >= 2.0f) {
            this.a(StatisticList.n, (int)Math.round((double)f * 100.0));
        }
        super.b(f);
    }

    public void a(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityMonster) {
            this.a(AchievementList.s);
        }
    }

    public void Y() {
        if (this.I > 0) {
            this.I = 10;
            return;
        }
        this.J = true;
    }

    public void h(int n) {
        this.q += n;
        this.expLevel += (float)n / (float)this.Z();
        this.exp += n;
        while (this.expLevel >= 1.0f) {
            this.expLevel -= 1.0f;
            this.D();
        }
    }

    public void b(int n) {
        this.expTotal -= n;
        if (this.expTotal < 0) {
            this.expTotal = 0;
        }
    }

    public int Z() {
        return 7 + (this.expTotal * 7 >> 1);
    }

    private void D() {
        ++this.expTotal;
    }

    public void c(float f) {
        if (this.abilities.isInvulnerable) {
            return;
        }
        if (!this.world.isStatic) {
            this.foodData.a(f);
        }
    }

    public FoodMetaData getFoodData() {
        return this.foodData;
    }

    public boolean b(boolean bl) {
        return (bl || this.foodData.b()) && !this.abilities.isInvulnerable;
    }

    public boolean ab() {
        return this.getHealth() > 0 && this.getHealth() < this.getMaxHealth();
    }

    public void a(ItemStack itemStack, int n) {
        if (itemStack == this.d) {
            return;
        }
        this.d = itemStack;
        this.e = n;
        if (!this.world.isStatic) {
            this.g(true);
        }
    }

    public boolean d(int n, int n2, int n3) {
        return true;
    }

    protected int a(EntityHuman entityHuman) {
        int n = this.expTotal * 7;
        if (n > 100) {
            return 100;
        }
        return n;
    }

    protected boolean ac() {
        return true;
    }

    public String ad() {
        return this.name;
    }

    public void e(int n) {
    }

    public void copyTo(EntityHuman entityHuman) {
        this.inventory.a(entityHuman.inventory);
        this.health = entityHuman.health;
        this.foodData = entityHuman.foodData;
        this.expTotal = entityHuman.expTotal;
        this.exp = entityHuman.exp;
        this.expLevel = entityHuman.expLevel;
        this.q = entityHuman.q;
    }
}

