/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityExperienceOrb
extends Entity {
    public int a;
    public int b = 0;
    public int c;
    private int d = 5;
    private int value;

    public EntityExperienceOrb(World world, double d, double d2, double d3, int n) {
        super(world);
        this.b(0.5f, 0.5f);
        this.height = this.width / 2.0f;
        this.setPosition(d, d2, d3);
        this.yaw = (float)(Math.random() * 360.0);
        this.motX = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.motY = (float)(Math.random() * 0.2) * 2.0f;
        this.motZ = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.value = n;
    }

    protected boolean g_() {
        return false;
    }

    public EntityExperienceOrb(World world) {
        super(world);
        this.b(0.25f, 0.25f);
        this.height = this.width / 2.0f;
    }

    protected void b() {
    }

    public void w_() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        super.w_();
        if (this.c > 0) {
            --this.c;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.03f;
        if (this.world.getMaterial(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) == Material.LAVA) {
            this.motY = 0.2f;
            this.motX = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.motZ = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.world.makeSound(this, "random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        this.g(this.locX, (this.boundingBox.b + this.boundingBox.e) / 2.0, this.locZ);
        double d6 = 8.0;
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, d6);
        if (entityHuman != null && (d5 = 1.0 - (d4 = Math.sqrt((d3 = (entityHuman.locX - this.locX) / d6) * d3 + (d2 = (entityHuman.locY + (double)entityHuman.x() - this.locY) / d6) * d2 + (d = (entityHuman.locZ - this.locZ) / d6) * d))) > 0.0) {
            d5 *= d5;
            this.motX += d3 / d4 * d5 * 0.1;
            this.motY += d2 / d4 * d5 * 0.1;
            this.motZ += d / d4 * d5 * 0.1;
        }
        this.move(this.motX, this.motY, this.motZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
            if (n > 0) {
                f = Block.byId[n].frictionFactor * 0.98f;
            }
        }
        this.motX *= (double)f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)f;
        if (this.onGround) {
            this.motY *= (double)-0.9f;
        }
        ++this.a;
        ++this.b;
        if (this.b >= 6000) {
            this.die();
        }
    }

    public boolean i_() {
        return this.world.a(this.boundingBox, Material.WATER, this);
    }

    protected void burn(int n) {
        this.damageEntity(DamageSource.FIRE, n);
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.aB();
        this.d -= n;
        if (this.d <= 0) {
            this.die();
        }
        return false;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Health", (short)((byte)this.d));
        nBTTagCompound.a("Age", (short)this.b);
        nBTTagCompound.a("Value", (short)this.value);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.e("Health") & 0xFF;
        this.b = nBTTagCompound.e("Age");
        this.value = nBTTagCompound.e("Value");
    }

    public void a_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        if (this.c == 0 && entityHuman.x == 0) {
            entityHuman.x = 2;
            this.world.makeSound(this, "random.orb", 0.1f, 0.5f * ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.8f));
            entityHuman.receive(this, 1);
            entityHuman.h(this.value);
            this.die();
        }
    }

    public int g() {
        return this.value;
    }

    public static int b(int n) {
        if (n >= 2477) {
            return 2477;
        }
        if (n >= 1237) {
            return 1237;
        }
        if (n >= 617) {
            return 617;
        }
        if (n >= 307) {
            return 307;
        }
        if (n >= 149) {
            return 149;
        }
        if (n >= 73) {
            return 73;
        }
        if (n >= 37) {
            return 37;
        }
        if (n >= 17) {
            return 17;
        }
        if (n >= 7) {
            return 7;
        }
        if (n >= 3) {
            return 3;
        }
        return 1;
    }
}

