/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityBoat
extends Entity {
    private int a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;

    public EntityBoat(World world) {
        super(world);
        this.bc = true;
        this.b(1.5f, 0.6f);
        this.height = this.width / 2.0f;
    }

    protected boolean g_() {
        return false;
    }

    protected void b() {
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(1));
        this.datawatcher.a(19, new Integer(0));
    }

    public AxisAlignedBB a_(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB h_() {
        return this.boundingBox;
    }

    public boolean f_() {
        return true;
    }

    public EntityBoat(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    public double q() {
        return (double)this.width * 0.0 - (double)0.3f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic || this.dead) {
            return true;
        }
        this.d(-this.l());
        this.c(10);
        this.setDamage(this.getDamage() + n * 10);
        this.aB();
        if (this.getDamage() > 40) {
            int n2;
            if (this.passenger != null) {
                this.passenger.mount(this);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.a(Block.WOOD.id, 1, 0.0f);
            }
            for (n2 = 0; n2 < 2; ++n2) {
                this.a(Item.STICK.id, 1, 0.0f);
            }
            this.die();
        }
        return true;
    }

    public boolean e_() {
        return !this.dead;
    }

    public void w_() {
        int n;
        double d;
        double d2;
        double d3;
        super.w_();
        if (this.k() > 0) {
            this.c(this.k() - 1);
        }
        if (this.getDamage() > 0) {
            this.setDamage(this.getDamage() - 1);
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        int n2 = 5;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d5 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 0) / (double)n2 - 0.125;
            double d6 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 1) / (double)n2 - 0.125;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.b(this.boundingBox.a, d5, this.boundingBox.c, this.boundingBox.d, d6, this.boundingBox.f);
            if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
            d4 += 1.0 / (double)n2;
        }
        double d7 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        if (d7 > 0.15) {
            d3 = Math.cos((double)this.yaw * Math.PI / 180.0);
            d2 = Math.sin((double)this.yaw * Math.PI / 180.0);
            int n3 = 0;
            while ((double)n3 < 1.0 + d7 * 60.0) {
                double d8;
                double d9;
                double d10 = this.random.nextFloat() * 2.0f - 1.0f;
                double d11 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    d9 = this.locX - d3 * d10 * 0.8 + d2 * d11;
                    d8 = this.locZ - d2 * d10 * 0.8 - d3 * d11;
                    this.world.a("splash", d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ);
                } else {
                    d9 = this.locX + d3 + d2 * d10 * 0.7;
                    d8 = this.locZ + d2 - d3 * d10 * 0.7;
                    this.world.a("splash", d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ);
                }
                ++n3;
            }
        }
        if (this.world.isStatic) {
            if (this.a > 0) {
                double d12;
                d3 = this.locX + (this.b - this.locX) / (double)this.a;
                d2 = this.locY + (this.c - this.locY) / (double)this.a;
                double d13 = this.locZ + (this.d - this.locZ) / (double)this.a;
                for (d12 = this.e - (double)this.yaw; d12 < -180.0; d12 += 360.0) {
                }
                while (d12 >= 180.0) {
                    d12 -= 360.0;
                }
                this.yaw = (float)((double)this.yaw + d12 / (double)this.a);
                this.pitch = (float)((double)this.pitch + (this.f - (double)this.pitch) / (double)this.a);
                --this.a;
                this.setPosition(d3, d2, d13);
                this.c(this.yaw, this.pitch);
            } else {
                d3 = this.locX + this.motX;
                d2 = this.locY + this.motY;
                double d14 = this.locZ + this.motZ;
                this.setPosition(d3, d2, d14);
                if (this.onGround) {
                    this.motX *= 0.5;
                    this.motY *= 0.5;
                    this.motZ *= 0.5;
                }
                this.motX *= (double)0.99f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.99f;
            }
            return;
        }
        if (d4 < 1.0) {
            d3 = d4 * 2.0 - 1.0;
            this.motY += (double)0.04f * d3;
        } else {
            if (this.motY < 0.0) {
                this.motY /= 2.0;
            }
            this.motY += (double)0.007f;
        }
        if (this.passenger != null) {
            this.motX += this.passenger.motX * 0.2;
            this.motZ += this.passenger.motZ * 0.2;
        }
        if (this.motX < -(d3 = 0.4)) {
            this.motX = -d3;
        }
        if (this.motX > d3) {
            this.motX = d3;
        }
        if (this.motZ < -d3) {
            this.motZ = -d3;
        }
        if (this.motZ > d3) {
            this.motZ = d3;
        }
        if (this.onGround) {
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
        }
        this.move(this.motX, this.motY, this.motZ);
        if (this.positionChanged && d7 > 0.2) {
            if (!this.world.isStatic) {
                int n4;
                this.die();
                for (n4 = 0; n4 < 3; ++n4) {
                    this.a(Block.WOOD.id, 1, 0.0f);
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    this.a(Item.STICK.id, 1, 0.0f);
                }
            }
        } else {
            this.motX *= (double)0.99f;
            this.motY *= (double)0.95f;
            this.motZ *= (double)0.99f;
        }
        this.pitch = 0.0f;
        d2 = this.yaw;
        double d15 = this.lastX - this.locX;
        double d16 = this.lastZ - this.locZ;
        if (d15 * d15 + d16 * d16 > 0.001) {
            d2 = (float)(Math.atan2(d16, d15) * 180.0 / Math.PI);
        }
        for (d = d2 - (double)this.yaw; d >= 180.0; d -= 360.0) {
        }
        while (d < -180.0) {
            d += 360.0;
        }
        if (d > 20.0) {
            d = 20.0;
        }
        if (d < -20.0) {
            d = -20.0;
        }
        this.yaw = (float)((double)this.yaw + d);
        this.c(this.yaw, this.pitch);
        List list = this.world.b((Entity)this, this.boundingBox.b(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                Entity entity = (Entity)list.get(n);
                if (entity == this.passenger || !entity.f_() || !(entity instanceof EntityBoat)) continue;
                entity.collide(this);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n5;
            int n6;
            int n7 = MathHelper.floor(this.locX + ((double)(n % 2) - 0.5) * 0.8);
            if (this.world.getTypeId(n7, n6 = MathHelper.floor(this.locY), n5 = MathHelper.floor(this.locZ + ((double)(n / 2) - 0.5) * 0.8)) != Block.SNOW.id) continue;
            this.world.setTypeId(n7, n6, n5, 0);
        }
        if (this.passenger != null && this.passenger.dead) {
            this.passenger = null;
        }
    }

    public void i() {
        if (this.passenger == null) {
            return;
        }
        double d = Math.cos((double)this.yaw * Math.PI / 180.0) * 0.4;
        double d2 = Math.sin((double)this.yaw * Math.PI / 180.0) * 0.4;
        this.passenger.setPosition(this.locX + d, this.locY + this.q() + this.passenger.R(), this.locZ + d2);
    }

    protected void b(NBTTagCompound nBTTagCompound) {
    }

    protected void a(NBTTagCompound nBTTagCompound) {
    }

    public boolean b(EntityHuman entityHuman) {
        if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
            return true;
        }
        if (!this.world.isStatic) {
            entityHuman.mount(this);
        }
        return true;
    }

    public void setDamage(int n) {
        this.datawatcher.watch(19, n);
    }

    public int getDamage() {
        return this.datawatcher.getInt(19);
    }

    public void c(int n) {
        this.datawatcher.watch(17, n);
    }

    public int k() {
        return this.datawatcher.getInt(17);
    }

    public void d(int n) {
        this.datawatcher.watch(18, n);
    }

    public int l() {
        return this.datawatcher.getInt(18);
    }
}

