/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityArrow
extends Entity {
    private int e = -1;
    private int f = -1;
    private int g = -1;
    private int h = 0;
    private int i = 0;
    private boolean inGround = false;
    public boolean fromPlayer = false;
    public int shake = 0;
    public Entity shooter;
    private int k;
    private int l = 0;
    public boolean d = false;

    public EntityArrow(World world) {
        super(world);
        this.b(0.5f, 0.5f);
    }

    public EntityArrow(World world, double d, double d2, double d3) {
        super(world);
        this.b(0.5f, 0.5f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public EntityArrow(World world, EntityLiving entityLiving, float f) {
        super(world);
        this.shooter = entityLiving;
        this.fromPlayer = entityLiving instanceof EntityHuman;
        this.b(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.x(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI);
        this.a(this.motX, this.motY, this.motZ, f * 1.5f, 1.0f);
    }

    protected void b() {
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.a(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.a(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.k = 0;
    }

    public void w_() {
        int n;
        Object object;
        int n2;
        super.w_();
        if (this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            float f = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
            this.lastYaw = this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
            this.lastPitch = this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        }
        if ((n2 = this.world.getTypeId(this.e, this.f, this.g)) > 0) {
            Block.byId[n2].a((IBlockAccess)this.world, this.e, this.f, this.g);
            object = Block.byId[n2].e(this.world, this.e, this.f, this.g);
            if (object != null && ((AxisAlignedBB)object).a(Vec3D.create(this.locX, this.locY, this.locZ))) {
                this.inGround = true;
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            n2 = this.world.getTypeId(this.e, this.f, this.g);
            int n3 = this.world.getData(this.e, this.f, this.g);
            if (n2 != this.h || n3 != this.i) {
                this.inGround = false;
                this.motX *= (double)(this.random.nextFloat() * 0.2f);
                this.motY *= (double)(this.random.nextFloat() * 0.2f);
                this.motZ *= (double)(this.random.nextFloat() * 0.2f);
                this.k = 0;
                this.l = 0;
                return;
            }
            ++this.k;
            if (this.k == 1200) {
                this.die();
            }
            return;
        }
        ++this.l;
        Vec3D vec3D = Vec3D.create(this.locX, this.locY, this.locZ);
        object = Vec3D.create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.rayTrace(vec3D, (Vec3D)object, false, true);
        vec3D = Vec3D.create(this.locX, this.locY, this.locZ);
        object = Vec3D.create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            object = Vec3D.create(movingObjectPosition.f.a, movingObjectPosition.f.b, movingObjectPosition.f.c);
        }
        Entity entity = null;
        List list = this.world.b((Entity)this, this.boundingBox.a(this.motX, this.motY, this.motZ).b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (n = 0; n < list.size(); ++n) {
            double d2;
            float f;
            AxisAlignedBB axisAlignedBB;
            MovingObjectPosition movingObjectPosition2;
            Entity entity2 = (Entity)list.get(n);
            if (!entity2.e_() || entity2 == this.shooter && this.l < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.b(f = 0.3f, f, f)).a(vec3D, (Vec3D)object)) == null || !((d2 = vec3D.b(movingObjectPosition2.f)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.entity != null) {
                float f = MathHelper.a(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                int n4 = (int)Math.ceil((double)f * 2.0);
                if (this.d) {
                    n4 += this.random.nextInt(n4 / 2 + 2);
                }
                DamageSource damageSource = null;
                damageSource = this.shooter == null ? DamageSource.arrow(this, this) : DamageSource.arrow(this, this.shooter);
                if (movingObjectPosition.entity.damageEntity(damageSource, n4)) {
                    if (movingObjectPosition.entity instanceof EntityLiving) {
                        ++((EntityLiving)movingObjectPosition.entity).aH;
                    }
                    this.world.makeSound(this, "random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    this.die();
                } else {
                    this.motX *= (double)-0.1f;
                    this.motY *= (double)-0.1f;
                    this.motZ *= (double)-0.1f;
                    this.yaw += 180.0f;
                    this.lastYaw += 180.0f;
                    this.l = 0;
                }
            } else {
                this.e = movingObjectPosition.b;
                this.f = movingObjectPosition.c;
                this.g = movingObjectPosition.d;
                this.h = this.world.getTypeId(this.e, this.f, this.g);
                this.i = this.world.getData(this.e, this.f, this.g);
                this.motX = (float)(movingObjectPosition.f.a - this.locX);
                this.motY = (float)(movingObjectPosition.f.b - this.locY);
                this.motZ = (float)(movingObjectPosition.f.c - this.locZ);
                float f = MathHelper.a(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                this.locX -= this.motX / (double)f * (double)0.05f;
                this.locY -= this.motY / (double)f * (double)0.05f;
                this.locZ -= this.motZ / (double)f * (double)0.05f;
                this.world.makeSound(this, "random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                this.inGround = true;
                this.shake = 7;
                this.d = false;
            }
        }
        if (this.d) {
            for (n = 0; n < 4; ++n) {
                this.world.a("crit", this.locX + this.motX * (double)n / 4.0, this.locY + this.motY * (double)n / 4.0, this.locZ + this.motZ * (double)n / 4.0, -this.motX, -this.motY + 0.2, -this.motZ);
            }
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        float f = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f2 = 0.99f;
        float f3 = 0.05f;
        if (this.az()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.world.a("bubble", this.locX - this.motX * (double)f4, this.locY - this.motY * (double)f4, this.locZ - this.motZ * (double)f4, this.motX, this.motY, this.motZ);
            }
            f2 = 0.8f;
        }
        this.motX *= (double)f2;
        this.motY *= (double)f2;
        this.motZ *= (double)f2;
        this.motY -= (double)f3;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("xTile", (short)this.e);
        nBTTagCompound.a("yTile", (short)this.f);
        nBTTagCompound.a("zTile", (short)this.g);
        nBTTagCompound.a("inTile", (byte)this.h);
        nBTTagCompound.a("inData", (byte)this.i);
        nBTTagCompound.a("shake", (byte)this.shake);
        nBTTagCompound.a("inGround", (byte)(this.inGround ? 1 : 0));
        nBTTagCompound.a("player", this.fromPlayer);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.e = nBTTagCompound.e("xTile");
        this.f = nBTTagCompound.e("yTile");
        this.g = nBTTagCompound.e("zTile");
        this.h = nBTTagCompound.d("inTile") & 0xFF;
        this.i = nBTTagCompound.d("inData") & 0xFF;
        this.shake = nBTTagCompound.d("shake") & 0xFF;
        this.inGround = nBTTagCompound.d("inGround") == 1;
        this.fromPlayer = nBTTagCompound.n("player");
    }

    public void a_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        if (this.inGround && this.fromPlayer && this.shake <= 0 && entityHuman.inventory.pickup(new ItemStack(Item.ARROW, 1))) {
            this.world.makeSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, 1);
            this.die();
        }
    }
}

