/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.DamageSource;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StatisticCollector;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class Entity {
    private static int entityCount = 0;
    public int id = entityCount++;
    public double bb = 1.0;
    public boolean bc = false;
    public Entity passenger;
    public Entity vehicle;
    public World world;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double locX;
    public double locY;
    public double locZ;
    public double motX;
    public double motY;
    public double motZ;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean positionChanged;
    public boolean bw;
    public boolean bx = false;
    public boolean velocityChanged = false;
    protected boolean bz;
    public boolean bA = true;
    public boolean dead = false;
    public float height = 0.0f;
    public float length = 0.6f;
    public float width = 1.8f;
    public float bF = 0.0f;
    public float bG = 0.0f;
    public float fallDistance = 0.0f;
    private int b = 1;
    public double bI;
    public double bJ;
    public double bK;
    public float bL = 0.0f;
    public float bM = 0.0f;
    public boolean bN = false;
    public float bO = 0.0f;
    protected Random random = new Random();
    public int ticksLived = 0;
    public int maxFireTicks = 1;
    private int fireTicks = 0;
    protected boolean bS = false;
    public int noDamageTicks = 0;
    private boolean justCreated = true;
    protected boolean fireProof = false;
    protected DataWatcher datawatcher = new DataWatcher();
    private double e;
    private double f;
    public boolean bW = false;
    public int bX;
    public int bY;
    public int bZ;
    public boolean ca;
    public boolean cb;

    public Entity(World world) {
        this.world = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.datawatcher.a(0, (byte)0);
        this.datawatcher.a(1, (short)300);
        this.b();
    }

    protected abstract void b();

    public DataWatcher getDataWatcher() {
        return this.datawatcher;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return ((Entity)object).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void die() {
        this.dead = true;
    }

    protected void b(float f, float f2) {
        this.length = f;
        this.width = f2;
    }

    protected void c(float f, float f2) {
        this.yaw = f % 360.0f;
        this.pitch = f2 % 360.0f;
    }

    public void setPosition(double d, double d2, double d3) {
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        float f = this.length / 2.0f;
        float f2 = this.width;
        this.boundingBox.c(d - (double)f, d2 - (double)this.height + (double)this.bL, d3 - (double)f, d + (double)f, d2 - (double)this.height + (double)this.bL + (double)f2, d3 + (double)f);
    }

    public void w_() {
        this.af();
    }

    public void af() {
        int n;
        int n2;
        int n3;
        int n4;
        MethodProfiler.a("entityBaseTick");
        if (this.vehicle != null && this.vehicle.dead) {
            this.vehicle = null;
        }
        ++this.ticksLived;
        this.bF = this.bG;
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.lastPitch = this.pitch;
        this.lastYaw = this.yaw;
        if (this.isSprinting() && (n4 = this.world.getTypeId(n3 = MathHelper.floor(this.locX), n2 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n = MathHelper.floor(this.locZ))) > 0) {
            this.world.a("tilecrack_" + n4, this.locX + ((double)this.random.nextFloat() - 0.5) * (double)this.length, this.boundingBox.b + 0.1, this.locZ + ((double)this.random.nextFloat() - 0.5) * (double)this.length, -this.motX * 4.0, 1.5, -this.motZ * 4.0);
        }
        if (this.i_()) {
            if (!this.bS && !this.justCreated) {
                float f;
                float f2 = MathHelper.a(this.motX * this.motX * (double)0.2f + this.motY * this.motY + this.motZ * this.motZ * (double)0.2f) * 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.world.makeSound(this, "random.splash", f2, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f3 = MathHelper.floor(this.boundingBox.b);
                n = 0;
                while ((float)n < 1.0f + this.length * 20.0f) {
                    float f4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    this.world.a("bubble", this.locX + (double)f4, f3 + 1.0f, this.locZ + (double)f, this.motX, this.motY - (double)(this.random.nextFloat() * 0.2f), this.motZ);
                    ++n;
                }
                n = 0;
                while ((float)n < 1.0f + this.length * 20.0f) {
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    this.world.a("splash", this.locX + (double)f5, f3 + 1.0f, this.locZ + (double)f, this.motX, this.motY, this.motZ);
                    ++n;
                }
            }
            this.fallDistance = 0.0f;
            this.bS = true;
            this.fireTicks = 0;
        } else {
            this.bS = false;
        }
        if (this.world.isStatic) {
            this.fireTicks = 0;
        } else if (this.fireTicks > 0) {
            if (this.fireProof) {
                this.fireTicks -= 4;
                if (this.fireTicks < 0) {
                    this.fireTicks = 0;
                }
            } else {
                if (this.fireTicks % 20 == 0) {
                    this.damageEntity(DamageSource.BURN, 1);
                }
                --this.fireTicks;
            }
        }
        if (this.aA()) {
            this.av();
            this.fallDistance *= 0.5f;
        }
        if (this.locY < -64.0) {
            this.ao();
        }
        if (!this.world.isStatic) {
            this.a(0, this.fireTicks > 0);
            this.a(2, this.vehicle != null);
        }
        this.justCreated = false;
        MethodProfiler.a();
    }

    protected void av() {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.LAVA, 4);
            this.j(15);
        }
    }

    public void j(int n) {
        int n2 = n * 20;
        if (this.fireTicks < n2) {
            this.fireTicks = n2;
        }
    }

    public void aw() {
        this.fireTicks = 0;
    }

    protected void ao() {
        this.die();
    }

    public boolean d(double d, double d2, double d3) {
        AxisAlignedBB axisAlignedBB = this.boundingBox.c(d, d2, d3);
        List list = this.world.getEntities(this, axisAlignedBB);
        if (list.size() > 0) {
            return false;
        }
        return !this.world.c(axisAlignedBB);
    }

    public void move(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        double d4;
        double d5;
        int n8;
        int n9;
        boolean bl;
        if (this.bN) {
            this.boundingBox.d(d, d2, d3);
            this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
            this.locY = this.boundingBox.b + (double)this.height - (double)this.bL;
            this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
            return;
        }
        MethodProfiler.a("move");
        this.bL *= 0.4f;
        double d6 = this.locX;
        double d7 = this.locZ;
        if (this.bz) {
            this.bz = false;
            d *= 0.25;
            d2 *= (double)0.05f;
            d3 *= 0.25;
            this.motX = 0.0;
            this.motY = 0.0;
            this.motZ = 0.0;
        }
        double d8 = d;
        double d9 = d2;
        double d10 = d3;
        AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
        boolean bl2 = bl = this.onGround && this.isSneaking();
        if (bl) {
            double d11 = 0.05;
            while (d != 0.0 && this.world.getEntities(this, this.boundingBox.c(d, -1.0, 0.0)).size() == 0) {
                d = d < d11 && d >= -d11 ? 0.0 : (d > 0.0 ? (d -= d11) : (d += d11));
                d8 = d;
            }
            while (d3 != 0.0 && this.world.getEntities(this, this.boundingBox.c(0.0, -1.0, d3)).size() == 0) {
                d3 = d3 < d11 && d3 >= -d11 ? 0.0 : (d3 > 0.0 ? (d3 -= d11) : (d3 += d11));
                d10 = d3;
            }
        }
        List list = this.world.getEntities(this, this.boundingBox.a(d, d2, d3));
        for (n9 = 0; n9 < list.size(); ++n9) {
            d2 = ((AxisAlignedBB)list.get(n9)).b(this.boundingBox, d2);
        }
        this.boundingBox.d(0.0, d2, 0.0);
        if (!this.bA && d9 != d2) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        n9 = this.onGround || d9 != d2 && d9 < 0.0 ? 1 : 0;
        for (n8 = 0; n8 < list.size(); ++n8) {
            d = ((AxisAlignedBB)list.get(n8)).a(this.boundingBox, d);
        }
        this.boundingBox.d(d, 0.0, 0.0);
        if (!this.bA && d8 != d) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        for (n8 = 0; n8 < list.size(); ++n8) {
            d3 = ((AxisAlignedBB)list.get(n8)).c(this.boundingBox, d3);
        }
        this.boundingBox.d(0.0, 0.0, d3);
        if (!this.bA && d10 != d3) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        if (this.bM > 0.0f && n9 != 0 && (bl || this.bL < 0.05f) && (d8 != d || d10 != d3)) {
            d5 = d;
            d4 = d2;
            double d12 = d3;
            d = d8;
            d2 = this.bM;
            d3 = d10;
            AxisAlignedBB axisAlignedBB2 = this.boundingBox.clone();
            this.boundingBox.b(axisAlignedBB);
            list = this.world.getEntities(this, this.boundingBox.a(d, d2, d3));
            for (n7 = 0; n7 < list.size(); ++n7) {
                d2 = ((AxisAlignedBB)list.get(n7)).b(this.boundingBox, d2);
            }
            this.boundingBox.d(0.0, d2, 0.0);
            if (!this.bA && d9 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n7 = 0; n7 < list.size(); ++n7) {
                d = ((AxisAlignedBB)list.get(n7)).a(this.boundingBox, d);
            }
            this.boundingBox.d(d, 0.0, 0.0);
            if (!this.bA && d8 != d) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n7 = 0; n7 < list.size(); ++n7) {
                d3 = ((AxisAlignedBB)list.get(n7)).c(this.boundingBox, d3);
            }
            this.boundingBox.d(0.0, 0.0, d3);
            if (!this.bA && d10 != d3) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            if (!this.bA && d9 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            } else {
                d2 = -this.bM;
                for (n7 = 0; n7 < list.size(); ++n7) {
                    d2 = ((AxisAlignedBB)list.get(n7)).b(this.boundingBox, d2);
                }
                this.boundingBox.d(0.0, d2, 0.0);
            }
            if (d5 * d5 + d12 * d12 >= d * d + d3 * d3) {
                d = d5;
                d2 = d4;
                d3 = d12;
                this.boundingBox.b(axisAlignedBB2);
            } else {
                double d13 = this.boundingBox.b - (double)((int)this.boundingBox.b);
                if (d13 > 0.0) {
                    this.bL = (float)((double)this.bL + (d13 + 0.01));
                }
            }
        }
        MethodProfiler.a();
        MethodProfiler.a("rest");
        this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
        this.locY = this.boundingBox.b + (double)this.height - (double)this.bL;
        this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
        this.positionChanged = d8 != d || d10 != d3;
        this.bw = d9 != d2;
        this.onGround = d9 != d2 && d9 < 0.0;
        this.bx = this.positionChanged || this.bw;
        this.a(d2, this.onGround);
        if (d8 != d) {
            this.motX = 0.0;
        }
        if (d9 != d2) {
            this.motY = 0.0;
        }
        if (d10 != d3) {
            this.motZ = 0.0;
        }
        d5 = this.locX - d6;
        d4 = this.locZ - d7;
        if (this.g_() && !bl && this.vehicle == null) {
            int n10;
            this.bG = (float)((double)this.bG + (double)MathHelper.a(d5 * d5 + d4 * d4) * 0.6);
            n6 = MathHelper.floor(this.locX);
            n7 = this.world.getTypeId(n6, n5 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n10 = MathHelper.floor(this.locZ));
            if (n7 == 0 && this.world.getTypeId(n6, n5 - 1, n10) == Block.FENCE.id) {
                n7 = this.world.getTypeId(n6, n5 - 1, n10);
            }
            if (this.bG > (float)this.b && n7 > 0) {
                this.b = (int)this.bG + 1;
                this.a(n6, n5, n10, n7);
                Block.byId[n7].b(this.world, n6, n5, n10, this);
            }
        }
        if (this.world.a(n6 = MathHelper.floor(this.boundingBox.a + 0.001), n5 = MathHelper.floor(this.boundingBox.b + 0.001), n4 = MathHelper.floor(this.boundingBox.c + 0.001), n7 = MathHelper.floor(this.boundingBox.d - 0.001), n3 = MathHelper.floor(this.boundingBox.e - 0.001), n2 = MathHelper.floor(this.boundingBox.f - 0.001))) {
            for (n = n6; n <= n7; ++n) {
                for (int i = n5; i <= n3; ++i) {
                    for (int j = n4; j <= n2; ++j) {
                        int n11 = this.world.getTypeId(n, i, j);
                        if (n11 <= 0) continue;
                        Block.byId[n11].a(this.world, n, i, j, this);
                    }
                }
            }
        }
        n = this.ay() ? 1 : 0;
        if (this.world.d(this.boundingBox.shrink(0.001, 0.001, 0.001))) {
            this.burn(1);
            if (n == 0) {
                ++this.fireTicks;
                if (this.fireTicks == 0) {
                    this.j(8);
                }
            }
        } else if (this.fireTicks <= 0) {
            this.fireTicks = -this.maxFireTicks;
        }
        if (n != 0 && this.fireTicks > 0) {
            this.world.makeSound(this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.fireTicks = -this.maxFireTicks;
        }
        MethodProfiler.a();
    }

    protected void a(int n, int n2, int n3, int n4) {
        StepSound stepSound = Block.byId[n4].stepSound;
        if (this.world.getTypeId(n, n2 + 1, n3) == Block.SNOW.id) {
            stepSound = Block.SNOW.stepSound;
            this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        } else if (!Block.byId[n4].material.isLiquid()) {
            this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        }
    }

    protected boolean g_() {
        return true;
    }

    protected void a(double d, boolean bl) {
        if (bl) {
            if (this.fallDistance > 0.0f) {
                this.b(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AxisAlignedBB h_() {
        return null;
    }

    protected void burn(int n) {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.FIRE, n);
        }
    }

    public final boolean ax() {
        return this.fireProof;
    }

    protected void b(float f) {
        if (this.passenger != null) {
            this.passenger.b(f);
        }
    }

    public boolean ay() {
        return this.bS || this.world.v(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
    }

    public boolean az() {
        return this.bS;
    }

    public boolean i_() {
        return this.world.a(this.boundingBox.b(0.0, -0.4f, 0.0).shrink(0.001, 0.001, 0.001), Material.WATER, this);
    }

    public boolean a(Material material) {
        int n;
        int n2;
        double d = this.locY + (double)this.x();
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.d(MathHelper.floor(d)), n = MathHelper.floor(this.locZ));
        if (n4 != 0 && Block.byId[n4].material == material) {
            float f = BlockFluids.d(this.world.getData(n3, n2, n)) - 0.11111111f;
            float f2 = (float)(n2 + 1) - f;
            return d < (double)f2;
        }
        return false;
    }

    public float x() {
        return 0.0f;
    }

    public boolean aA() {
        return this.world.a(this.boundingBox.b(-0.1f, -0.4f, -0.1f), Material.LAVA);
    }

    public void a(float f, float f2, float f3) {
        float f4 = MathHelper.c(f * f + f2 * f2);
        if (f4 < 0.01f) {
            return;
        }
        if (f4 < 1.0f) {
            f4 = 1.0f;
        }
        f4 = f3 / f4;
        float f5 = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f);
        float f6 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f);
        this.motX += (double)((f *= f4) * f6 - (f2 *= f4) * f5);
        this.motZ += (double)(f2 * f6 + f * f5);
    }

    public float a(float f) {
        int n;
        int n2 = MathHelper.floor(this.locX);
        if (this.world.isLoaded(n2, this.world.height / 2, n = MathHelper.floor(this.locZ))) {
            double d = (this.boundingBox.e - this.boundingBox.b) * 0.66;
            int n3 = MathHelper.floor(this.locY - (double)this.height + d);
            return this.world.m(n2, n3, n);
        }
        return 0.0f;
    }

    public void spawnIn(World world) {
        this.world = world;
    }

    public void setLocation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.lastY = this.locY = d2;
        this.lastZ = this.locZ = d3;
        this.lastYaw = this.yaw = f;
        this.lastPitch = this.pitch = f2;
        this.bL = 0.0f;
        double d4 = this.lastYaw - f;
        if (d4 < -180.0) {
            this.lastYaw += 360.0f;
        }
        if (d4 >= 180.0) {
            this.lastYaw -= 360.0f;
        }
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(f, f2);
    }

    public void setPositionRotation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.bI = this.locX;
        this.lastY = this.locY = d2 + (double)this.height;
        this.bJ = this.locY;
        this.lastZ = this.locZ = d3;
        this.bK = this.locZ;
        this.yaw = f;
        this.pitch = f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public float h(Entity entity) {
        float f = (float)(this.locX - entity.locX);
        float f2 = (float)(this.locY - entity.locY);
        float f3 = (float)(this.locZ - entity.locZ);
        return MathHelper.c(f * f + f2 * f2 + f3 * f3);
    }

    public double e(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double f(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return MathHelper.a(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double i(Entity entity) {
        double d = this.locX - entity.locX;
        double d2 = this.locY - entity.locY;
        double d3 = this.locZ - entity.locZ;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void a_(EntityHuman entityHuman) {
    }

    public void collide(Entity entity) {
        if (entity.passenger == this || entity.vehicle == this) {
            return;
        }
        double d = entity.locX - this.locX;
        double d2 = entity.locZ - this.locZ;
        double d3 = MathHelper.a(d, d2);
        if (d3 >= (double)0.01f) {
            d3 = MathHelper.a(d3);
            d /= d3;
            d2 /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d *= d4;
            d2 *= d4;
            d *= (double)0.05f;
            d2 *= (double)0.05f;
            this.b_(-(d *= (double)(1.0f - this.bO)), 0.0, -(d2 *= (double)(1.0f - this.bO)));
            entity.b_(d, 0.0, d2);
        }
    }

    public void b_(double d, double d2, double d3) {
        this.motX += d;
        this.motY += d2;
        this.motZ += d3;
        this.cb = true;
    }

    protected void aB() {
        this.velocityChanged = true;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.aB();
        return false;
    }

    public boolean e_() {
        return false;
    }

    public boolean f_() {
        return false;
    }

    public void b(Entity entity, int n) {
    }

    public boolean c(NBTTagCompound nBTTagCompound) {
        String string = this.aC();
        if (this.dead || string == null) {
            return false;
        }
        nBTTagCompound.setString("id", string);
        this.d(nBTTagCompound);
        return true;
    }

    public void d(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Pos", this.a(this.locX, this.locY + (double)this.bL, this.locZ));
        nBTTagCompound.a("Motion", this.a(this.motX, this.motY, this.motZ));
        nBTTagCompound.a("Rotation", this.a(this.yaw, this.pitch));
        nBTTagCompound.a("FallDistance", this.fallDistance);
        nBTTagCompound.a("Fire", (short)this.fireTicks);
        nBTTagCompound.a("Air", (short)this.getAirTicks());
        nBTTagCompound.a("OnGround", this.onGround);
        this.b(nBTTagCompound);
    }

    public void e(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.m("Pos");
        NBTTagList nBTTagList2 = nBTTagCompound.m("Motion");
        NBTTagList nBTTagList3 = nBTTagCompound.m("Rotation");
        this.motX = ((NBTTagDouble)nBTTagList2.a((int)0)).a;
        this.motY = ((NBTTagDouble)nBTTagList2.a((int)1)).a;
        this.motZ = ((NBTTagDouble)nBTTagList2.a((int)2)).a;
        if (Math.abs(this.motX) > 10.0) {
            this.motX = 0.0;
        }
        if (Math.abs(this.motY) > 10.0) {
            this.motY = 0.0;
        }
        if (Math.abs(this.motZ) > 10.0) {
            this.motZ = 0.0;
        }
        this.bI = this.locX = ((NBTTagDouble)nBTTagList.a((int)0)).a;
        this.lastX = this.locX;
        this.bJ = this.locY = ((NBTTagDouble)nBTTagList.a((int)1)).a;
        this.lastY = this.locY;
        this.bK = this.locZ = ((NBTTagDouble)nBTTagList.a((int)2)).a;
        this.lastZ = this.locZ;
        this.lastYaw = this.yaw = ((NBTTagFloat)nBTTagList3.a((int)0)).a;
        this.lastPitch = this.pitch = ((NBTTagFloat)nBTTagList3.a((int)1)).a;
        this.fallDistance = nBTTagCompound.h("FallDistance");
        this.fireTicks = nBTTagCompound.e("Fire");
        this.setAirTicks(nBTTagCompound.e("Air"));
        this.onGround = nBTTagCompound.n("OnGround");
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(this.yaw, this.pitch);
        this.a(nBTTagCompound);
    }

    protected final String aC() {
        return EntityTypes.b(this);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... dArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (double d : dArray) {
            nBTTagList.a(new NBTTagDouble(null, d));
        }
        return nBTTagList;
    }

    protected NBTTagList a(float ... fArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (float f : fArray) {
            nBTTagList.a(new NBTTagFloat(null, f));
        }
        return nBTTagList;
    }

    public EntityItem b(int n, int n2) {
        return this.a(n, n2, 0.0f);
    }

    public EntityItem a(int n, int n2, float f) {
        return this.a(new ItemStack(n, n2, 0), f);
    }

    public EntityItem a(ItemStack itemStack, float f) {
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY + (double)f, this.locZ, itemStack);
        entityItem.pickupDelay = 10;
        this.world.addEntity(entityItem);
        return entityItem;
    }

    public boolean aj() {
        return !this.dead;
    }

    public boolean T() {
        for (int i = 0; i < 8; ++i) {
            int n;
            int n2;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.length * 0.8f;
            float f2 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f3 = ((float)((i >> 2) % 2) - 0.5f) * this.length * 0.8f;
            int n3 = MathHelper.floor(this.locX + (double)f);
            if (!this.world.e(n3, n2 = MathHelper.floor(this.locY + (double)this.x() + (double)f2), n = MathHelper.floor(this.locZ + (double)f3))) continue;
            return true;
        }
        return false;
    }

    public boolean b(EntityHuman entityHuman) {
        return false;
    }

    public AxisAlignedBB a_(Entity entity) {
        return null;
    }

    public void M() {
        if (this.vehicle.dead) {
            this.vehicle = null;
            return;
        }
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.w_();
        if (this.vehicle == null) {
            return;
        }
        this.vehicle.i();
        this.f += (double)(this.vehicle.yaw - this.vehicle.lastYaw);
        this.e += (double)(this.vehicle.pitch - this.vehicle.lastPitch);
        while (this.f >= 180.0) {
            this.f -= 360.0;
        }
        while (this.f < -180.0) {
            this.f += 360.0;
        }
        while (this.e >= 180.0) {
            this.e -= 360.0;
        }
        while (this.e < -180.0) {
            this.e += 360.0;
        }
        double d = this.f * 0.5;
        double d2 = this.e * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d2 > (double)f) {
            d2 = f;
        }
        if (d2 < (double)(-f)) {
            d2 = -f;
        }
        this.f -= d;
        this.e -= d2;
        this.yaw = (float)((double)this.yaw + d);
        this.pitch = (float)((double)this.pitch + d2);
    }

    public void i() {
        this.passenger.setPosition(this.locX, this.locY + this.q() + this.passenger.R(), this.locZ);
    }

    public double R() {
        return this.height;
    }

    public double q() {
        return (double)this.width * 0.75;
    }

    public void mount(Entity entity) {
        this.e = 0.0;
        this.f = 0.0;
        if (entity == null) {
            if (this.vehicle != null) {
                this.setPositionRotation(this.vehicle.locX, this.vehicle.boundingBox.b + (double)this.vehicle.width, this.vehicle.locZ, this.yaw, this.pitch);
                this.vehicle.passenger = null;
            }
            this.vehicle = null;
            return;
        }
        if (this.vehicle == entity) {
            this.vehicle.passenger = null;
            this.vehicle = null;
            this.setPositionRotation(entity.locX, entity.boundingBox.b + (double)entity.width, entity.locZ, this.yaw, this.pitch);
            return;
        }
        if (this.vehicle != null) {
            this.vehicle.passenger = null;
        }
        if (entity.passenger != null) {
            entity.passenger.vehicle = null;
        }
        this.vehicle = entity;
        entity.passenger = this;
    }

    public float j_() {
        return 0.1f;
    }

    public Vec3D ap() {
        return null;
    }

    public void Y() {
    }

    public ItemStack[] getEquipment() {
        return null;
    }

    public boolean z() {
        return this.fireTicks > 0 || this.k(0);
    }

    public boolean isSneaking() {
        return this.k(1);
    }

    public void setSneak(boolean bl) {
        this.a(1, bl);
    }

    public boolean isSprinting() {
        return this.k(3);
    }

    public void setSprinting(boolean bl) {
        this.a(3, bl);
    }

    public void g(boolean bl) {
        this.a(4, bl);
    }

    protected boolean k(int n) {
        return (this.datawatcher.getByte(0) & 1 << n) != 0;
    }

    protected void a(int n, boolean bl) {
        byte by = this.datawatcher.getByte(0);
        if (bl) {
            this.datawatcher.watch(0, (byte)(by | 1 << n));
        } else {
            this.datawatcher.watch(0, (byte)(by & ~(1 << n)));
        }
    }

    public int getAirTicks() {
        return this.datawatcher.b(1);
    }

    public void setAirTicks(int n) {
        this.datawatcher.watch(1, (short)n);
    }

    public void a(EntityWeatherStorm entityWeatherStorm) {
        this.burn(5);
        ++this.fireTicks;
        if (this.fireTicks == 0) {
            this.j(8);
        }
    }

    public void a(EntityLiving entityLiving) {
    }

    protected boolean g(double d, double d2, double d3) {
        int n = MathHelper.floor(d);
        int n2 = MathHelper.floor(d2);
        int n3 = MathHelper.floor(d3);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        double d6 = d3 - (double)n3;
        if (this.world.e(n, n2, n3)) {
            boolean bl = !this.world.e(n - 1, n2, n3);
            boolean bl2 = !this.world.e(n + 1, n2, n3);
            boolean bl3 = !this.world.e(n, n2 - 1, n3);
            boolean bl4 = !this.world.e(n, n2 + 1, n3);
            boolean bl5 = !this.world.e(n, n2, n3 - 1);
            boolean bl6 = !this.world.e(n, n2, n3 + 1);
            int n4 = -1;
            double d7 = 9999.0;
            if (bl && d4 < d7) {
                d7 = d4;
                n4 = 0;
            }
            if (bl2 && 1.0 - d4 < d7) {
                d7 = 1.0 - d4;
                n4 = 1;
            }
            if (bl3 && d5 < d7) {
                d7 = d5;
                n4 = 2;
            }
            if (bl4 && 1.0 - d5 < d7) {
                d7 = 1.0 - d5;
                n4 = 3;
            }
            if (bl5 && d6 < d7) {
                d7 = d6;
                n4 = 4;
            }
            if (bl6 && 1.0 - d6 < d7) {
                d7 = 1.0 - d6;
                n4 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (n4 == 0) {
                this.motX = -f;
            }
            if (n4 == 1) {
                this.motX = f;
            }
            if (n4 == 2) {
                this.motY = -f;
            }
            if (n4 == 3) {
                this.motY = f;
            }
            if (n4 == 4) {
                this.motZ = -f;
            }
            if (n4 == 5) {
                this.motZ = f;
            }
            return true;
        }
        return false;
    }

    public void s() {
        this.bz = true;
    }

    public String ad() {
        String string = EntityTypes.b(this);
        if (string == null) {
            string = "generic";
        }
        return StatisticCollector.a("entity." + string + ".name");
    }

    public Entity[] aG() {
        return null;
    }

    public boolean a(Entity entity) {
        return this == entity;
    }
}

