/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.BlockRegister;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.Entity;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NibbleArray;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class Chunk {
    public static boolean a;
    public byte[] b;
    public int[] c = new int[256];
    public boolean[] d = new boolean[256];
    public boolean e;
    public World world;
    public NibbleArray g;
    public NibbleArray h;
    public NibbleArray i;
    public byte[] heightMap;
    public int k;
    public final int x;
    public final int z;
    private boolean v = false;
    public Map tileEntities = new HashMap();
    public List[] entitySlices;
    public boolean done = false;
    public boolean q = false;
    public boolean r;
    public boolean s = false;
    public long t = 0L;
    boolean u = false;

    public Chunk(World world, int n, int n2) {
        this.entitySlices = new List[world.height / 16];
        this.world = world;
        this.x = n;
        this.z = n2;
        this.heightMap = new byte[256];
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.entitySlices[i] = new ArrayList();
        }
        Arrays.fill(this.c, -999);
    }

    public Chunk(World world, byte[] byArray, int n, int n2) {
        this(world, n, n2);
        this.b = byArray;
        this.g = new NibbleArray(byArray.length, world.heightBits);
        this.h = new NibbleArray(byArray.length, world.heightBits);
        this.i = new NibbleArray(byArray.length, world.heightBits);
    }

    public boolean a(int n, int n2) {
        return n == this.x && n2 == this.z;
    }

    public int b(int n, int n2) {
        return this.heightMap[n2 << 4 | n] & 0xFF;
    }

    public void a() {
    }

    public void initLighting() {
        int n;
        int n2;
        int n3 = this.world.height - 1;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                int n4;
                int n5 = n2 << this.world.heightBitsPlusFour | n << this.world.heightBits;
                for (n4 = this.world.height - 1; n4 > 0 && Block.q[this.b[n5 + n4 - 1] & 0xFF] == 0; --n4) {
                }
                this.heightMap[n << 4 | n2] = (byte)n4;
                if (n4 < n3) {
                    n3 = n4;
                }
                if (this.world.worldProvider.e) continue;
                int n6 = 15;
                int n7 = this.world.height - 1;
                do {
                    if ((n6 -= Block.q[this.b[n5 + n7] & 0xFF]) <= 0) continue;
                    this.h.a(n2, n7, n, n6);
                } while (--n7 > 0 && n6 > 0);
            }
        }
        this.k = n3;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.d(n2, n);
            }
        }
        this.q = true;
    }

    public void loadNOP() {
    }

    private void d(int n, int n2) {
        this.d[n + n2 * 16] = true;
        this.v = true;
    }

    private void k() {
        if (this.world.areChunksLoaded(this.x * 16 + 8, this.world.height / 2, this.z * 16 + 8, 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.d[i + j * 16]) continue;
                    this.d[i + j * 16] = false;
                    int n = this.b(i, j);
                    int n2 = this.x * 16 + i;
                    int n3 = this.z * 16 + j;
                    int n4 = this.world.getHighestBlockYAt(n2 - 1, n3);
                    int n5 = this.world.getHighestBlockYAt(n2 + 1, n3);
                    int n6 = this.world.getHighestBlockYAt(n2, n3 - 1);
                    int n7 = this.world.getHighestBlockYAt(n2, n3 + 1);
                    if (n5 < n4) {
                        n4 = n5;
                    }
                    if (n6 < n4) {
                        n4 = n6;
                    }
                    if (n7 < n4) {
                        n4 = n7;
                    }
                    this.f(n2, n3, n4);
                    this.f(n2 - 1, n3, n);
                    this.f(n2 + 1, n3, n);
                    this.f(n2, n3 - 1, n);
                    this.f(n2, n3 + 1, n);
                    this.v = false;
                }
            }
        }
    }

    private void f(int n, int n2, int n3) {
        int n4 = this.world.getHighestBlockYAt(n, n2);
        if (n4 > n3) {
            this.d(n, n2, n3, n4 + 1);
        } else if (n4 < n3) {
            this.d(n, n2, n4, n3 + 1);
        }
    }

    private void d(int n, int n2, int n3, int n4) {
        if (n4 > n3 && this.world.areChunksLoaded(n, this.world.height / 2, n2, 16)) {
            for (int i = n3; i < n4; ++i) {
                this.world.b(EnumSkyBlock.SKY, n, i, n2);
            }
            this.q = true;
        }
    }

    private void g(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n9 = this.heightMap[n3 << 4 | n] & 0xFF;
        if (n2 > n9) {
            n10 = n2;
        }
        int n11 = n << this.world.heightBitsPlusFour | n3 << this.world.heightBits;
        while (n10 > 0 && Block.q[this.b[n11 + n10 - 1] & 0xFF] == 0) {
            --n10;
        }
        if (n10 == n9) {
            return;
        }
        this.world.g(n, n3, n10, n9);
        this.heightMap[n3 << 4 | n] = (byte)n10;
        if (n10 < this.k) {
            this.k = n10;
        } else {
            n8 = this.world.height - 1;
            for (n7 = 0; n7 < 16; ++n7) {
                for (n6 = 0; n6 < 16; ++n6) {
                    if ((this.heightMap[n6 << 4 | n7] & 0xFF) >= n8) continue;
                    n8 = this.heightMap[n6 << 4 | n7] & 0xFF;
                }
            }
            this.k = n8;
        }
        n8 = this.x * 16 + n;
        n7 = this.z * 16 + n3;
        if (!this.world.worldProvider.e) {
            if (n10 < n9) {
                for (n6 = n10; n6 < n9; ++n6) {
                    this.h.a(n, n6, n3, 15);
                }
            } else {
                for (n6 = n9; n6 < n10; ++n6) {
                    this.h.a(n, n6, n3, 0);
                }
            }
            n6 = 15;
            while (n10 > 0 && n6 > 0) {
                if ((n5 = Block.q[this.getTypeId(n, --n10, n3)]) == 0) {
                    n5 = 1;
                }
                if ((n6 -= n5) < 0) {
                    n6 = 0;
                }
                this.h.a(n, n10, n3, n6);
            }
        }
        if ((n4 = (n6 = this.heightMap[n3 << 4 | n])) < (n5 = n9)) {
            int n12 = n5;
            n5 = n4;
            n4 = n12;
        }
        if (!this.world.worldProvider.e) {
            this.d(n8 - 1, n7, n5, n4);
            this.d(n8 + 1, n7, n5, n4);
            this.d(n8, n7 - 1, n5, n4);
            this.d(n8, n7 + 1, n5, n4);
            this.d(n8, n7, n5, n4);
        }
        this.q = true;
    }

    public int getTypeId(int n, int n2, int n3) {
        return this.b[n << this.world.heightBitsPlusFour | n3 << this.world.heightBits | n2] & 0xFF;
    }

    public boolean a(int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity;
        byte by = (byte)n4;
        int n6 = n3 << 4 | n;
        if (n2 >= this.c[n6] - 1) {
            this.c[n6] = -999;
        }
        int n7 = this.heightMap[n3 << 4 | n] & 0xFF;
        int n8 = this.b[n << this.world.heightBitsPlusFour | n3 << this.world.heightBits | n2] & 0xFF;
        if (n8 == n4 && this.g.a(n, n2, n3) == n5) {
            return false;
        }
        int n9 = this.x * 16 + n;
        int n10 = this.z * 16 + n3;
        this.b[n << this.world.heightBitsPlusFour | n3 << this.world.heightBits | n2] = (byte)(by & 0xFF);
        if (n8 != 0) {
            if (!this.world.isStatic) {
                Block.byId[n8].remove(this.world, n9, n2, n10);
            } else if (Block.byId[n8] instanceof BlockContainer) {
                this.world.n(n9, n2, n10);
            }
        }
        this.g.a(n, n2, n3, n5);
        if (!this.world.worldProvider.e) {
            if (Block.q[by & 0xFF] != 0) {
                if (n2 >= n7) {
                    this.g(n, n2 + 1, n3);
                }
            } else if (n2 == n7 - 1) {
                this.g(n, n2, n3);
            }
            this.world.a(EnumSkyBlock.SKY, n9, n2, n10, n9, n2, n10);
        }
        this.world.a(EnumSkyBlock.BLOCK, n9, n2, n10, n9, n2, n10);
        this.d(n, n3);
        this.g.a(n, n2, n3, n5);
        if (n4 != 0) {
            if (!this.world.isStatic) {
                Block.byId[n4].a(this.world, n9, n2, n10);
            }
            if (Block.byId[n4] instanceof BlockContainer) {
                TileEntity tileEntity2 = this.d(n, n2, n3);
                if (tileEntity2 == null) {
                    tileEntity2 = ((BlockContainer)Block.byId[n4]).a_();
                    this.world.setTileEntity(n, n2, n3, tileEntity2);
                }
                if (tileEntity2 != null) {
                    tileEntity2.d();
                }
            }
        } else if (n8 > 0 && Block.byId[n8] instanceof BlockContainer && (tileEntity = this.d(n, n2, n3)) != null) {
            tileEntity.d();
        }
        this.q = true;
        return true;
    }

    public boolean a(int n, int n2, int n3, int n4) {
        TileEntity tileEntity;
        byte by = (byte)n4;
        int n5 = n3 << 4 | n;
        if (n2 >= this.c[n5] - 1) {
            this.c[n5] = -999;
        }
        int n6 = this.heightMap[n5] & 0xFF;
        int n7 = this.b[n << this.world.heightBitsPlusFour | n3 << this.world.heightBits | n2] & 0xFF;
        if (n7 == n4) {
            return false;
        }
        int n8 = this.x * 16 + n;
        int n9 = this.z * 16 + n3;
        this.b[n << this.world.heightBitsPlusFour | n3 << this.world.heightBits | n2] = (byte)(by & 0xFF);
        if (n7 != 0) {
            Block.byId[n7].remove(this.world, n8, n2, n9);
        }
        this.g.a(n, n2, n3, 0);
        if (Block.q[by & 0xFF] != 0) {
            if (n2 >= n6) {
                this.g(n, n2 + 1, n3);
            }
        } else if (n2 == n6 - 1) {
            this.g(n, n2, n3);
        }
        this.world.a(EnumSkyBlock.SKY, n8, n2, n9, n8, n2, n9);
        this.world.a(EnumSkyBlock.BLOCK, n8, n2, n9, n8, n2, n9);
        this.d(n, n3);
        if (n4 != 0) {
            if (!this.world.isStatic) {
                Block.byId[n4].a(this.world, n8, n2, n9);
            }
            if (n4 > 0 && Block.byId[n4] instanceof BlockContainer) {
                TileEntity tileEntity2 = this.d(n, n2, n3);
                if (tileEntity2 == null) {
                    tileEntity2 = ((BlockContainer)Block.byId[n4]).a_();
                    this.world.setTileEntity(n, n2, n3, tileEntity2);
                }
                if (tileEntity2 != null) {
                    tileEntity2.d();
                }
            }
        } else if (n7 > 0 && Block.byId[n7] instanceof BlockContainer && (tileEntity = this.d(n, n2, n3)) != null) {
            tileEntity.d();
        }
        this.q = true;
        return true;
    }

    public int getData(int n, int n2, int n3) {
        return this.g.a(n, n2, n3);
    }

    public boolean b(int n, int n2, int n3, int n4) {
        TileEntity tileEntity;
        this.q = true;
        int n5 = this.g.a(n, n2, n3);
        if (n5 == n4) {
            return false;
        }
        this.g.a(n, n2, n3, n4);
        int n6 = this.getTypeId(n, n2, n3);
        if (n6 > 0 && Block.byId[n6] instanceof BlockContainer && (tileEntity = this.d(n, n2, n3)) != null) {
            tileEntity.d();
            tileEntity.p = n4;
        }
        return true;
    }

    public int a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        if (enumSkyBlock == EnumSkyBlock.SKY) {
            return this.h.a(n, n2, n3);
        }
        if (enumSkyBlock == EnumSkyBlock.BLOCK) {
            return this.i.a(n, n2, n3);
        }
        return 0;
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        this.q = true;
        if (enumSkyBlock == EnumSkyBlock.SKY) {
            if (!this.world.worldProvider.e) {
                this.h.a(n, n2, n3, n4);
            }
        } else if (enumSkyBlock == EnumSkyBlock.BLOCK) {
            this.i.a(n, n2, n3, n4);
        } else {
            return;
        }
    }

    public int c(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n6 = this.world.worldProvider.e ? 0 : this.h.a(n, n2, n3);
        if (n6 > 0) {
            a = true;
        }
        if ((n5 = this.i.a(n, n2, n3)) > (n6 -= n4)) {
            n6 = n5;
        }
        return n6;
    }

    public void a(Entity entity) {
        int n;
        this.s = true;
        int n2 = MathHelper.floor(entity.locX / 16.0);
        int n3 = MathHelper.floor(entity.locZ / 16.0);
        if (n2 != this.x || n3 != this.z) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((n = MathHelper.floor(entity.locY / 16.0)) < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        entity.bW = true;
        entity.bX = this.x;
        entity.bY = n;
        entity.bZ = this.z;
        this.entitySlices[n].add(entity);
    }

    public void b(Entity entity) {
        this.a(entity, entity.bY);
    }

    public void a(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        this.entitySlices[n].remove(entity);
    }

    public boolean c(int n, int n2, int n3) {
        return n2 >= (this.heightMap[n3 << 4 | n] & 0xFF);
    }

    public TileEntity d(int n, int n2, int n3) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        TileEntity tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        if (tileEntity == null) {
            int n4 = this.getTypeId(n, n2, n3);
            if (!Block.isTileEntity[n4]) {
                return null;
            }
            if (tileEntity == null) {
                tileEntity = ((BlockContainer)Block.byId[n4]).a_();
                this.world.setTileEntity(this.x * 16 + n, n2, this.z * 16 + n3, tileEntity);
            }
            tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        }
        if (tileEntity != null && tileEntity.l()) {
            this.tileEntities.remove(chunkPosition);
            return null;
        }
        return tileEntity;
    }

    public void a(TileEntity tileEntity) {
        int n = tileEntity.x - this.x * 16;
        int n2 = tileEntity.y;
        int n3 = tileEntity.z - this.z * 16;
        this.a(n, n2, n3, tileEntity);
        if (this.e) {
            this.world.h.add(tileEntity);
        }
    }

    public void a(int n, int n2, int n3, TileEntity tileEntity) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        tileEntity.world = this.world;
        tileEntity.x = this.x * 16 + n;
        tileEntity.y = n2;
        tileEntity.z = this.z * 16 + n3;
        if (this.getTypeId(n, n2, n3) == 0 || !(Block.byId[this.getTypeId(n, n2, n3)] instanceof BlockContainer)) {
            return;
        }
        tileEntity.m();
        this.tileEntities.put(chunkPosition, tileEntity);
    }

    public void e(int n, int n2, int n3) {
        TileEntity tileEntity;
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        if (this.e && (tileEntity = (TileEntity)this.tileEntities.remove(chunkPosition)) != null) {
            tileEntity.i();
        }
    }

    public void addEntities() {
        this.e = true;
        this.world.a(this.tileEntities.values());
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.world.a(this.entitySlices[i]);
        }
    }

    public void removeEntities() {
        this.e = false;
        for (TileEntity tileEntity : this.tileEntities.values()) {
            this.world.a(tileEntity);
        }
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.world.b(this.entitySlices[i]);
        }
    }

    public void f() {
        this.q = true;
    }

    public void a(Entity entity, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity2 = (Entity)list2.get(j);
                if (entity2 == entity || !entity2.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity2);
                Entity[] entityArray = entity2.aG();
                if (entityArray == null) continue;
                for (int k = 0; k < entityArray.length; ++k) {
                    entity2 = entityArray[k];
                    if (entity2 == entity || !entity2.boundingBox.a(axisAlignedBB)) continue;
                    list.add(entity2);
                }
            }
        }
    }

    public void a(Class clazz, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        } else if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity = (Entity)list2.get(j);
                if (!clazz.isAssignableFrom(entity.getClass()) || !entity.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity);
            }
        }
    }

    public boolean a(boolean bl) {
        if (this.r) {
            return false;
        }
        if (bl ? this.s && this.world.getTime() != this.t : this.s && this.world.getTime() >= this.t + 600L) {
            return true;
        }
        return this.q;
    }

    public int getData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n4 - n;
        int n13 = n5 - n2;
        int n14 = n6 - n3;
        if (n12 * n13 * n14 == this.b.length) {
            System.arraycopy(this.b, 0, byArray, n7, this.b.length);
            System.arraycopy(this.g.a, 0, byArray, n7 += this.b.length, this.g.a.length);
            System.arraycopy(this.i.a, 0, byArray, n7 += this.g.a.length, this.i.a.length);
            System.arraycopy(this.h.a, 0, byArray, n7 += this.i.a.length, this.h.a.length);
            return n7 += this.h.a.length;
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = n11 << this.world.heightBitsPlusFour | n10 << this.world.heightBits | n2;
                n8 = n5 - n2;
                System.arraycopy(this.b, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << this.world.heightBitsPlusFour | n10 << this.world.heightBits | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.g.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << this.world.heightBitsPlusFour | n10 << this.world.heightBits | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.i.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << this.world.heightBitsPlusFour | n10 << this.world.heightBits | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.h.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        return n7;
    }

    public Random a(long l) {
        return new Random(this.world.getSeed() + (long)(this.x * this.x * 4987142) + (long)(this.x * 5947611) + (long)(this.z * this.z) * 4392871L + (long)(this.z * 389711) ^ l);
    }

    public boolean isEmpty() {
        return false;
    }

    public void h() {
        BlockRegister.a(this.b);
    }

    public void a(IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2, int n, int n2) {
        if (!this.done && iChunkProvider.isChunkLoaded(n + 1, n2 + 1) && iChunkProvider.isChunkLoaded(n, n2 + 1) && iChunkProvider.isChunkLoaded(n + 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n, n2);
        }
        if (iChunkProvider.isChunkLoaded(n - 1, n2) && !iChunkProvider.getOrCreateChunk((int)(n - 1), (int)n2).done && iChunkProvider.isChunkLoaded(n - 1, n2 + 1) && iChunkProvider.isChunkLoaded(n, n2 + 1) && iChunkProvider.isChunkLoaded(n - 1, n2 + 1)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n - 1, n2);
        }
        if (iChunkProvider.isChunkLoaded(n, n2 - 1) && !iChunkProvider.getOrCreateChunk((int)n, (int)(n2 - 1)).done && iChunkProvider.isChunkLoaded(n + 1, n2 - 1) && iChunkProvider.isChunkLoaded(n + 1, n2 - 1) && iChunkProvider.isChunkLoaded(n + 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n, n2 - 1);
        }
        if (iChunkProvider.isChunkLoaded(n - 1, n2 - 1) && !iChunkProvider.getOrCreateChunk((int)(n - 1), (int)(n2 - 1)).done && iChunkProvider.isChunkLoaded(n, n2 - 1) && iChunkProvider.isChunkLoaded(n - 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n - 1, n2 - 1);
        }
    }

    public int c(int n, int n2) {
        int n3 = n | n2 << 4;
        int n4 = this.c[n3];
        if (n4 == -999) {
            int n5 = this.world.height - 1;
            n4 = -1;
            while (n5 > 0 && n4 == -1) {
                Material material;
                int n6 = this.getTypeId(n, n5, n2);
                Material material2 = material = n6 == 0 ? Material.AIR : Block.byId[n6].material;
                if (!material.isSolid() && !material.isLiquid()) {
                    --n5;
                    continue;
                }
                n4 = n5 + 1;
            }
            this.c[n3] = n4;
        }
        return n4;
    }

    public void i() {
        if (this.v && !this.world.worldProvider.e) {
            this.k();
        }
    }

    public ChunkCoordIntPair j() {
        return new ChunkCoordIntPair(this.x, this.z);
    }
}

