/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBigHills;
import net.minecraft.server.BiomeDecorator;
import net.minecraft.server.BiomeDesert;
import net.minecraft.server.BiomeForest;
import net.minecraft.server.BiomeHell;
import net.minecraft.server.BiomeIcePlains;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.BiomeMushrooms;
import net.minecraft.server.BiomeOcean;
import net.minecraft.server.BiomePlains;
import net.minecraft.server.BiomeRiver;
import net.minecraft.server.BiomeSky;
import net.minecraft.server.BiomeSwamp;
import net.minecraft.server.BiomeTaiga;
import net.minecraft.server.Block;
import net.minecraft.server.EntityChicken;
import net.minecraft.server.EntityCow;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityEnderman;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EntitySlime;
import net.minecraft.server.EntitySpider;
import net.minecraft.server.EntitySquid;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenBigTree;
import net.minecraft.server.WorldGenForest;
import net.minecraft.server.WorldGenSwampTree;
import net.minecraft.server.WorldGenTrees;
import net.minecraft.server.WorldGenerator;

public abstract class BiomeBase {
    public static final BiomeBase[] a = new BiomeBase[256];
    public static final BiomeBase OCEAN = new BiomeOcean(0).b(112).a("Ocean").b(-1.0f, 0.4f);
    public static final BiomeBase PLAINS = new BiomePlains(1).b(9286496).a("Plains").a(0.8f, 0.4f);
    public static final BiomeBase DESERT = new BiomeDesert(2).b(16421912).a("Desert").g().a(2.0f, 0.0f).b(0.1f, 0.2f);
    public static final BiomeBase EXTREME_HILLS = new BiomeBigHills(3).b(0x606060).a("Extreme Hills").b(0.2f, 1.8f).a(0.2f, 0.3f);
    public static final BiomeBase FOREST = new BiomeForest(4).b(353825).a("Forest").a(5159473).a(0.7f, 0.8f);
    public static final BiomeBase TAIGA = new BiomeTaiga(5).b(747097).a("Taiga").a(5159473).a(0.3f, 0.8f).b(0.1f, 0.4f);
    public static final BiomeBase SWAMPLAND = new BiomeSwamp(6).b(522674).a("Swampland").a(9154376).b(-0.2f, 0.1f).a(0.8f, 0.9f);
    public static final BiomeBase RIVER = new BiomeRiver(7).b(255).a("River").b(-0.5f, 0.0f);
    public static final BiomeBase HELL = new BiomeHell(8).b(0xFF0000).a("Hell").g().a(2.0f, 0.0f);
    public static final BiomeBase SKY = new BiomeSky(9).b(0x8080FF).a("Sky").g();
    public static final BiomeBase FROZEN_OCEAN = new BiomeOcean(10).b(0x9090A0).a("FrozenOcean").b(-1.0f, 0.5f).a(0.0f, 0.5f);
    public static final BiomeBase FROZEN_RIVER = new BiomeRiver(11).b(0xA0A0FF).a("FrozenRiver").b(-0.5f, 0.0f).a(0.0f, 0.5f);
    public static final BiomeBase ICE_PLAINS = new BiomeIcePlains(12).b(0xFFFFFF).a("Ice Plains").a(0.0f, 0.5f);
    public static final BiomeBase ICE_MOUNTAINS = new BiomeIcePlains(13).b(0xA0A0A0).a("Ice Mountains").b(0.2f, 1.8f).a(0.0f, 0.5f);
    public static final BiomeBase MUSHROOM_ISLAND = new BiomeMushrooms(14).b(0xFF00FF).a("MushroomIsland").a(0.9f, 1.0f).b(0.2f, 1.0f);
    public static final BiomeBase MUSHROOM_SHORE = new BiomeMushrooms(15).b(0xA000FF).a("MushroomIslandShore").a(0.9f, 1.0f).b(-1.0f, 0.1f);
    public String r;
    public int s;
    public byte t;
    public byte u;
    public int v;
    public float w;
    public float x;
    public float y;
    public float z;
    public int A;
    public BiomeDecorator B;
    protected List C;
    protected List D;
    protected List E;
    private boolean K;
    private boolean L;
    public final int F;
    protected WorldGenTrees G;
    protected WorldGenBigTree H;
    protected WorldGenForest I;
    protected WorldGenSwampTree J;

    protected BiomeBase(int n) {
        this.t = (byte)Block.GRASS.id;
        this.u = (byte)Block.DIRT.id;
        this.v = 5169201;
        this.w = 0.1f;
        this.x = 0.3f;
        this.y = 0.5f;
        this.z = 0.5f;
        this.A = 0xFFFFFF;
        this.C = new ArrayList();
        this.D = new ArrayList();
        this.E = new ArrayList();
        this.L = true;
        this.G = new WorldGenTrees(false);
        this.H = new WorldGenBigTree(false);
        this.I = new WorldGenForest(false);
        this.J = new WorldGenSwampTree();
        this.F = n;
        BiomeBase.a[n] = this;
        this.B = this.a();
        this.D.add(new BiomeMeta(EntitySheep.class, 12, 4, 4));
        this.D.add(new BiomeMeta(EntityPig.class, 10, 4, 4));
        this.D.add(new BiomeMeta(EntityChicken.class, 10, 4, 4));
        this.D.add(new BiomeMeta(EntityCow.class, 8, 4, 4));
        this.C.add(new BiomeMeta(EntitySpider.class, 10, 4, 4));
        this.C.add(new BiomeMeta(EntityZombie.class, 10, 4, 4));
        this.C.add(new BiomeMeta(EntitySkeleton.class, 10, 4, 4));
        this.C.add(new BiomeMeta(EntityCreeper.class, 10, 4, 4));
        this.C.add(new BiomeMeta(EntitySlime.class, 10, 4, 4));
        this.C.add(new BiomeMeta(EntityEnderman.class, 1, 1, 4));
        this.E.add(new BiomeMeta(EntitySquid.class, 10, 4, 4));
    }

    protected BiomeDecorator a() {
        return new BiomeDecorator(this);
    }

    private BiomeBase a(float f, float f2) {
        if (f > 0.1f && f < 0.2f) {
            throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
        }
        this.y = f;
        this.z = f2;
        return this;
    }

    private BiomeBase b(float f, float f2) {
        this.w = f;
        this.x = f2;
        return this;
    }

    private BiomeBase g() {
        this.L = false;
        return this;
    }

    public WorldGenerator a(Random random) {
        if (random.nextInt(10) == 0) {
            return this.H;
        }
        return this.G;
    }

    protected BiomeBase a(String string) {
        this.r = string;
        return this;
    }

    protected BiomeBase a(int n) {
        this.v = n;
        return this;
    }

    protected BiomeBase b(int n) {
        this.s = n;
        return this;
    }

    public List a(EnumCreatureType enumCreatureType) {
        if (enumCreatureType == EnumCreatureType.MONSTER) {
            return this.C;
        }
        if (enumCreatureType == EnumCreatureType.CREATURE) {
            return this.D;
        }
        if (enumCreatureType == EnumCreatureType.WATER_CREATURE) {
            return this.E;
        }
        return null;
    }

    public boolean b() {
        return this.K;
    }

    public boolean c() {
        if (this.K) {
            return false;
        }
        return this.L;
    }

    public float d() {
        return 0.1f;
    }

    public final int e() {
        return (int)(this.z * 65536.0f);
    }

    public final int f() {
        return (int)(this.y * 65536.0f);
    }

    public void a(World world, Random random, int n, int n2) {
        this.B.a(world, random, n, n2);
    }
}

