/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;
import paulscode.sound.Vector3D;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound;

public class SourceJavaSound
extends Source {
    protected ChannelJavaSound channelJavaSound;
    public ListenerData listener;
    private float pan;

    public SourceJavaSound(ListenerData listenerData, boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f2, float f3, float f4, int n2, float f5, boolean bl4) {
        super(bl, bl2, bl3, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, bl4);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, Source source, SoundBuffer soundBuffer) {
        super(source, soundBuffer);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, AudioFormat audioFormat, boolean bl, String string, float f2, float f3, float f4, int n2, float f5) {
        super(audioFormat, bl, string, f2, f3, f4, n2, f5);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public void cleanup() {
        super.cleanup();
    }

    public void changeSource(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f2, float f3, float f4, int n2, float f5, boolean bl4) {
        super.changeSource(bl, bl2, bl3, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, bl4);
        if (this.channelJavaSound != null) {
            this.channelJavaSound.setLooping(bl3);
        }
        this.positionChanged();
    }

    public void listenerMoved() {
        this.positionChanged();
    }

    public void setPosition(float f2, float f3, float f4) {
        super.setPosition(f2, f3, f4);
        this.positionChanged();
    }

    public void positionChanged() {
        this.calculateGain();
        this.calculatePan();
        this.calculatePitch();
    }

    public void setPitch(float f2) {
        super.setPitch(f2);
        this.calculatePitch();
    }

    public void setAttenuation(int n2) {
        super.setAttenuation(n2);
        this.calculateGain();
    }

    public void setDistOrRoll(float f2) {
        super.setDistOrRoll(f2);
        this.calculateGain();
    }

    public void play(Channel channel) {
        boolean bl;
        if (!this.active()) {
            if (this.toLoop) {
                this.toPlay = true;
            }
            return;
        }
        if (channel == null) {
            this.errorMessage("Unable to play source, because channel was null");
            return;
        }
        boolean bl2 = bl = this.channel != channel;
        if (this.channel != null && this.channel.attachedSource != this) {
            bl = true;
        }
        boolean bl3 = this.paused();
        boolean bl4 = this.stopped();
        super.play(channel);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        if (bl) {
            if (this.channelJavaSound != null) {
                this.channelJavaSound.setLooping(this.toLoop);
            }
            if (!this.toStream) {
                if (this.soundBuffer == null) {
                    this.errorMessage("No sound buffer to play");
                    return;
                }
                this.channelJavaSound.attachBuffer(this.soundBuffer);
            }
        }
        this.positionChanged();
        if (bl4 || !this.playing()) {
            if (this.toStream && !bl3) {
                this.preLoad = true;
            }
            this.channel.play();
        }
    }

    public boolean preLoad() {
        if (this.codec == null) {
            return false;
        }
        this.codec.initialize(this.filenameURL.getURL());
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (int i2 = 0; i2 < SoundSystemConfig.getNumberStreamingBuffers(); ++i2) {
            this.soundBuffer = this.codec.read();
            if (this.soundBuffer == null || this.soundBuffer.audioData == null) break;
            linkedList.add(this.soundBuffer.audioData);
        }
        this.channelJavaSound.resetStream(this.codec.getAudioFormat());
        this.positionChanged();
        this.channel.preLoadBuffers(linkedList);
        this.preLoad = false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void calculateGain() {
        block8: {
            float f2 = this.position.x - this.listener.position.x;
            float f3 = this.position.y - this.listener.position.y;
            float f4 = this.position.z - this.listener.position.z;
            this.distanceFromListener = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
            switch (this.attModel) {
                case 2: {
                    if (this.distanceFromListener <= 0.0f) break;
                    this.gain = this.distanceFromListener >= this.distOrRoll ? 0.0f : 1.0f - this.distanceFromListener / this.distOrRoll;
                    break block8;
                }
                case 1: {
                    float f5;
                    if (this.distanceFromListener <= 0.0f) break;
                    f2 = this.distOrRoll * this.distanceFromListener * this.distanceFromListener * 5.0E-4f;
                    if (f5 < 0.0f) {
                        f2 = 0.0f;
                    }
                    this.gain = 1.0f / (f2 + 1.0f);
                    break block8;
                }
            }
            this.gain = 1.0f;
        }
        if (this.gain > 1.0f) {
            this.gain = 1.0f;
        }
        if (this.gain < 0.0f) {
            this.gain = 0.0f;
        }
        this.gain *= this.sourceVolume * SoundSystemConfig.getMasterGain() * Math.abs(this.fadeOutGain) * this.fadeInGain;
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setGain(this.gain);
        }
    }

    public void calculatePan() {
        Vector3D vector3D = this.listener.up.cross(this.listener.lookAt);
        vector3D.normalize();
        float f2 = this.position.dot(this.position.subtract(this.listener.position), vector3D);
        float f3 = this.position.dot(this.position.subtract(this.listener.position), this.listener.lookAt);
        f2 = (float)Math.atan2(f2, f3);
        this.pan = (float)(-Math.sin(f2));
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (this.attModel == 0) {
                this.channelJavaSound.setPan(0.0f);
                return;
            }
            this.channelJavaSound.setPan(this.pan);
        }
    }

    public void calculatePitch() {
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setPitch(this.pitch);
        }
    }
}

