/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.b.a;
import com.mojang.minecraft.level.tile.Tile$SoundType;
import com.mojang.minecraft.net.b;
import com.mojang.minecraft.phys.AABB;
import java.io.Serializable;
import java.util.ArrayList;

public class Entity
implements Serializable {
    public static final long serialVersionUID = 0L;
    protected Level level;
    public float xo;
    public float yo;
    public float zo;
    public float x;
    public float y;
    public float z;
    public float xd;
    public float yd;
    public float zd;
    public float yRot;
    public float xRot;
    public float yRotO;
    public float xRotO;
    public AABB bb;
    public boolean onGround = false;
    public boolean horizontalCollision = false;
    public boolean removed = false;
    public float heightOffset = 0.0f;
    protected float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    private float walkDist = 0.0f;
    public boolean makeStepSound = true;

    public Entity(Level level) {
        this.level = level;
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    protected void resetPos() {
        if (this.level == null) {
            return;
        }
        float f2 = (float)this.level.xSpawn + 0.5f;
        float f3 = (float)this.level.zSpawn + 0.5f;
        for (float f4 = (float)this.level.ySpawn; f4 > 0.0f; f4 += 1.0f) {
            this.setPos(f2, f4, f3);
            if (this.level.getCubes(this.bb).size() == 0) break;
        }
        this.zd = 0.0f;
        this.yd = 0.0f;
        this.xd = 0.0f;
        this.yRot = this.level.rotSpawn;
        this.xRot = 0.0f;
    }

    public void remove() {
        this.removed = true;
    }

    public void setSize(float f2, float f3) {
        this.bbWidth = f2;
        this.bbHeight = f3;
    }

    public void setPos(b b2) {
        if (b2.g) {
            this.setPos(b2.a, b2.b, b2.c);
        } else {
            this.setPos(this.x, this.y, this.z);
        }
        if (b2.f) {
            this.setRot(b2.d, b2.e);
            return;
        }
        this.setRot(this.yRot, this.xRot);
    }

    protected void setRot(float f2, float f3) {
        this.yRot = f2;
        this.xRot = f3;
    }

    public void setPos(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        float f5 = this.bbWidth / 2.0f;
        float f6 = this.bbHeight / 2.0f;
        this.bb = new AABB(f2 - f5, f3 - f6, f4 - f5, f2 + f5, f3 + f6, f4 + f5);
    }

    public void turn(float f2, float f3) {
        float f4 = this.xRot;
        float f5 = this.yRot;
        this.yRot = (float)((double)this.yRot + (double)f2 * 0.15);
        this.xRot = (float)((double)this.xRot - (double)f3 * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
        this.xRotO += this.xRot - f4;
        this.yRotO += this.yRot - f5;
    }

    public void interpolateTurn(float f2, float f3) {
        this.yRot = (float)((double)this.yRot + (double)f2 * 0.15);
        this.xRot = (float)((double)this.xRot - (double)f3 * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xRotO = this.xRot;
        this.yRotO = this.yRot;
    }

    public boolean isFree(float f2, float f3, float f4) {
        AABB aABB = this.bb.cloneMove(f2, f3, f4);
        ArrayList arrayList = this.level.getCubes(aABB);
        if (arrayList.size() > 0) {
            return false;
        }
        return !this.level.containsAnyLiquid(aABB);
    }

    public void move(float f2, float f3, float f4) {
        int n2;
        float f5 = this.x;
        float f6 = this.z;
        float f7 = f2;
        float f8 = f3;
        float f9 = f4;
        ArrayList arrayList = this.level.getCubes(this.bb.expand(f2, f3, f4));
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            f3 = ((AABB)arrayList.get(n2)).clipYCollide(this.bb, f3);
        }
        this.bb.move(0.0f, f3, 0.0f);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            f2 = ((AABB)arrayList.get(n2)).clipXCollide(this.bb, f2);
        }
        this.bb.move(f2, 0.0f, 0.0f);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            f4 = ((AABB)arrayList.get(n2)).clipZCollide(this.bb, f4);
        }
        this.bb.move(0.0f, 0.0f, f4);
        this.horizontalCollision = f7 != f2 || f9 != f4;
        boolean bl = this.onGround = f8 != f3 && f8 < 0.0f;
        if (f7 != f2) {
            this.xd = 0.0f;
        }
        if (f8 != f3) {
            this.yd = 0.0f;
        }
        if (f9 != f4) {
            this.zd = 0.0f;
        }
        this.x = (this.bb.x0 + this.bb.x1) / 2.0f;
        this.y = this.bb.y0 + this.heightOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0f;
        float f10 = this.x - f5;
        f2 = this.z - f6;
        this.walkDist = (float)((double)this.walkDist + Math.sqrt(f10 * f10 + f2 * f2) * 0.6);
        if (this.makeStepSound) {
            Tile$SoundType tile$SoundType;
            int n3 = this.level.getTile((int)this.x, (int)(this.y - 0.2f - this.heightOffset), (int)this.z);
            if (this.walkDist > 1.0f && n3 > 0 && (tile$SoundType = com.mojang.minecraft.level.tile.a.b[n3].U) != Tile$SoundType.none) {
                this.walkDist -= (float)((int)this.walkDist);
                this.playSound("step." + tile$SoundType.name, tile$SoundType.getVolume() * 0.75f, tile$SoundType.getPitch());
            }
        }
    }

    public boolean isInWater() {
        return this.level.containsLiquid(this.bb.grow(0.0f, -0.4f, 0.0f), a.b);
    }

    public boolean isInLava() {
        return this.level.containsLiquid(this.bb.grow(0.0f, -0.4f, 0.0f), a.c);
    }

    public void moveRelative(float f2, float f3, float f4) {
        float f5;
        float f6 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        if (f5 < 0.01f) {
            return;
        }
        if (f6 < 1.0f) {
            f6 = 1.0f;
        }
        f6 = f4 / f6;
        f2 *= f6;
        f3 *= f6;
        f4 = (float)Math.sin((double)this.yRot * Math.PI / 180.0);
        f6 = (float)Math.cos((double)this.yRot * Math.PI / 180.0);
        this.xd += f2 * f6 - f3 * f4;
        this.zd += f3 * f6 + f2 * f4;
    }

    public boolean isLit() {
        int n2 = (int)this.x;
        int n3 = (int)this.y;
        int n4 = (int)this.z;
        return this.level.isLit(n2, n3, n4);
    }

    public float getBrightness() {
        int n2 = (int)this.x;
        int n3 = (int)(this.y + this.heightOffset / 2.0f);
        int n4 = (int)this.z;
        return this.level.getBrightness(n2, n3, n4);
    }

    public void render$2a8c5a(com.mojang.minecraft.a.a a2, float f2) {
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void playSound(String string, float f2, float f3) {
        this.level.playSound(string, this, f2, f3);
    }

    public void moveTo(float f2, float f3, float f4, float f5, float f6) {
        this.xo = this.x = f2;
        this.yo = this.y = f3;
        this.zo = this.z = f4;
        this.yRot = f5;
        this.xRot = f6;
        this.setPos(f2, f3, f4);
    }

    public float distanceTo(Entity entity) {
        float f2 = this.x - entity.x;
        float f3 = this.y - entity.y;
        float f4 = this.z - entity.z;
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }
}

