/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.a.g;
import com.mojang.minecraft.level.a.a;
import com.mojang.minecraft.level.b;
import com.mojang.minecraft.phys.AABB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

public class Level
implements Serializable {
    public static final long serialVersionUID = 0L;
    public int width;
    public int height;
    public int depth;
    byte[] blocks;
    public String name;
    public String creator;
    public long createTime;
    public int xSpawn;
    public int ySpawn;
    public int zSpawn;
    public float rotSpawn;
    private transient ArrayList a = new ArrayList();
    private transient int[] b;
    private transient Random c = new Random();
    private transient int d = this.c.nextInt();
    private transient ArrayList e = new ArrayList();
    public ArrayList entities = new ArrayList();
    int unprocessed = 0;
    private int tickCount = 0;

    public void initTransient() {
        if (this.blocks == null) {
            throw new RuntimeException("The level is corrupt!");
        }
        this.a = new ArrayList();
        this.b = new int[this.width * this.height];
        this.calcLightDepths(0, 0, this.width, this.height);
        this.c = new Random();
        this.d = this.c.nextInt();
        this.e = new ArrayList();
        if (this.entities == null) {
            this.entities = new ArrayList();
        }
        if (this.xSpawn == 0 && this.ySpawn == 0 && this.zSpawn == 0) {
            this.findSpawn();
        }
    }

    public void setData(int n, int n2, int n3, byte[] byArray) {
        this.width = n;
        this.height = n3;
        this.depth = n2;
        this.blocks = byArray;
        this.b = new int[n * n3];
        this.calcLightDepths(0, 0, n, n3);
        for (n = 0; n < this.a.size(); ++n) {
            ((g)this.a.get(n)).a();
        }
        this.e.clear();
        this.findSpawn();
    }

    public void findSpawn() {
        int n;
        int n2;
        int n3;
        Random random = new Random();
        int n4 = 0;
        do {
            n2 = random.nextInt(this.width / 2) + this.width / 4;
            n = random.nextInt(this.height / 2) + this.height / 4;
            n3 = this.getHighestTile(n2, n) + 1;
            if (++n4 != 10000) continue;
            this.xSpawn = n2;
            this.ySpawn = -100;
            this.zSpawn = n;
            return;
        } while ((float)n3 <= this.getWaterLevel());
        this.xSpawn = n2;
        this.ySpawn = n3;
        this.zSpawn = n;
    }

    public void calcLightDepths(int n, int n2, int n3, int n4) {
        for (int j = n; j < n + n3; ++j) {
            for (int k = n2; k < n2 + n4; ++k) {
                int n5;
                int n6 = this.b[j + k * this.width];
                for (n5 = this.depth - 1; n5 > 0 && !this.isLightBlocker(j, n5, k); --n5) {
                }
                this.b[j + k * this.width] = n5 + 1;
                if (n6 == n5) continue;
                int n7 = n6 < n5 ? n6 : n5;
                n6 = n6 > n5 ? n6 : n5;
                for (n5 = 0; n5 < this.a.size(); ++n5) {
                    int n8 = n6;
                    int n9 = n7;
                    int n10 = k;
                    int n11 = j;
                    g g2 = (g)this.a.get(n5);
                    g2.a(n11 - 1, n9 - 1, n10 - 1, n11 + 1, n8 + 1, n10 + 1);
                }
            }
        }
    }

    public void addListener$74652038(g g2) {
        this.a.add(g2);
    }

    public void finalize() {
    }

    public void removeListener$74652038(g g2) {
        this.a.remove(g2);
    }

    public boolean isLightBlocker(int n, int n2, int n3) {
        if ((this = com.mojang.minecraft.level.a.a.a[((Level)this).getTile(n, n2, n3)]) == null) {
            return false;
        }
        return ((a)this).a();
    }

    public ArrayList getCubes(AABB aABB) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = (int)aABB.x0;
        int n2 = (int)aABB.x1 + 1;
        int n3 = (int)aABB.y0;
        int n4 = (int)aABB.y1 + 1;
        int n5 = (int)aABB.z0;
        int n6 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n;
        }
        if (aABB.y0 < 0.0f) {
            --n3;
        }
        if (aABB.z0 < 0.0f) {
            --n5;
        }
        for (int j = n; j < n2; ++j) {
            for (n = n3; n < n4; ++n) {
                for (int k = n5; k < n6; ++k) {
                    Object object;
                    if (j >= 0 && n >= 0 && k >= 0 && j < this.width && n < this.depth && k < this.height) {
                        object = com.mojang.minecraft.level.a.a.a[this.getTile(j, n, k)];
                        if (object == null || (object = ((a)object).b(j, n, k)) == null) continue;
                        arrayList.add(object);
                        continue;
                    }
                    if (j >= 0 && n >= 0 && k >= 0 && j < this.width && k < this.height || (object = com.mojang.minecraft.level.a.a.i.b(j, n, k)) == null) continue;
                    arrayList.add(object);
                }
            }
        }
        return arrayList;
    }

    public void swap(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getTile(n, n2, n3);
        int n8 = this.getTile(n4, n5, n6);
        this.setTileNoNeighborChange(n, n2, n3, n8);
        this.setTileNoNeighborChange(n4, n5, n6, n7);
        this.a(n, n2, n3, n8);
        this.a(n4, n5, n6, n7);
    }

    public boolean setTileNoNeighborChange(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.depth || n3 >= this.height) {
            return false;
        }
        if (n4 == this.blocks[(n2 * this.height + n3) * this.width + n]) {
            return false;
        }
        if (n4 == 0 && (n == 0 || n3 == 0 || n == this.width - 1 || n3 == this.height - 1) && (float)n2 >= this.getGroundLevel() && (float)n2 < this.getWaterLevel()) {
            n4 = com.mojang.minecraft.level.a.a.j.v;
        }
        this.blocks[(n2 * this.height + n3) * this.width + n] = (byte)n4;
        this.calcLightDepths(n, n3, 1, 1);
        for (n4 = 0; n4 < this.a.size(); ++n4) {
            int n5 = n3;
            int n6 = n2;
            int n7 = n;
            g g2 = (g)this.a.get(n4);
            g2.a(n7 - 1, n6 - 1, n5 - 1, n7 + 1, n6 + 1, n5 + 1);
        }
        return true;
    }

    public boolean setTile(int n, int n2, int n3, int n4) {
        if (this.setTileNoNeighborChange(n, n2, n3, n4)) {
            this.a(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    private void a(int n, int n2, int n3, int n4) {
        this.b(n - 1, n2, n3, n4);
        this.b(n + 1, n2, n3, n4);
        this.b(n, n2 - 1, n3, n4);
        this.b(n, n2 + 1, n3, n4);
        this.b(n, n2, n3 - 1, n4);
        this.b(n, n2, n3 + 1, n4);
    }

    public boolean setTileNoUpdate(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.depth || n3 >= this.height) {
            return false;
        }
        if (n4 == this.blocks[(n2 * this.height + n3) * this.width + n]) {
            return false;
        }
        this.blocks[(n2 * this.height + n3) * this.width + n] = (byte)n4;
        return true;
    }

    private void b(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.depth || n3 >= this.height) {
            return;
        }
        a a2 = com.mojang.minecraft.level.a.a.a[this.blocks[(n2 * this.height + n3) * this.width + n]];
        if (a2 != null) {
            a2.b(this, n, n2, n3, n4);
        }
    }

    public boolean isLit(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.depth || n3 >= this.height) {
            return true;
        }
        return n2 >= this.b[n + n3 * this.width];
    }

    public int getTile(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.depth || n3 >= this.height) {
            return 0;
        }
        return this.blocks[(n2 * this.height + n3) * this.width + n];
    }

    public boolean isSolidTile(int n, int n2, int n3) {
        if ((this = com.mojang.minecraft.level.a.a.a[((Level)this).getTile(n, n2, n3)]) == null) {
            return false;
        }
        return ((a)this).b();
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        int n4;
        ++this.tickCount;
        for (n4 = 0; n4 < this.entities.size(); ++n4) {
            ((Entity)this.entities.get(n4)).tick();
            if (!((Entity)this.entities.get((int)n4)).removed) continue;
            this.entities.remove(n4--);
        }
        n4 = 1;
        int n5 = 1;
        while (1 << n4 < this.width) {
            ++n4;
        }
        while (1 << n5 < this.height) {
            ++n5;
        }
        int n6 = this.height - 1;
        int n7 = this.width - 1;
        int n8 = this.depth - 1;
        if (this.tickCount % 5 == 0) {
            n3 = this.e.size();
            for (n2 = 0; n2 < n3; ++n2) {
                b b2 = (b)this.e.remove(0);
                if (!this.a(b2.a, b2.b, b2.c) || (n = this.blocks[(b2.b * this.height + b2.c) * this.width + b2.a]) != b2.d || n <= 0) continue;
                com.mojang.minecraft.level.a.a.a[n].a(this, b2.a, b2.b, b2.c, this.c);
            }
        }
        this.unprocessed += this.width * this.height * this.depth;
        n3 = this.unprocessed / 200;
        this.unprocessed -= n3 * 200;
        for (n2 = 0; n2 < n3; ++n2) {
            this.d = this.d * 3 + 1013904223;
            int n9 = this.d >> 2;
            int n10 = n9 >> n4 & n6;
            n = n9 & n7;
            byte by = this.blocks[((n9 = n9 >> n4 + n5 & n8) * this.height + n10) * this.width + n];
            if (!com.mojang.minecraft.level.a.a.b[by]) continue;
            com.mojang.minecraft.level.a.a.a[by].a(this, n, n9, n10, this.c);
        }
    }

    private boolean a(int n, int n2, int n3) {
        return n >= 0 && n2 >= 0 && n3 >= 0 && n < this.width && n2 < this.depth && n3 < this.height;
    }

    public float getGroundLevel() {
        return this.depth / 2 - 2;
    }

    public float getWaterLevel() {
        return this.depth / 2;
    }

    public boolean containsAnyLiquid(AABB aABB) {
        int n = (int)aABB.x0;
        int n2 = (int)aABB.x1 + 1;
        int n3 = (int)aABB.y0;
        int n4 = (int)aABB.y1 + 1;
        int n5 = (int)aABB.z0;
        int n6 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n;
        }
        if (aABB.y0 < 0.0f) {
            --n3;
        }
        if (aABB.z0 < 0.0f) {
            --n5;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n2 > this.width) {
            n2 = this.width;
        }
        if (n4 > this.depth) {
            n4 = this.depth;
        }
        if (n6 > this.height) {
            n6 = this.height;
        }
        for (int j = n; j < n2; ++j) {
            for (n = n3; n < n4; ++n) {
                for (int k = n5; k < n6; ++k) {
                    a a2 = com.mojang.minecraft.level.a.a.a[this.getTile(j, n, k)];
                    if (a2 == null || a2.d() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AABB aABB, int n) {
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n5 > this.depth) {
            n5 = this.depth;
        }
        if (n7 > this.height) {
            n7 = this.height;
        }
        for (int j = n2; j < n3; ++j) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int k = n6; k < n7; ++k) {
                    a a2 = com.mojang.minecraft.level.a.a.a[this.getTile(j, n2, k)];
                    if (a2 == null || a2.d() != n) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addToTickNextTick(int n, int n2, int n3, int n4) {
        this.e.add(new b(n, n2, n3, n4));
    }

    public boolean isFree(AABB aABB) {
        for (int j = 0; j < this.entities.size(); ++j) {
            if (!((Entity)this.entities.get((int)j)).bb.intersects(aABB)) continue;
            return false;
        }
        return true;
    }

    public boolean isSolid(float f2, float f3, float f4, float f5) {
        if (this.a(f2 - f5, f3 - f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 - f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 + f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 + f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 - f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 - f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 + f5, f4 - f5)) {
            return true;
        }
        return this.a(f2 + f5, f3 + f5, f4 + f5);
    }

    private boolean a(float f2, float f3, float f4) {
        int n = this.getTile((int)f2, (int)f3, (int)f4);
        return n > 0 && com.mojang.minecraft.level.a.a.a[n].b();
    }

    public int getHighestTile(int n, int n2) {
        int n3;
        for (n3 = this.depth; (this.getTile(n, n3 - 1, n2) == 0 || com.mojang.minecraft.level.a.a.a[this.getTile(n, n3 - 1, n2)].d() != 0) && n3 > 0; --n3) {
        }
        return n3;
    }

    public void setSpawnPos(int n, int n2, int n3, float f2) {
        this.xSpawn = n;
        this.ySpawn = n2;
        this.zSpawn = n3;
        this.rotSpawn = f2;
    }

    public float getBrightness(int n, int n2, int n3) {
        if (this.isLit(n, n2, n3)) {
            return 1.0f;
        }
        return 0.5f;
    }

    public float getCaveness(float f2, float f3, float f4, float f5) {
        int n = (int)f2;
        int n2 = (int)f3;
        int n3 = (int)f4;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int j = n - 6; j <= n + 6; ++j) {
            for (int k = n3 - 6; k <= n3 + 6; ++k) {
                if (!this.a(j, n2, k) || this.isSolidTile(j, n2, k)) continue;
                float f8 = (float)j + 0.5f - f2;
                float f9 = (float)k + 0.5f - f4;
                float f10 = (float)(Math.atan2(f9, f8) - (double)f5 * Math.PI / 180.0 + 1.5707963267948966);
                while ((double)f10 < -Math.PI) {
                    f10 = (float)((double)f10 + Math.PI * 2);
                }
                while ((double)f10 >= Math.PI) {
                    f10 = (float)((double)f10 - Math.PI * 2);
                }
                if (f10 < 0.0f) {
                    f10 = -f10;
                }
                f8 = (float)Math.sqrt(f8 * f8 + 4.0f + f9 * f9);
                f8 = 1.0f / f8;
                if (f10 > 1.0f) {
                    f8 = 0.0f;
                }
                if (f8 < 0.0f) {
                    f8 = 0.0f;
                }
                f7 += f8;
                if (!this.isLit(j, n2, k)) continue;
                f6 += f8;
            }
        }
        if (f7 == 0.0f) {
            return 0.0f;
        }
        return f6 / f7;
    }

    public float getCaveness(Entity entity) {
        float f2;
        float f3 = (float)Math.cos((double)(-entity.yRot) * Math.PI / 180.0 + Math.PI);
        float f4 = (float)Math.sin((double)(-entity.yRot) * Math.PI / 180.0 + Math.PI);
        float f5 = (float)Math.cos((double)(-entity.xRot) * Math.PI / 180.0);
        float f6 = (float)Math.sin((double)(-entity.xRot) * Math.PI / 180.0);
        float f7 = entity.x;
        float f8 = entity.y;
        float f9 = entity.z;
        float f10 = 1.6f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        for (int j = 0; j <= 10; ++j) {
            float f13 = ((float)j / (float)10 - 0.5f) * 2.0f;
            for (int k = 0; k <= 10; ++k) {
                float f14;
                float f15;
                float f16;
                float f17 = ((float)k / (float)10 - 0.5f) * f10;
                float f18 = f13;
                float f19 = f5 * f17 + f6;
                f17 = f5 - f6 * f17;
                float f20 = f3 * f18 + f4 * f17;
                f17 = f3 * f17 - f4 * f18;
                for (int i2 = 0; i2 < 20 && !this.a(f16 = f7 + f20 * (float)i2 * 0.8f, f15 = f8 + f19 * (float)i2 * 0.8f, f14 = f9 + f17 * (float)i2 * 0.8f); ++i2) {
                    f11 += 1.0f;
                    if (!this.isLit((int)f16, (int)f15, (int)f14)) continue;
                    f12 += 1.0f;
                }
            }
        }
        if (f11 == 0.0f) {
            return 0.0f;
        }
        float f21 = f12 / f11;
        f21 /= 0.1f;
        if (f2 > 1.0f) {
            f21 = 1.0f;
        }
        f21 = 1.0f - f21;
        return 1.0f - f21 * f21 * f21;
    }
}

