/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ContainerNode$NoNodesIterator;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode {
    protected ArrayList _children;

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    protected ArrayNode(JsonNodeFactory jsonNodeFactory, ArrayList arrayList) {
        super(jsonNodeFactory);
        this._children = arrayList;
    }

    public ArrayNode deepCopy() {
        if (this._children == null) {
            return new ArrayNode(this._nodeFactory);
        }
        int n2 = this._children.size();
        ArrayList<JsonNode> arrayList = new ArrayList<JsonNode>(Math.max(4, n2));
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((JsonNode)this._children.get(i2)).deepCopy());
        }
        return new ArrayNode(this._nodeFactory, arrayList);
    }

    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    public boolean isArray() {
        return true;
    }

    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    public Iterator elements() {
        return this._children == null ? ContainerNode$NoNodesIterator.instance() : this._children.iterator();
    }

    public JsonNode get(int n2) {
        if (n2 >= 0 && this._children != null && n2 < this._children.size()) {
            return (JsonNode)this._children.get(n2);
        }
        return null;
    }

    public JsonNode get(String string) {
        return null;
    }

    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    public JsonNode path(int n2) {
        if (n2 >= 0 && this._children != null && n2 < this._children.size()) {
            return (JsonNode)this._children.get(n2);
        }
        return MissingNode.getInstance();
    }

    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartArray();
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndArray();
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForArray(this, jsonGenerator);
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForArray(this, jsonGenerator);
    }

    public JsonNode findValue(String string) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                JsonNode jsonNode2 = jsonNode.findValue(string);
                if (jsonNode2 == null) continue;
                return jsonNode2;
            }
        }
        return null;
    }

    public List findValues(String string, List list) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                list = jsonNode.findValues(string, list);
            }
        }
        return list;
    }

    public List findValuesAsText(String string, List list) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                list = jsonNode.findValuesAsText(string, list);
            }
        }
        return list;
    }

    public ObjectNode findParent(String string) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                JsonNode jsonNode2 = jsonNode.findParent(string);
                if (jsonNode2 == null) continue;
                return (ObjectNode)jsonNode2;
            }
        }
        return null;
    }

    public List findParents(String string, List list) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                list = jsonNode.findParents(string, list);
            }
        }
        return list;
    }

    public JsonNode set(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._set(n2, jsonNode);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        int n2 = arrayNode.size();
        if (n2 > 0) {
            if (this._children == null) {
                this._children = new ArrayList(n2 + 2);
            }
            arrayNode.addContentsTo(this._children);
        }
        return this;
    }

    public ArrayNode addAll(Collection collection) {
        int n2 = collection.size();
        if (n2 > 0) {
            if (this._children == null) {
                this._children = new ArrayList(collection);
            } else {
                this._children.addAll(collection);
            }
        }
        return this;
    }

    public ArrayNode insert(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._insert(n2, jsonNode);
        return this;
    }

    public JsonNode remove(int n2) {
        if (n2 >= 0 && this._children != null && n2 < this._children.size()) {
            return (JsonNode)this._children.remove(n2);
        }
        return null;
    }

    public ArrayNode removeAll() {
        this._children = null;
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        if (object == null) {
            this.addNull();
        } else {
            this._add(this.POJONode(object));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int n2) {
        this._add(this.numberNode(n2));
        return this;
    }

    public ArrayNode add(Integer n2) {
        if (n2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(n2));
    }

    public ArrayNode add(long l2) {
        return this._add(this.numberNode(l2));
    }

    public ArrayNode add(Long l2) {
        if (l2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(l2));
    }

    public ArrayNode add(float f2) {
        return this._add(this.numberNode(f2));
    }

    public ArrayNode add(Float f2) {
        if (f2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(f2.floatValue()));
    }

    public ArrayNode add(double d2) {
        return this._add(this.numberNode(d2));
    }

    public ArrayNode add(Double d2) {
        if (d2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(d2));
    }

    public ArrayNode add(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(bigDecimal));
    }

    public ArrayNode add(String string) {
        if (string == null) {
            return this.addNull();
        }
        return this._add(this.textNode(string));
    }

    public ArrayNode add(boolean bl) {
        return this._add(this.booleanNode(bl));
    }

    public ArrayNode add(Boolean bl) {
        if (bl == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(bl));
    }

    public ArrayNode add(byte[] byArray) {
        if (byArray == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(byArray));
    }

    public ArrayNode insertArray(int n2) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n2, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n2) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n2, objectNode);
        return objectNode;
    }

    public ArrayNode insertPOJO(int n2, Object object) {
        if (object == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.POJONode(object));
    }

    public ArrayNode insertNull(int n2) {
        this._insert(n2, this.nullNode());
        return this;
    }

    public ArrayNode insert(int n2, int n3) {
        this._insert(n2, this.numberNode(n3));
        return this;
    }

    public ArrayNode insert(int n2, Integer n3) {
        if (n3 == null) {
            this.insertNull(n2);
        } else {
            this._insert(n2, this.numberNode(n3));
        }
        return this;
    }

    public ArrayNode insert(int n2, long l2) {
        return this._insert(n2, this.numberNode(l2));
    }

    public ArrayNode insert(int n2, Long l2) {
        if (l2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(l2));
    }

    public ArrayNode insert(int n2, float f2) {
        return this._insert(n2, this.numberNode(f2));
    }

    public ArrayNode insert(int n2, Float f2) {
        if (f2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(f2.floatValue()));
    }

    public ArrayNode insert(int n2, double d2) {
        return this._insert(n2, this.numberNode(d2));
    }

    public ArrayNode insert(int n2, Double d2) {
        if (d2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(d2));
    }

    public ArrayNode insert(int n2, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(bigDecimal));
    }

    public ArrayNode insert(int n2, String string) {
        if (string == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.textNode(string));
    }

    public ArrayNode insert(int n2, boolean bl) {
        return this._insert(n2, this.booleanNode(bl));
    }

    public ArrayNode insert(int n2, Boolean bl) {
        if (bl == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.booleanNode(bl));
    }

    public ArrayNode insert(int n2, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.binaryNode(byArray));
    }

    protected void addContentsTo(List list) {
        if (this._children != null) {
            for (JsonNode jsonNode : this._children) {
                list.add(jsonNode);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)object;
        if (this._children == null || this._children.size() == 0) {
            return arrayNode.size() == 0;
        }
        return arrayNode._sameChildren(this._children);
    }

    public int hashCode() {
        int n2;
        if (this._children == null) {
            n2 = 1;
        } else {
            n2 = this._children.size();
            for (JsonNode jsonNode : this._children) {
                if (jsonNode == null) continue;
                n2 ^= jsonNode.hashCode();
            }
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(16 + (this.size() << 4));
        stringBuilder.append('[');
        if (this._children != null) {
            int n2 = this._children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(((JsonNode)this._children.get(i2)).toString());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public JsonNode _set(int n2, JsonNode jsonNode) {
        if (this._children == null || n2 < 0 || n2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
        }
        return this._children.set(n2, jsonNode);
    }

    private ArrayNode _add(JsonNode jsonNode) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(jsonNode);
        return this;
    }

    private ArrayNode _insert(int n2, JsonNode jsonNode) {
        if (this._children == null) {
            this._children = new ArrayList();
            this._children.add(jsonNode);
            return this;
        }
        if (n2 < 0) {
            this._children.add(0, jsonNode);
        } else if (n2 >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n2, jsonNode);
        }
        return this;
    }

    private boolean _sameChildren(ArrayList arrayList) {
        int n2 = arrayList.size();
        if (this.size() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((JsonNode)this._children.get(i2)).equals(arrayList.get(i2))) continue;
            return false;
        }
        return true;
    }
}

