/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$ByteDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$ByteDeser() {
        super(byte[].class);
    }

    public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return (byte[])object;
            }
        }
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        object = deserializationContext.getArrayBuilders().getByteBuilder();
        byte[] byArray = (byte[])((PrimitiveArrayBuilder)object).resetAndStart();
        int n2 = 0;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            byte by2;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                by2 = jsonParser.getByteValue();
            } else {
                if (jsonToken != JsonToken.VALUE_NULL) {
                    throw deserializationContext.mappingException(this._valueClass.getComponentType());
                }
                by2 = 0;
            }
            if (n2 >= byArray.length) {
                byArray = (byte[])((PrimitiveArrayBuilder)object).appendCompletedChunk(byArray, n2);
                n2 = 0;
            }
            byArray[n2++] = by2;
        }
        return (byte[])((PrimitiveArrayBuilder)object).completeAndClearBuffer(byArray, n2);
    }

    private final byte[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        byte by2;
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            by2 = jsonParser.getByteValue();
        } else {
            if (jsonToken != JsonToken.VALUE_NULL) {
                throw deserializationContext.mappingException(this._valueClass.getComponentType());
            }
            by2 = 0;
        }
        return new byte[]{by2};
    }
}

