/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.base;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.VersionUtil;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_APOSTROPHE = 39;
    protected static final int INT_b = 98;
    protected static final int INT_f = 102;
    protected static final int INT_n = 110;
    protected static final int INT_r = 114;
    protected static final int INT_t = 116;
    protected static final int INT_u = 117;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    public ParserMinimalBase(int n2) {
        super(n2);
    }

    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    public abstract JsonToken nextToken();

    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    public JsonToken nextValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    public JsonParser skipChildren() {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (jsonToken) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++n2;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--n2 != 0) break;
                    return this;
                }
            }
        }
    }

    protected abstract void _handleEOF();

    public abstract String getCurrentName();

    public abstract void close();

    public abstract boolean isClosed();

    public abstract JsonStreamContext getParsingContext();

    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    public abstract void overrideCurrentName(String var1);

    public abstract String getText();

    public abstract char[] getTextCharacters();

    public abstract boolean hasTextCharacters();

    public abstract int getTextLength();

    public abstract int getTextOffset();

    public abstract byte[] getBinaryValue(Base64Variant var1);

    public boolean getValueAsBoolean(boolean bl) {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: {
                    return this.getIntValue() != 0;
                }
                case VALUE_TRUE: {
                    return true;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return false;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (object instanceof Boolean) {
                        return (Boolean)object;
                    }
                }
                case VALUE_STRING: {
                    Object object = this.getText().trim();
                    if (!"true".equals(object)) break;
                    return true;
                }
            }
        }
        return bl;
    }

    public int getValueAsInt(int n2) {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getIntValue();
                }
                case VALUE_TRUE: {
                    return 1;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsInt(this.getText(), n2);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n2;
    }

    public long getValueAsLong(long l2) {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getLongValue();
                }
                case VALUE_TRUE: {
                    return 1L;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0L;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsLong(this.getText(), l2);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l2;
    }

    public double getValueAsDouble(double d2) {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getDoubleValue();
                }
                case VALUE_TRUE: {
                    return 1.0;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0.0;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsDouble(this.getText(), d2);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d2;
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) {
        int n2 = 0;
        int n3 = string.length();
        block0: while (n2 < n3) {
            char c2;
            do {
                c2 = string.charAt(n2++);
                if (n2 >= n3) break block0;
            } while (c2 <= ' ');
            int n4 = base64Variant.decodeBase64Char(c2);
            if (n4 < 0) {
                this._reportInvalidBase64(base64Variant, c2, 0, null);
            }
            int n5 = n4;
            if (n2 >= n3) {
                this._reportBase64EOF();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                this._reportInvalidBase64(base64Variant, c2, 1, null);
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.append(n5 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(base64Variant, c2, 2, null);
                }
                if (n2 >= n3) {
                    this._reportBase64EOF();
                }
                if (!base64Variant.usesPaddingChar(c2 = string.charAt(n2++))) {
                    this._reportInvalidBase64(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n5 >>= 4);
                continue;
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(base64Variant, c2, 3, null);
                }
                byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                continue;
            }
            n5 = n5 << 6 | n4;
            byteArrayBuilder.appendThreeBytes(n5);
        }
    }

    protected void _reportInvalidBase64(Base64Variant base64Variant, char c2, int n2, String string) {
        String string2 = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c2) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c2) || Character.isISOControl(c2) ? "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructError(string2);
    }

    protected void _reportBase64EOF() {
        throw this._constructError("Unexpected end-of-String in base64 content");
    }

    protected void _reportUnexpectedChar(int n2, String string) {
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n2) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _reportInvalidEOFInValue() {
        this._reportInvalidEOF(" in a value");
    }

    protected void _throwInvalidSpace(int n2) {
        char c2 = (char)n2;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n2, String string) {
        if (!this.isEnabled(JsonParser$Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 >= 32) {
            char c2 = (char)n2;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c2) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c2) {
        if (this.isEnabled(JsonParser$Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c2));
        return c2;
    }

    protected static final String _getCharDesc(int n2) {
        char c2 = (char)n2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + n2 + ")";
        }
        if (n2 > 255) {
            return "'" + c2 + "' (code " + n2 + " / 0x" + Integer.toHexString(n2) + ")";
        }
        return "'" + c2 + "' (code " + n2 + ")";
    }

    protected final void _reportError(String string) {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }
}

