/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json.cfg;

import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.jaxrs.json.Annotations;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.util.ArrayList;

public class MapperConfigurator {
    protected ObjectMapper _mapper;
    protected ObjectMapper _defaultMapper;
    protected Annotations[] _defaultAnnotationsToUse;
    protected Class _jaxbIntrospectorClass;

    public MapperConfigurator(ObjectMapper objectMapper, Annotations[] annotationsArray) {
        this._mapper = objectMapper;
        this._defaultAnnotationsToUse = annotationsArray;
    }

    public synchronized ObjectMapper getConfiguredMapper() {
        return this._mapper;
    }

    public synchronized ObjectMapper getDefaultMapper() {
        if (this._defaultMapper == null) {
            this._defaultMapper = new ObjectMapper();
            this._setAnnotations(this._defaultMapper, this._defaultAnnotationsToUse);
        }
        return this._defaultMapper;
    }

    public synchronized void setMapper(ObjectMapper objectMapper) {
        this._mapper = objectMapper;
    }

    public synchronized void setAnnotationsToUse(Annotations[] annotationsArray) {
        this._setAnnotations(this.mapper(), annotationsArray);
    }

    public synchronized void configure(DeserializationFeature deserializationFeature, boolean bl) {
        this.mapper().configure(deserializationFeature, bl);
    }

    public synchronized void configure(SerializationFeature serializationFeature, boolean bl) {
        this.mapper().configure(serializationFeature, bl);
    }

    public synchronized void configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        this.mapper().configure(jsonParser$Feature, bl);
    }

    public synchronized void configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        this.mapper().configure(jsonGenerator$Feature, bl);
    }

    protected ObjectMapper mapper() {
        if (this._mapper == null) {
            this._mapper = new ObjectMapper();
            this._setAnnotations(this._mapper, this._defaultAnnotationsToUse);
        }
        return this._mapper;
    }

    protected void _setAnnotations(ObjectMapper objectMapper, Annotations[] annotationsArray) {
        AnnotationIntrospector annotationIntrospector = annotationsArray == null || annotationsArray.length == 0 ? AnnotationIntrospector.nopInstance() : this._resolveIntrospectors(annotationsArray);
        objectMapper.setAnnotationIntrospector(annotationIntrospector);
    }

    protected AnnotationIntrospector _resolveIntrospectors(Annotations[] annotationsArray) {
        int n2;
        ArrayList<AnnotationIntrospector> arrayList = new ArrayList<AnnotationIntrospector>();
        Annotations[] annotationsArray2 = annotationsArray;
        int n3 = annotationsArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Annotations annotations = annotationsArray2[n2];
            if (annotations == null) continue;
            arrayList.add(this._resolveIntrospector(annotations));
        }
        int n4 = arrayList.size();
        if (n4 == 0) {
            return AnnotationIntrospector.nopInstance();
        }
        AnnotationIntrospector annotationIntrospector = (AnnotationIntrospector)arrayList.get(0);
        int n5 = arrayList.size();
        for (n2 = 1; n2 < n5; ++n2) {
            annotationIntrospector = AnnotationIntrospector.pair(annotationIntrospector, (AnnotationIntrospector)arrayList.get(n2));
        }
        return annotationIntrospector;
    }

    protected AnnotationIntrospector _resolveIntrospector(Annotations annotations) {
        switch (annotations) {
            case JACKSON: {
                return new JacksonAnnotationIntrospector();
            }
            case JAXB: {
                try {
                    if (this._jaxbIntrospectorClass == null) {
                        this._jaxbIntrospectorClass = JaxbAnnotationIntrospector.class;
                    }
                    return (AnnotationIntrospector)this._jaxbIntrospectorClass.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Failed to instantiate JaxbAnnotationIntrospector: " + exception.getMessage(), exception);
                }
            }
        }
        throw new IllegalStateException();
    }
}

