/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer
implements ContextualSerializer {
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final HashSet _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer _keySerializer;
    protected JsonSerializer _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;

    protected MapSerializer(HashSet hashSet, JavaType javaType, JavaType javaType2, boolean bl, TypeSerializer typeSerializer, JsonSerializer jsonSerializer, JsonSerializer jsonSerializer2) {
        super(Map.class, false);
        this._ignoredEntries = hashSet;
        this._keyType = javaType;
        this._valueType = javaType2;
        this._valueTypeIsStatic = bl;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
    }

    protected MapSerializer(MapSerializer mapSerializer, BeanProperty beanProperty, JsonSerializer jsonSerializer, JsonSerializer jsonSerializer2, HashSet hashSet) {
        super(Map.class, false);
        this._ignoredEntries = hashSet;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = beanProperty;
    }

    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new MapSerializer(this, typeSerializer);
    }

    public MapSerializer withResolved(BeanProperty beanProperty, JsonSerializer jsonSerializer, JsonSerializer jsonSerializer2, HashSet hashSet) {
        return new MapSerializer(this, beanProperty, jsonSerializer, jsonSerializer2, hashSet);
    }

    public static MapSerializer construct(String[] stringArray, JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer jsonSerializer, JsonSerializer jsonSerializer2) {
        JavaType javaType2;
        JavaType javaType3;
        HashSet hashSet = MapSerializer.toSet(stringArray);
        if (javaType == null) {
            javaType2 = javaType3 = UNSPECIFIED_TYPE;
        } else {
            javaType2 = javaType.getKeyType();
            javaType3 = javaType.getContentType();
        }
        if (!bl) {
            bl = javaType3 != null && javaType3.isFinal();
        }
        return new MapSerializer(hashSet, javaType2, javaType3, bl, typeSerializer, jsonSerializer, jsonSerializer2);
    }

    private static HashSet toSet(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return hashSet;
    }

    public JsonSerializer createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        String[] stringArray;
        JsonSerializer jsonSerializer;
        JsonSerializer jsonSerializer2 = this._valueSerializer;
        if (jsonSerializer2 == null) {
            if (this._valueTypeIsStatic) {
                jsonSerializer2 = serializerProvider.findValueSerializer(this._valueType, beanProperty);
            }
        } else if (jsonSerializer2 instanceof ContextualSerializer) {
            jsonSerializer2 = ((ContextualSerializer)((Object)jsonSerializer2)).createContextual(serializerProvider, beanProperty);
        }
        if ((jsonSerializer = this._keySerializer) == null) {
            jsonSerializer = serializerProvider.findKeySerializer(this._keyType, beanProperty);
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        HashSet<String> hashSet = this._ignoredEntries;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (stringArray = annotationIntrospector.findPropertiesToIgnore(beanProperty.getMember())) != null) {
            hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        return this.withResolved(beanProperty, jsonSerializer, jsonSerializer2, hashSet);
    }

    public JavaType getContentType() {
        return this._valueType;
    }

    public JsonSerializer getContentSerializer() {
        return this._valueSerializer;
    }

    public boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public boolean hasSingleElement(Map map) {
        return map.size() == 1;
    }

    public JsonSerializer getKeySerializer() {
        return this._keySerializer;
    }

    public void serialize(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartObject();
        if (!map.isEmpty()) {
            if (serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map = this._orderEntries(map);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map, jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForObject(map, jsonGenerator);
        if (!map.isEmpty()) {
            if (serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map = this._orderEntries(map);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map, jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForObject(map, jsonGenerator);
    }

    public void serializeFields(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider);
            return;
        }
        JsonSerializer jsonSerializer = this._keySerializer;
        HashSet hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry entry : map.entrySet()) {
            Object v2 = entry.getValue();
            Object k2 = entry.getKey();
            if (k2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && v2 == null || hashSet != null && hashSet.contains(k2)) continue;
                jsonSerializer.serialize(k2, jsonGenerator, serializerProvider);
            }
            if (v2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz = v2.getClass();
            JsonSerializer jsonSerializer2 = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer2 == null) {
                jsonSerializer2 = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                propertySerializerMap = this._dynamicValueSerializers;
            }
            try {
                jsonSerializer2.serialize(v2, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                String string = "" + k2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)map, string);
            }
        }
    }

    protected void serializeFieldsUsing(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer jsonSerializer) {
        JsonSerializer jsonSerializer2 = this._keySerializer;
        HashSet hashSet = this._ignoredEntries;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry entry : map.entrySet()) {
            Object v2 = entry.getValue();
            Object k2 = entry.getKey();
            if (k2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && v2 == null || hashSet != null && hashSet.contains(k2)) continue;
                jsonSerializer2.serialize(k2, jsonGenerator, serializerProvider);
            }
            if (v2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(v2, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(v2, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                String string = "" + k2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)map, string);
            }
        }
    }

    protected void serializeTypedFields(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        JsonSerializer jsonSerializer = this._keySerializer;
        JsonSerializer jsonSerializer2 = null;
        Class<?> clazz = null;
        HashSet hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry entry : map.entrySet()) {
            JsonSerializer jsonSerializer3;
            Object v2 = entry.getValue();
            Object k2 = entry.getKey();
            if (k2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && v2 == null || hashSet != null && hashSet.contains(k2)) continue;
                jsonSerializer.serialize(k2, jsonGenerator, serializerProvider);
            }
            if (v2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz2 = v2.getClass();
            if (clazz2 == clazz) {
                jsonSerializer3 = jsonSerializer2;
            } else {
                jsonSerializer2 = jsonSerializer3 = serializerProvider.findValueSerializer(clazz2, this._property);
                clazz = clazz2;
            }
            try {
                jsonSerializer3.serializeWithType(v2, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            }
            catch (Exception exception) {
                String string = "" + k2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)map, string);
            }
        }
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("object", true);
        return objectNode;
    }

    protected final JsonSerializer _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class clazz, SerializerProvider serializerProvider) {
        PropertySerializerMap$SerializerAndMapResult propertySerializerMap$SerializerAndMapResult = propertySerializerMap.findAndAddSerializer(clazz, serializerProvider, this._property);
        if (propertySerializerMap != propertySerializerMap$SerializerAndMapResult.map) {
            this._dynamicValueSerializers = propertySerializerMap$SerializerAndMapResult.map;
        }
        return propertySerializerMap$SerializerAndMapResult.serializer;
    }

    protected final JsonSerializer _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType, SerializerProvider serializerProvider) {
        PropertySerializerMap$SerializerAndMapResult propertySerializerMap$SerializerAndMapResult = propertySerializerMap.findAndAddSerializer(javaType, serializerProvider, this._property);
        if (propertySerializerMap != propertySerializerMap$SerializerAndMapResult.map) {
            this._dynamicValueSerializers = propertySerializerMap$SerializerAndMapResult.map;
        }
        return propertySerializerMap$SerializerAndMapResult.serializer;
    }

    protected Map _orderEntries(Map map) {
        if (map instanceof SortedMap) {
            return map;
        }
        return new TreeMap(map);
    }
}

