/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateTimeSerializerBase
extends StdScalarSerializer
implements ContextualSerializer {
    protected final boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class clazz, boolean bl, DateFormat dateFormat) {
        super(clazz);
        this._useTimestamp = bl;
        this._customFormat = dateFormat;
    }

    public abstract DateTimeSerializerBase withFormat(boolean var1, DateFormat var2);

    public JsonSerializer createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonFormat$Value jsonFormat$Value;
        if (beanProperty != null && (jsonFormat$Value = serializerProvider.getAnnotationIntrospector().findFormat(beanProperty.getMember())) != null) {
            if (jsonFormat$Value.getShape().isNumeric()) {
                return this.withFormat(true, null);
            }
            TimeZone timeZone = jsonFormat$Value.getTimeZone();
            String string = jsonFormat$Value.getPattern();
            if (string.length() > 0) {
                Locale locale = jsonFormat$Value.getLocale();
                if (locale == null) {
                    locale = serializerProvider.getLocale();
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                if (timeZone == null) {
                    timeZone = serializerProvider.getTimeZone();
                }
                simpleDateFormat.setTimeZone(timeZone);
                return this.withFormat(false, simpleDateFormat);
            }
            if (timeZone != null) {
                DateFormat dateFormat = serializerProvider.getConfig().getDateFormat();
                if (dateFormat.getClass() == StdDateFormat.class) {
                    dateFormat = StdDateFormat.getISO8601Format(timeZone);
                } else {
                    dateFormat = (DateFormat)dateFormat.clone();
                    dateFormat.setTimeZone(timeZone);
                }
                return this.withFormat(false, dateFormat);
            }
        }
        return this;
    }

    public boolean isEmpty(Object object) {
        return object == null || this._timestamp(object) == 0L;
    }

    protected abstract long _timestamp(Object var1);

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        boolean bl = this._useTimestamp;
        if (!bl && this._customFormat == null) {
            bl = serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return this.createSchemaNode(bl ? "number" : "string", true);
    }

    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3);
}

