/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes$Type;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.AnnotationIntrospector$ReferenceProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer$None;
import com.fasterxml.jackson.databind.JsonSerializer$None;
import com.fasterxml.jackson.databind.KeyDeserializer$None;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder$Value;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize$Inclusion;
import com.fasterxml.jackson.databind.annotation.JsonSerialize$Typing;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector {
    public Version version() {
        return DatabindVersion.instance.version();
    }

    public boolean isHandled(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        return clazz.getAnnotation(JacksonAnnotation.class) != null;
    }

    public boolean isAnnotationBundle(Annotation annotation) {
        return annotation.annotationType().getAnnotation(JacksonAnnotationsInside.class) != null;
    }

    public String findEnumValue(Enum enum_) {
        return enum_.name();
    }

    public String findRootName(AnnotatedClass annotatedClass) {
        JsonRootName jsonRootName = (JsonRootName)annotatedClass.getAnnotation(JsonRootName.class);
        return jsonRootName == null ? null : jsonRootName.value();
    }

    public String[] findPropertiesToIgnore(Annotated annotated) {
        JsonIgnoreProperties jsonIgnoreProperties = (JsonIgnoreProperties)annotated.getAnnotation(JsonIgnoreProperties.class);
        return jsonIgnoreProperties == null ? null : jsonIgnoreProperties.value();
    }

    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        JsonIgnoreProperties jsonIgnoreProperties = (JsonIgnoreProperties)annotatedClass.getAnnotation(JsonIgnoreProperties.class);
        return jsonIgnoreProperties == null ? null : Boolean.valueOf(jsonIgnoreProperties.ignoreUnknown());
    }

    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        JsonIgnoreType jsonIgnoreType = (JsonIgnoreType)annotatedClass.getAnnotation(JsonIgnoreType.class);
        return jsonIgnoreType == null ? null : Boolean.valueOf(jsonIgnoreType.value());
    }

    public Object findFilterId(AnnotatedClass annotatedClass) {
        String string;
        JsonFilter jsonFilter = (JsonFilter)annotatedClass.getAnnotation(JsonFilter.class);
        if (jsonFilter != null && (string = jsonFilter.value()).length() > 0) {
            return string;
        }
        return null;
    }

    public VisibilityChecker findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker visibilityChecker) {
        JsonAutoDetect jsonAutoDetect = (JsonAutoDetect)annotatedClass.getAnnotation(JsonAutoDetect.class);
        return jsonAutoDetect == null ? visibilityChecker : visibilityChecker.with(jsonAutoDetect);
    }

    public AnnotationIntrospector$ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        JsonManagedReference jsonManagedReference = (JsonManagedReference)annotatedMember.getAnnotation(JsonManagedReference.class);
        if (jsonManagedReference != null) {
            return AnnotationIntrospector$ReferenceProperty.managed(jsonManagedReference.value());
        }
        JsonBackReference jsonBackReference = (JsonBackReference)annotatedMember.getAnnotation(JsonBackReference.class);
        if (jsonBackReference != null) {
            return AnnotationIntrospector$ReferenceProperty.back(jsonBackReference.value());
        }
        return null;
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        JsonUnwrapped jsonUnwrapped = (JsonUnwrapped)annotatedMember.getAnnotation(JsonUnwrapped.class);
        if (jsonUnwrapped == null || !jsonUnwrapped.enabled()) {
            return null;
        }
        String string = jsonUnwrapped.prefix();
        String string2 = jsonUnwrapped.suffix();
        return NameTransformer.simpleTransformer(string, string2);
    }

    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._isIgnorable(annotatedMember);
    }

    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        JsonProperty jsonProperty = (JsonProperty)annotatedMember.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.required();
        }
        return null;
    }

    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        JacksonInject jacksonInject = (JacksonInject)annotatedMember.getAnnotation(JacksonInject.class);
        if (jacksonInject == null) {
            return null;
        }
        String string = jacksonInject.value();
        if (string.length() == 0) {
            if (!(annotatedMember instanceof AnnotatedMethod)) {
                return annotatedMember.getRawType().getName();
            }
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember;
            if (annotatedMethod.getParameterCount() == 0) {
                return annotatedMember.getRawType().getName();
            }
            return annotatedMethod.getRawParameterType(0).getName();
        }
        return string;
    }

    public TypeResolverBuilder findTypeResolver(MapperConfig mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return this._findTypeResolver(mapperConfig, annotatedClass, javaType);
    }

    public TypeResolverBuilder findPropertyTypeResolver(MapperConfig mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    public TypeResolverBuilder findPropertyContentTypeResolver(MapperConfig mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    public List findSubtypes(Annotated annotated) {
        JsonSubTypes jsonSubTypes = (JsonSubTypes)annotated.getAnnotation(JsonSubTypes.class);
        if (jsonSubTypes == null) {
            return null;
        }
        JsonSubTypes$Type[] jsonSubTypes$TypeArray = jsonSubTypes.value();
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(jsonSubTypes$TypeArray.length);
        for (JsonSubTypes$Type jsonSubTypes$Type : jsonSubTypes$TypeArray) {
            arrayList.add(new NamedType(jsonSubTypes$Type.value(), jsonSubTypes$Type.name()));
        }
        return arrayList;
    }

    public String findTypeName(AnnotatedClass annotatedClass) {
        JsonTypeName jsonTypeName = (JsonTypeName)annotatedClass.getAnnotation(JsonTypeName.class);
        return jsonTypeName == null ? null : jsonTypeName.value();
    }

    public Object findSerializer(Annotated annotated) {
        Object object;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (object = jsonSerialize.using()) != JsonSerializer$None.class) {
            return object;
        }
        object = (JsonRawValue)annotated.getAnnotation(JsonRawValue.class);
        if (object != null && object.value()) {
            Class clazz = annotated.getRawType();
            return new RawSerializer(clazz);
        }
        return null;
    }

    public Class findKeySerializer(Annotated annotated) {
        Class clazz;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyUsing()) != JsonSerializer$None.class) {
            return clazz;
        }
        return null;
    }

    public Class findContentSerializer(Annotated annotated) {
        Class clazz;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentUsing()) != JsonSerializer$None.class) {
            return clazz;
        }
        return null;
    }

    public JsonInclude$Include findSerializationInclusion(Annotated annotated, JsonInclude$Include jsonInclude$Include) {
        JsonInclude jsonInclude = (JsonInclude)annotated.getAnnotation(JsonInclude.class);
        if (jsonInclude != null) {
            return jsonInclude.value();
        }
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null) {
            JsonSerialize$Inclusion jsonSerialize$Inclusion = jsonSerialize.include();
            switch (jsonSerialize$Inclusion) {
                case ALWAYS: {
                    return JsonInclude$Include.ALWAYS;
                }
                case NON_NULL: {
                    return JsonInclude$Include.NON_NULL;
                }
                case NON_DEFAULT: {
                    return JsonInclude$Include.NON_DEFAULT;
                }
                case NON_EMPTY: {
                    return JsonInclude$Include.NON_EMPTY;
                }
            }
        }
        return jsonInclude$Include;
    }

    public Class findSerializationType(Annotated annotated) {
        Class clazz;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public Class findSerializationKeyType(Annotated annotated, JavaType javaType) {
        Class clazz;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public Class findSerializationContentType(Annotated annotated, JavaType javaType) {
        Class clazz;
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public JsonSerialize$Typing findSerializationTyping(Annotated annotated) {
        JsonSerialize jsonSerialize = (JsonSerialize)annotated.getAnnotation(JsonSerialize.class);
        return jsonSerialize == null ? null : jsonSerialize.typing();
    }

    public Class[] findViews(Annotated annotated) {
        JsonView jsonView = (JsonView)annotated.getAnnotation(JsonView.class);
        return jsonView == null ? null : jsonView.value();
    }

    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return annotatedMember.hasAnnotation(JsonTypeId.class);
    }

    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        JsonIdentityInfo jsonIdentityInfo = (JsonIdentityInfo)annotated.getAnnotation(JsonIdentityInfo.class);
        if (jsonIdentityInfo == null || jsonIdentityInfo.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        return new ObjectIdInfo(jsonIdentityInfo.property(), jsonIdentityInfo.scope(), jsonIdentityInfo.generator());
    }

    public JsonFormat$Value findFormat(AnnotatedMember annotatedMember) {
        JsonFormat jsonFormat = (JsonFormat)annotatedMember.getAnnotation(JsonFormat.class);
        return jsonFormat == null ? null : new JsonFormat$Value(jsonFormat);
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = (JsonPropertyOrder)annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : jsonPropertyOrder.value();
    }

    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = (JsonPropertyOrder)annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : Boolean.valueOf(jsonPropertyOrder.alphabetic());
    }

    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        JsonGetter jsonGetter = (JsonGetter)annotatedMethod.getAnnotation(JsonGetter.class);
        if (jsonGetter != null) {
            return jsonGetter.value();
        }
        JsonProperty jsonProperty = (JsonProperty)annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonSerialize.class) || annotatedMethod.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        JsonValue jsonValue = (JsonValue)annotatedMethod.getAnnotation(JsonValue.class);
        return jsonValue != null && jsonValue.value();
    }

    public String findSerializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = (JsonProperty)annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonSerialize.class) || annotatedField.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    public Class findDeserializer(Annotated annotated) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.using()) != JsonDeserializer$None.class) {
            return clazz;
        }
        return null;
    }

    public Class findKeyDeserializer(Annotated annotated) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyUsing()) != KeyDeserializer$None.class) {
            return clazz;
        }
        return null;
    }

    public Class findContentDeserializer(Annotated annotated) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentUsing()) != JsonDeserializer$None.class) {
            return clazz;
        }
        return null;
    }

    public Class findDeserializationType(Annotated annotated, JavaType javaType) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public Class findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public Class findDeserializationContentType(Annotated annotated, JavaType javaType) {
        Class clazz;
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        JsonValueInstantiator jsonValueInstantiator = (JsonValueInstantiator)annotatedClass.getAnnotation(JsonValueInstantiator.class);
        return jsonValueInstantiator == null ? null : jsonValueInstantiator.value();
    }

    public Class findPOJOBuilder(AnnotatedClass annotatedClass) {
        JsonDeserialize jsonDeserialize = (JsonDeserialize)annotatedClass.getAnnotation(JsonDeserialize.class);
        return jsonDeserialize == null || jsonDeserialize.builder() == NoClass.class ? null : jsonDeserialize.builder();
    }

    public JsonPOJOBuilder$Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        JsonPOJOBuilder jsonPOJOBuilder = (JsonPOJOBuilder)annotatedClass.getAnnotation(JsonPOJOBuilder.class);
        return jsonPOJOBuilder == null ? null : new JsonPOJOBuilder$Value(jsonPOJOBuilder);
    }

    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        JsonSetter jsonSetter = (JsonSetter)annotatedMethod.getAnnotation(JsonSetter.class);
        if (jsonSetter != null) {
            return jsonSetter.value();
        }
        JsonProperty jsonProperty = (JsonProperty)annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonDeserialize.class) || annotatedMethod.hasAnnotation(JsonView.class) || annotatedMethod.hasAnnotation(JsonBackReference.class) || annotatedMethod.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnySetter.class);
    }

    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnyGetter.class);
    }

    public boolean hasCreatorAnnotation(Annotated annotated) {
        return annotated.hasAnnotation(JsonCreator.class);
    }

    public String findDeserializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = (JsonProperty)annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonDeserialize.class) || annotatedField.hasAnnotation(JsonView.class) || annotatedField.hasAnnotation(JsonBackReference.class) || annotatedField.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    public String findDeserializationName(AnnotatedParameter annotatedParameter) {
        JsonProperty jsonProperty;
        if (annotatedParameter != null && (jsonProperty = (JsonProperty)annotatedParameter.getAnnotation(JsonProperty.class)) != null) {
            return jsonProperty.value();
        }
        return null;
    }

    protected boolean _isIgnorable(Annotated annotated) {
        JsonIgnore jsonIgnore = (JsonIgnore)annotated.getAnnotation(JsonIgnore.class);
        return jsonIgnore != null && jsonIgnore.value();
    }

    protected TypeResolverBuilder _findTypeResolver(MapperConfig mapperConfig, Annotated annotated, JavaType javaType) {
        TypeIdResolver typeIdResolver;
        TypeResolverBuilder typeResolverBuilder;
        JsonTypeInfo jsonTypeInfo = (JsonTypeInfo)annotated.getAnnotation(JsonTypeInfo.class);
        JsonTypeResolver jsonTypeResolver = (JsonTypeResolver)annotated.getAnnotation(JsonTypeResolver.class);
        if (jsonTypeResolver != null) {
            if (jsonTypeInfo == null) {
                return null;
            }
            typeResolverBuilder = mapperConfig.typeResolverBuilderInstance(annotated, jsonTypeResolver.value());
        } else {
            if (jsonTypeInfo == null) {
                return null;
            }
            if (jsonTypeInfo.use() == JsonTypeInfo$Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            typeResolverBuilder = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver jsonTypeIdResolver = (JsonTypeIdResolver)annotated.getAnnotation(JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver2 = typeIdResolver = jsonTypeIdResolver == null ? null : mapperConfig.typeIdResolverInstance(annotated, jsonTypeIdResolver.value());
        if (typeIdResolver != null) {
            typeIdResolver.init(javaType);
        }
        typeResolverBuilder = typeResolverBuilder.init(jsonTypeInfo.use(), typeIdResolver);
        JsonTypeInfo$As jsonTypeInfo$As = jsonTypeInfo.include();
        if (jsonTypeInfo$As == JsonTypeInfo$As.EXTERNAL_PROPERTY && annotated instanceof AnnotatedClass) {
            jsonTypeInfo$As = JsonTypeInfo$As.PROPERTY;
        }
        typeResolverBuilder = typeResolverBuilder.inclusion(jsonTypeInfo$As);
        typeResolverBuilder = typeResolverBuilder.typeProperty(jsonTypeInfo.property());
        Class clazz = jsonTypeInfo.defaultImpl();
        if (clazz != JsonTypeInfo.None.class) {
            typeResolverBuilder = typeResolverBuilder.defaultImpl(clazz);
        }
        typeResolverBuilder = typeResolverBuilder.typeIdVisibility(jsonTypeInfo.visible());
        return typeResolverBuilder;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

