/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer {
    public ClassDeserializer() {
        super(Class.class);
    }

    public Class deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                return deserializationContext.findClass(string);
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._valueClass, ClassUtil.getRootCause(exception));
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

