/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.BeanProperty$Std;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler$Builder;
import com.fasterxml.jackson.databind.deser.impl.InnerClassProperty;
import com.fasterxml.jackson.databind.deser.impl.ManagedReferenceProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BeanDeserializerBase
extends StdDeserializer
implements ContextualDeserializer,
ResolvableDeserializer {
    protected final Annotations _classAnnotations;
    protected final JavaType _beanType;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected boolean _nonStandardCreation;
    protected boolean _vanillaProcessing;
    protected final BeanPropertyMap _beanProperties;
    protected final ValueInjector[] _injectables;
    protected SettableAnyProperty _anySetter;
    protected final HashSet _ignorableProps;
    protected final boolean _ignoreAllUnknown;
    protected final boolean _needViewProcesing;
    protected final Map _backRefs;
    protected HashMap _subDeserializers;
    protected UnwrappedPropertyHandler _unwrappedPropertyHandler;
    protected ExternalTypeHandler _externalTypeIdHandler;
    protected final ObjectIdReader _objectIdReader;

    protected BeanDeserializerBase(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map map, HashSet hashSet, boolean bl, boolean bl2) {
        super(beanDescription.getType());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        this._classAnnotations = annotatedClass.getAnnotations();
        this._beanType = beanDescription.getType();
        this._valueInstantiator = beanDeserializerBuilder.getValueInstantiator();
        this._beanProperties = beanPropertyMap;
        this._backRefs = map;
        this._ignorableProps = hashSet;
        this._ignoreAllUnknown = bl;
        this._anySetter = beanDeserializerBuilder.getAnySetter();
        List list = beanDeserializerBuilder.getInjectables();
        this._injectables = list == null || list.isEmpty() ? null : list.toArray(new ValueInjector[list.size()]);
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._nonStandardCreation = this._unwrappedPropertyHandler != null || this._valueInstantiator.canCreateUsingDelegate() || this._valueInstantiator.canCreateFromObjectWith() || !this._valueInstantiator.canCreateUsingDefault();
        this._needViewProcesing = bl2;
        this._vanillaProcessing = !this._nonStandardCreation && this._injectables == null && !this._needViewProcesing && this._objectIdReader != null;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase) {
        this(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanDeserializerBase._beanProperties;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = bl;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = nameTransformer != null || beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        if (nameTransformer != null) {
            if (this._unwrappedPropertyHandler != null) {
                this._unwrappedPropertyHandler.renameAll(nameTransformer);
            }
            this._beanProperties = beanDeserializerBase._beanProperties.renameAll(nameTransformer);
        } else {
            this._beanProperties = beanDeserializerBase._beanProperties;
        }
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._vanillaProcessing = false;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, ObjectIdReader objectIdReader) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = objectIdReader;
        this._beanProperties = objectIdReader == null ? beanDeserializerBase._beanProperties : beanDeserializerBase._beanProperties.withProperty(new ObjectIdValueProperty(objectIdReader));
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, HashSet hashSet) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = hashSet;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._beanProperties = beanDeserializerBase._beanProperties;
    }

    public abstract JsonDeserializer unwrappingDeserializer(NameTransformer var1);

    public abstract BeanDeserializerBase withObjectIdReader(ObjectIdReader var1);

    public abstract BeanDeserializerBase withIgnorableProperties(HashSet var1);

    public void resolve(DeserializationContext deserializationContext) {
        Object object;
        Object object2;
        ExternalTypeHandler$Builder externalTypeHandler$Builder = null;
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object2 = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object2);
            for (Object object3 : this._propertyBasedCreator.properties()) {
                if (!((SettableBeanProperty)object3).hasValueTypeDeserializer() || ((TypeDeserializer)(object = ((SettableBeanProperty)object3).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo$As.EXTERNAL_PROPERTY) continue;
                if (externalTypeHandler$Builder == null) {
                    externalTypeHandler$Builder = new ExternalTypeHandler$Builder();
                }
                externalTypeHandler$Builder.addExternal((SettableBeanProperty)object3, ((TypeDeserializer)object).getPropertyName());
            }
        }
        object2 = null;
        for (Object object3 : this._beanProperties) {
            Object object4;
            Object object5;
            object = object3;
            if (!((SettableBeanProperty)object).hasValueDeserializer()) {
                object = ((SettableBeanProperty)object).withValueDeserializer(this.findDeserializer(deserializationContext, ((SettableBeanProperty)object).getType(), (BeanProperty)object));
            } else {
                object5 = ((SettableBeanProperty)object).getValueDeserializer();
                if (object5 instanceof ContextualDeserializer && (object4 = ((ContextualDeserializer)object5).createContextual(deserializationContext, (BeanProperty)object)) != object5) {
                    object = ((SettableBeanProperty)object).withValueDeserializer((JsonDeserializer)object4);
                }
            }
            object = this._resolveManagedReferenceProperty(deserializationContext, (SettableBeanProperty)object);
            object5 = this._resolveUnwrappedProperty(deserializationContext, (SettableBeanProperty)object);
            if (object5 != null) {
                object = object5;
                if (object2 == null) {
                    object2 = new UnwrappedPropertyHandler();
                }
                object2.addProperty((SettableBeanProperty)object);
                continue;
            }
            if ((object = this._resolveInnerClassValuedProperty(deserializationContext, (SettableBeanProperty)object)) != object3) {
                this._beanProperties.replace((SettableBeanProperty)object);
            }
            if (!((SettableBeanProperty)object).hasValueTypeDeserializer() || ((TypeDeserializer)(object4 = ((SettableBeanProperty)object).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo$As.EXTERNAL_PROPERTY) continue;
            if (externalTypeHandler$Builder == null) {
                externalTypeHandler$Builder = new ExternalTypeHandler$Builder();
            }
            externalTypeHandler$Builder.addExternal((SettableBeanProperty)object, ((TypeDeserializer)object4).getPropertyName());
            this._beanProperties.remove((SettableBeanProperty)object);
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            this._anySetter = this._anySetter.withValueDeserializer(this.findDeserializer(deserializationContext, this._anySetter.getType(), this._anySetter.getProperty()));
        }
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            Object object3;
            JavaType javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (javaType == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._beanType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            object3 = this._valueInstantiator.getDelegateCreator();
            object = new BeanProperty$Std(null, javaType, this._classAnnotations, (AnnotatedMember)object3);
            this._delegateDeserializer = this.findDeserializer(deserializationContext, javaType, (BeanProperty)object);
        }
        if (externalTypeHandler$Builder != null) {
            this._externalTypeIdHandler = externalTypeHandler$Builder.build();
            this._nonStandardCreation = true;
        }
        this._unwrappedPropertyHandler = object2;
        if (object2 != null) {
            this._nonStandardCreation = true;
        }
        this._vanillaProcessing = this._vanillaProcessing && !this._nonStandardCreation;
    }

    public JsonDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Object object;
        Object object2;
        ObjectIdReader objectIdReader = this._objectIdReader;
        Object[] objectArray = null;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (beanProperty != null && annotationIntrospector != null) {
            object2 = beanProperty.getMember();
            objectArray = annotationIntrospector.findPropertiesToIgnore((Annotated)object2);
            object = annotationIntrospector.findObjectIdInfo((Annotated)object2);
            if (object != null) {
                ObjectIdGenerator objectIdGenerator;
                JavaType javaType;
                SettableBeanProperty settableBeanProperty;
                Object object3;
                Class clazz = ((ObjectIdInfo)object).getGeneratorType();
                if (clazz == ObjectIdGenerators$PropertyGenerator.class) {
                    object3 = ((ObjectIdInfo)object).getPropertyName();
                    settableBeanProperty = this.findProperty((String)object3);
                    if (settableBeanProperty == null) {
                        throw new IllegalArgumentException("Invalid Object Id definition for " + this.getBeanClass().getName() + ": can not find property with name '" + (String)object3 + "'");
                    }
                    javaType = settableBeanProperty.getType();
                    objectIdGenerator = new PropertyBasedObjectIdGenerator(((ObjectIdInfo)object).getScope());
                } else {
                    object3 = deserializationContext.constructType(clazz);
                    javaType = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object3, ObjectIdGenerator.class)[0];
                    settableBeanProperty = null;
                    objectIdGenerator = deserializationContext.objectIdGeneratorInstance((Annotated)object2, (ObjectIdInfo)object);
                }
                object3 = deserializationContext.findRootValueDeserializer(javaType);
                objectIdReader = ObjectIdReader.construct(javaType, ((ObjectIdInfo)object).getPropertyName(), objectIdGenerator, (JsonDeserializer)object3, settableBeanProperty);
            }
        }
        object2 = this;
        if (objectIdReader != null && objectIdReader != this._objectIdReader) {
            object2 = ((BeanDeserializerBase)object2).withObjectIdReader(objectIdReader);
        }
        if (objectArray != null && objectArray.length != 0) {
            object = ArrayBuilders.setAndArray(((BeanDeserializerBase)object2)._ignorableProps, objectArray);
            object2 = ((BeanDeserializerBase)object2).withIgnorableProperties((HashSet)object);
        }
        return object2;
    }

    protected SettableBeanProperty _resolveManagedReferenceProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Object object;
        String string = settableBeanProperty.getManagedReferenceName();
        if (string == null) {
            return settableBeanProperty;
        }
        JsonDeserializer jsonDeserializer = settableBeanProperty.getValueDeserializer();
        SettableBeanProperty settableBeanProperty2 = null;
        boolean bl = false;
        if (jsonDeserializer instanceof BeanDeserializerBase) {
            settableBeanProperty2 = ((BeanDeserializerBase)jsonDeserializer).findBackReference(string);
        } else if (jsonDeserializer instanceof ContainerDeserializerBase) {
            object = ((ContainerDeserializerBase)jsonDeserializer).getContentDeserializer();
            if (!(object instanceof BeanDeserializerBase)) {
                String string2 = object == null ? "NULL" : object.getClass().getName();
                throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': value deserializer is of type ContainerDeserializerBase, but content type is not handled by a BeanDeserializer " + " (instead it's of type " + string2 + ")");
            }
            settableBeanProperty2 = ((BeanDeserializerBase)object).findBackReference(string);
            bl = true;
        } else if (jsonDeserializer instanceof AbstractDeserializer) {
            settableBeanProperty2 = ((AbstractDeserializer)jsonDeserializer).findBackReference(string);
        } else {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': type for value deserializer is not BeanDeserializer or ContainerDeserializerBase, but " + jsonDeserializer.getClass().getName());
        }
        if (settableBeanProperty2 == null) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': no back reference property found from type " + settableBeanProperty.getType());
        }
        object = this._beanType;
        JavaType javaType = settableBeanProperty2.getType();
        if (!javaType.getRawClass().isAssignableFrom(((JavaType)object).getRawClass())) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': back reference type (" + javaType.getRawClass().getName() + ") not compatible with managed type (" + ((JavaType)object).getRawClass().getName() + ")");
        }
        return new ManagedReferenceProperty(settableBeanProperty, string, settableBeanProperty2, this._classAnnotations, bl);
    }

    protected SettableBeanProperty _resolveUnwrappedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        JsonDeserializer jsonDeserializer;
        JsonDeserializer jsonDeserializer2;
        NameTransformer nameTransformer;
        AnnotatedMember annotatedMember = settableBeanProperty.getMember();
        if (annotatedMember != null && (nameTransformer = deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedMember)) != null && (jsonDeserializer2 = (jsonDeserializer = settableBeanProperty.getValueDeserializer()).unwrappingDeserializer(nameTransformer)) != jsonDeserializer && jsonDeserializer2 != null) {
            return settableBeanProperty.withValueDeserializer(jsonDeserializer2);
        }
        return null;
    }

    protected SettableBeanProperty _resolveInnerClassValuedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Class clazz;
        Class clazz2;
        BeanDeserializerBase beanDeserializerBase;
        ValueInstantiator valueInstantiator;
        JsonDeserializer jsonDeserializer = settableBeanProperty.getValueDeserializer();
        if (jsonDeserializer instanceof BeanDeserializerBase && !(valueInstantiator = (beanDeserializerBase = (BeanDeserializerBase)jsonDeserializer).getValueInstantiator()).canCreateUsingDefault() && (clazz2 = ClassUtil.getOuterClass(clazz = settableBeanProperty.getType().getRawClass())) != null && clazz2 == this._beanType.getRawClass()) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 1 || classArray[0] != clazz2) continue;
                if (deserializationContext.getConfig().canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(constructor);
                }
                return new InnerClassProperty(settableBeanProperty, constructor);
            }
        }
        return settableBeanProperty;
    }

    public boolean isCachable() {
        return true;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public boolean hasProperty(String string) {
        return this._beanProperties.find(string) != null;
    }

    public boolean hasViews() {
        return this._needViewProcesing;
    }

    public int getPropertyCount() {
        return this._beanProperties.size();
    }

    public Collection getKnownPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            arrayList.add(settableBeanProperty.getName());
        }
        return arrayList;
    }

    public final Class getBeanClass() {
        return this._beanType.getRawClass();
    }

    public JavaType getValueType() {
        return this._beanType;
    }

    public Iterator properties() {
        if (this._beanProperties == null) {
            throw new IllegalStateException("Can only call after BeanDeserializer has been resolved");
        }
        return this._beanProperties.iterator();
    }

    public Iterator creatorProperties() {
        if (this._propertyBasedCreator == null) {
            return Collections.emptyList().iterator();
        }
        return this._propertyBasedCreator.properties().iterator();
    }

    public SettableBeanProperty findProperty(String string) {
        SettableBeanProperty settableBeanProperty;
        SettableBeanProperty settableBeanProperty2 = settableBeanProperty = this._beanProperties == null ? null : this._beanProperties.find(string);
        if (settableBeanProperty == null && this._propertyBasedCreator != null) {
            settableBeanProperty = this._propertyBasedCreator.findCreatorProperty(string);
        }
        return settableBeanProperty;
    }

    public SettableBeanProperty findBackReference(String string) {
        if (this._backRefs == null) {
            return null;
        }
        return (SettableBeanProperty)this._backRefs.get(string);
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        JsonToken jsonToken;
        if (this._objectIdReader != null && (jsonToken = jsonParser.getCurrentToken()) != null && jsonToken.isScalarValue()) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    protected Object deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object = this._objectIdReader.deserializer.deserialize(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator);
        Object object2 = readableObjectId.item;
        if (object2 == null) {
            throw new IllegalStateException("Could not resolve Object Id [" + object + "] -- unresolved forward-reference?");
        }
        return object2;
    }

    protected void injectValues(DeserializationContext deserializationContext, Object object) {
        for (ValueInjector valueInjector : this._injectables) {
            valueInjector.inject(deserializationContext, object);
        }
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (this._ignoreAllUnknown || this._ignorableProps != null && this._ignorableProps.contains(string)) {
            jsonParser.skipChildren();
            return;
        }
        super.handleUnknownProperty(jsonParser, deserializationContext, object, string);
    }

    protected Object handleUnknownProperties(DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) {
        tokenBuffer.writeEndObject();
        JsonParser jsonParser = tokenBuffer.asParser();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer _findSubclassDeserializer(DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) {
        JsonDeserializer jsonDeserializer;
        Object object2 = this;
        synchronized (object2) {
            jsonDeserializer = this._subDeserializers == null ? null : (JsonDeserializer)this._subDeserializers.get(new ClassKey(object.getClass()));
        }
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        object2 = deserializationContext.constructType(object.getClass());
        jsonDeserializer = deserializationContext.findRootValueDeserializer((JavaType)object2);
        if (jsonDeserializer != null) {
            BeanDeserializerBase beanDeserializerBase = this;
            synchronized (beanDeserializerBase) {
                if (this._subDeserializers == null) {
                    this._subDeserializers = new HashMap();
                }
                this._subDeserializers.put(new ClassKey(object.getClass()), jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(Throwable throwable, Object object, int n2, DeserializationContext deserializationContext) {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n2);
    }

    protected void wrapInstantiationProblem(Throwable throwable, DeserializationContext deserializationContext) {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw deserializationContext.instantiationException(this._beanType.getRawClass(), throwable);
    }
}

