/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.json.CoreVersion;
import com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.fasterxml.jackson.core.json.WriterBasedJsonGenerator;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;

public class JsonFactory
implements Versioned {
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory$Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser$Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator$Feature.collectDefaults();
    protected static final ThreadLocal _recyclerRef = new ThreadLocal();
    protected CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected CharacterEscapes _characterEscapes;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    protected MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        return ByteSourceJsonBootstrapper.hasJSONFormat(inputAccessor);
    }

    public Version version() {
        return CoreVersion.instance.version();
    }

    public final JsonFactory configure(JsonFactory$Feature jsonFactory$Feature, boolean bl) {
        return bl ? this.enable(jsonFactory$Feature) : this.disable(jsonFactory$Feature);
    }

    public JsonFactory enable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures |= jsonFactory$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures &= ~jsonFactory$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return (this._factoryFeatures & jsonFactory$Feature.getMask()) != 0;
    }

    public final JsonFactory configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        return bl ? this.enable(jsonParser$Feature) : this.disable(jsonParser$Feature);
    }

    public JsonFactory enable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures |= jsonParser$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures &= ~jsonParser$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return (this._parserFeatures & jsonParser$Feature.getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        return bl ? this.enable(jsonGenerator$Feature) : this.disable(jsonGenerator$Feature);
    }

    public JsonFactory enable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures |= jsonGenerator$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures &= ~jsonGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return (this._generatorFeatures & jsonGenerator$Feature.getMask()) != 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createJsonParser(File file) {
        IOContext iOContext = this._createContext(file, true);
        InputStream inputStream = new FileInputStream(file);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(URL uRL) {
        IOContext iOContext = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(InputStream inputStream) {
        IOContext iOContext = this._createContext(inputStream, false);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(Reader reader) {
        IOContext iOContext = this._createContext(reader, false);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createJsonParser(reader, iOContext);
    }

    public JsonParser createJsonParser(byte[] byArray) {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createJsonParser(inputStream, iOContext);
        }
        return this._createJsonParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createJsonParser(byte[] byArray, int n2, int n3) {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createJsonParser(inputStream, iOContext);
        }
        return this._createJsonParser(byArray, n2, n3, iOContext);
    }

    public JsonParser createJsonParser(String string) {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(reader, true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createJsonParser(reader, iOContext);
    }

    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        IOContext iOContext = this._createContext(outputStream, false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(iOContext, outputStream);
            }
            return this._createUTF8JsonGenerator(outputStream, iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    public JsonGenerator createJsonGenerator(Writer writer) {
        IOContext iOContext = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    public JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.createJsonGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) {
        OutputStream outputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(outputStream, true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(iOContext, outputStream);
            }
            return this._createUTF8JsonGenerator(outputStream, iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    protected JsonParser _createJsonParser(InputStream inputStream, IOContext iOContext) {
        return new ByteSourceJsonBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols, this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES));
    }

    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES)));
    }

    protected JsonParser _createJsonParser(byte[] byArray, int n2, int n3, IOContext iOContext) {
        return new ByteSourceJsonBootstrapper(iOContext, byArray, n2, n3).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols, this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES));
    }

    protected JsonGenerator _createJsonGenerator(Writer writer, IOContext iOContext) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = new WriterBasedJsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer);
        if (this._characterEscapes != null) {
            writerBasedJsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        return writerBasedJsonGenerator;
    }

    protected JsonGenerator _createUTF8JsonGenerator(OutputStream outputStream, IOContext iOContext) {
        UTF8JsonGenerator uTF8JsonGenerator = new UTF8JsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, outputStream);
        if (this._characterEscapes != null) {
            uTF8JsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        return uTF8JsonGenerator;
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected IOContext _createContext(Object object, boolean bl) {
        return new IOContext(this._getBufferRecycler(), object, bl);
    }

    public BufferRecycler _getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference softReference = (SoftReference)_recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : (BufferRecycler)softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }
}

