/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.text.DateFormat;
import java.util.Date;

@JacksonStdImpl
public class DateSerializer
extends DateTimeSerializerBase {
    public static DateSerializer instance = new DateSerializer();

    public DateSerializer() {
        this(false, null);
    }

    public DateSerializer(boolean bl, DateFormat dateFormat) {
        super(Date.class, bl, dateFormat);
    }

    public DateSerializer withFormat(boolean bl, DateFormat dateFormat) {
        if (bl) {
            return new DateSerializer(true, null);
        }
        return new DateSerializer(false, dateFormat);
    }

    protected long _timestamp(Date date) {
        return date == null ? 0L : date.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._useTimestamp) {
            jsonGenerator.writeNumber(this._timestamp(date));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jsonGenerator.writeString(this._customFormat.format(date));
            }
        } else {
            serializerProvider.defaultSerializeDateValue(date, jsonGenerator);
        }
    }
}

