/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonMappingException$Reference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class BeanSerializerBase
extends StdSerializer
implements SchemaAware,
ContextualSerializer,
ResolvableSerializer {
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final AnyGetterWriter _anyGetterWriter;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;

    public BeanSerializerBase(JavaType javaType, BeanSerializerBuilder beanSerializerBuilder, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(javaType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        if (beanSerializerBuilder == null) {
            this._typeId = null;
            this._anyGetterWriter = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
        } else {
            this._typeId = beanSerializerBuilder.getTypeId();
            this._anyGetterWriter = beanSerializerBuilder.getAnyGetter();
            this._propertyFilterId = beanSerializerBuilder.getFilterId();
            this._objectIdWriter = beanSerializerBuilder.getObjectIdWriter();
        }
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(beanSerializerBase._handledType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter) {
        super(beanSerializerBase._handledType);
        this._props = beanSerializerBase._props;
        this._filteredProps = beanSerializerBase._filteredProps;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        super(beanSerializerBase._handledType);
        HashSet hashSet = ArrayBuilders.arrayToSet(stringArray);
        BeanPropertyWriter[] beanPropertyWriterArray = beanSerializerBase._props;
        BeanPropertyWriter[] beanPropertyWriterArray2 = beanSerializerBase._filteredProps;
        int n2 = beanPropertyWriterArray.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n2);
        ArrayList<BeanPropertyWriter> arrayList2 = beanPropertyWriterArray2 == null ? null : new ArrayList<BeanPropertyWriter>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i2];
            if (hashSet.contains(beanPropertyWriter.getName())) continue;
            arrayList.add(beanPropertyWriter);
            if (beanPropertyWriterArray2 == null) continue;
            arrayList2.add(beanPropertyWriterArray2[i2]);
        }
        this._props = arrayList.toArray(new BeanPropertyWriter[arrayList.size()]);
        this._filteredProps = arrayList2 == null ? null : arrayList2.toArray(new BeanPropertyWriter[arrayList2.size()]);
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withIgnorals(String[] var1);

    protected abstract BeanSerializerBase asArraySerializer();

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase) {
        this(beanSerializerBase, beanSerializerBase._props, beanSerializerBase._filteredProps);
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, NameTransformer nameTransformer) {
        this(beanSerializerBase, BeanSerializerBase.rename(beanSerializerBase._props, nameTransformer), BeanSerializerBase.rename(beanSerializerBase._filteredProps, nameTransformer));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] beanPropertyWriterArray, NameTransformer nameTransformer) {
        if (beanPropertyWriterArray == null || beanPropertyWriterArray.length == 0 || nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return beanPropertyWriterArray;
        }
        int n2 = beanPropertyWriterArray.length;
        BeanPropertyWriter[] beanPropertyWriterArray2 = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i2];
            if (beanPropertyWriter == null) continue;
            beanPropertyWriterArray2[i2] = beanPropertyWriter.rename(nameTransformer);
        }
        return beanPropertyWriterArray2;
    }

    public void resolve(SerializerProvider serializerProvider) {
        int n2 = this._filteredProps == null ? 0 : this._filteredProps.length;
        int n3 = this._props.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            Object object2;
            Object object3;
            BeanPropertyWriter beanPropertyWriter = this._props[i2];
            if (!beanPropertyWriter.willSuppressNulls() && !beanPropertyWriter.hasNullSerializer() && (object3 = serializerProvider.findNullValueSerializer(beanPropertyWriter)) != null) {
                beanPropertyWriter.assignNullSerializer((JsonSerializer)object3);
                if (i2 < n2 && (object2 = this._filteredProps[i2]) != null) {
                    ((BeanPropertyWriter)object2).assignNullSerializer((JsonSerializer)object3);
                }
            }
            if (beanPropertyWriter.hasSerializer()) continue;
            object3 = beanPropertyWriter.getSerializationType();
            if (object3 == null && !((JavaType)(object3 = serializerProvider.constructType(beanPropertyWriter.getGenericPropertyType()))).isFinal()) {
                if (!((JavaType)object3).isContainerType() && ((JavaType)object3).containedTypeCount() <= 0) continue;
                beanPropertyWriter.setNonTrivialBaseType((JavaType)object3);
                continue;
            }
            object2 = serializerProvider.findValueSerializer((JavaType)object3, (BeanProperty)beanPropertyWriter);
            if (((JavaType)object3).isContainerType() && (object = (TypeSerializer)((JavaType)object3).getContentType().getTypeHandler()) != null && object2 instanceof ContainerSerializer) {
                ContainerSerializer containerSerializer = ((ContainerSerializer)object2).withValueTypeSerializer((TypeSerializer)object);
                object2 = containerSerializer;
            }
            beanPropertyWriter.assignSerializer((JsonSerializer)object2);
            if (i2 >= n2 || (object = this._filteredProps[i2]) == null) continue;
            ((BeanPropertyWriter)object).assignSerializer((JsonSerializer)object2);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(serializerProvider);
        }
    }

    public JsonSerializer createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        Object object2;
        AnnotatedMember annotatedMember;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        String[] stringArray = null;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        if (beanProperty != null && annotationIntrospector != null) {
            stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedMember);
            object2 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object2 != null) {
                Class clazz = ((ObjectIdInfo)object2).getGeneratorType();
                JavaType javaType = serializerProvider.constructType(clazz);
                JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
                if (clazz == ObjectIdGenerators$PropertyGenerator.class) {
                    String string = ((ObjectIdInfo)object2).getPropertyName();
                    BeanPropertyWriter beanPropertyWriter = null;
                    int n2 = 0;
                    int n3 = this._props.length;
                    while (true) {
                        if (n2 == n3) {
                            throw new IllegalArgumentException("Invalid Object Id definition for " + this._handledType.getName() + ": can not find property with name '" + string + "'");
                        }
                        BeanPropertyWriter beanPropertyWriter2 = this._props[n2];
                        if (string.equals(beanPropertyWriter2.getName())) {
                            beanPropertyWriter = beanPropertyWriter2;
                            if (n2 <= 0) break;
                            System.arraycopy(this._props, 0, this._props, 1, n2);
                            this._props[0] = beanPropertyWriter;
                            if (this._filteredProps == null) break;
                            BeanPropertyWriter beanPropertyWriter3 = this._filteredProps[n2];
                            System.arraycopy(this._filteredProps, 0, this._filteredProps, 1, n2);
                            this._filteredProps[0] = beanPropertyWriter3;
                            break;
                        }
                        ++n2;
                    }
                    javaType2 = beanPropertyWriter.getType();
                    object = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object2, beanPropertyWriter);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, null, (ObjectIdGenerator)object);
                } else {
                    object = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object2);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, ((ObjectIdInfo)object2).getPropertyName(), (ObjectIdGenerator)object);
                }
            }
        }
        object2 = this;
        if (objectIdWriter != null && (objectIdWriter = objectIdWriter.withSerializer((JsonSerializer)(object = serializerProvider.findValueSerializer(objectIdWriter.idType, beanProperty)))) != this._objectIdWriter) {
            object2 = ((BeanSerializerBase)object2).withObjectIdWriter(objectIdWriter);
        }
        if (stringArray != null && stringArray.length != 0) {
            object2 = ((BeanSerializerBase)object2).withIgnorals(stringArray);
        }
        if (annotatedMember != null && (object = annotationIntrospector.findFormat(annotatedMember)) != null && ((JsonFormat$Value)object).getShape() == JsonFormat$Shape.ARRAY) {
            object2 = ((BeanSerializerBase)object2).asArraySerializer();
        }
        return object2;
    }

    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3);

    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        String string;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    private final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        String string;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        Object object2 = writableObjectId.id;
        if (object2 != null) {
            writableObjectId.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        writableObjectId.serializer = objectIdWriter.serializer;
        writableObjectId.id = object2 = writableObjectId.generator.generateId(object);
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        SerializedString serializedString = objectIdWriter.propertyName;
        if (serializedString != null) {
            jsonGenerator.writeFieldName(serializedString);
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
        }
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    private final String _customTypeId(Object object) {
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            return "";
        }
        return object2 instanceof String ? (String)object2 : object2.toString();
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            jsonMappingException.prependPath(new JsonMappingException$Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        BeanPropertyFilter beanPropertyFilter = this.findFilter(serializerProvider);
        if (beanPropertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            jsonMappingException.prependPath(new JsonMappingException$Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected BeanPropertyFilter findFilter(SerializerProvider serializerProvider) {
        Object object = this._propertyFilterId;
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            throw new JsonMappingException("Can not resolve BeanPropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        BeanPropertyFilter beanPropertyFilter = filterProvider.findFilter(object);
        return beanPropertyFilter;
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        Object object;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        JsonSerializableSchema jsonSerializableSchema = this._handledType.getAnnotation(JsonSerializableSchema.class);
        if (jsonSerializableSchema != null && (object = jsonSerializableSchema.id()) != null && ((String)object).length() > 0) {
            objectNode.put("id", (String)object);
        }
        object = objectNode.objectNode();
        for (int i2 = 0; i2 < this._props.length; ++i2) {
            Object object2;
            BeanPropertyWriter beanPropertyWriter = this._props[i2];
            JavaType javaType = beanPropertyWriter.getSerializationType();
            Type type2 = javaType == null ? beanPropertyWriter.getGenericPropertyType() : javaType.getRawClass();
            JsonSerializer jsonSerializer = beanPropertyWriter.getSerializer();
            if (jsonSerializer == null) {
                object2 = beanPropertyWriter.getRawSerializationType();
                if (object2 == null) {
                    object2 = beanPropertyWriter.getPropertyType();
                }
                jsonSerializer = serializerProvider.findValueSerializer((Class)object2, (BeanProperty)beanPropertyWriter);
            }
            object2 = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, type2) : JsonSchema.getDefaultSchemaNode();
            ((ObjectNode)object).put(beanPropertyWriter.getName(), (JsonNode)object2);
        }
        objectNode.put("properties", (JsonNode)object);
        return objectNode;
    }
}

