/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.util.List;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase {
    public IndexedListSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer jsonSerializer) {
        super(List.class, javaType, bl, typeSerializer, beanProperty, jsonSerializer);
    }

    public IndexedListSerializer(IndexedListSerializer indexedListSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        super(indexedListSerializer, beanProperty, typeSerializer, jsonSerializer);
    }

    public IndexedListSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return new IndexedListSerializer(this, beanProperty, typeSerializer, jsonSerializer);
    }

    public boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public boolean hasSingleElement(List list) {
        return list.size() == 1;
    }

    public ContainerSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new IndexedListSerializer(this._elementType, this._staticTyping, typeSerializer, this._property, this._elementSerializer);
    }

    public void serializeContents(List list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(list, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(list, jsonGenerator, serializerProvider);
            return;
        }
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n2 = 0; n2 < n3; ++n2) {
                Object e2 = list.get(n2);
                if (e2 == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = e2.getClass();
                JsonSerializer jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicSerializers;
                }
                jsonSerializer.serialize(e2, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)list, n2);
        }
    }

    public void serializeContentsUsing(List list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer jsonSerializer) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = list.get(i2);
            try {
                if (e2 == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                if (typeSerializer == null) {
                    jsonSerializer.serialize(e2, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
                continue;
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)list, i2);
            }
        }
    }

    public void serializeTypedContents(List list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        try {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n2 = 0; n2 < n3; ++n2) {
                Object e2 = list.get(n2);
                if (e2 == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = e2.getClass();
                JsonSerializer jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicSerializers;
                }
                jsonSerializer.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)list, n2);
        }
    }
}

