/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonMappingException$Reference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase) {
        super(beanSerializerBase, (ObjectIdWriter)null);
        this._defaultSerializer = beanSerializerBase;
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        super(beanSerializerBase, stringArray);
        this._defaultSerializer = beanSerializerBase;
    }

    public JsonSerializer unwrappingSerializer(NameTransformer nameTransformer) {
        return this._defaultSerializer.unwrappingSerializer(nameTransformer);
    }

    public boolean isUnwrappingSerializer() {
        return false;
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    protected BeanAsArraySerializer withIgnorals(String[] stringArray) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, stringArray);
    }

    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        this._defaultSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartArray();
        this.serializeAsArray(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    protected final void serializeAsArray(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) {
                    jsonGenerator.writeNull();
                    continue;
                }
                beanPropertyWriter.serializeAsColumn(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            jsonMappingException.prependPath(new JsonMappingException$Reference(object, string));
            throw jsonMappingException;
        }
    }

    public String toString() {
        return "BeanAsArraySerializer for " + this.handledType().getName();
    }
}

