/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$BooleanBuilder;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$BooleanDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$BooleanDeser() {
        super(boolean[].class);
    }

    public boolean[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$BooleanBuilder arrayBuilders$BooleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
        boolean[] blArray = (boolean[])arrayBuilders$BooleanBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            boolean bl = this._parseBooleanPrimitive(jsonParser, deserializationContext);
            if (n2 >= blArray.length) {
                blArray = (boolean[])arrayBuilders$BooleanBuilder.appendCompletedChunk(blArray, n2);
                n2 = 0;
            }
            blArray[n2++] = bl;
        }
        return (boolean[])arrayBuilders$BooleanBuilder.completeAndClearBuffer(blArray, n2);
    }

    private final boolean[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new boolean[]{this._parseBooleanPrimitive(jsonParser, deserializationContext)};
    }
}

