/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UriBuilder {
    protected UriBuilder() {
    }

    protected static UriBuilder newInstance() {
        UriBuilder uriBuilder = RuntimeDelegate.getInstance().createUriBuilder();
        return uriBuilder;
    }

    public static UriBuilder fromUri(URI uRI) {
        UriBuilder uriBuilder = UriBuilder.newInstance();
        uriBuilder.uri(uRI);
        return uriBuilder;
    }

    public static UriBuilder fromUri(String string) {
        URI uRI;
        try {
            uRI = URI.create(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException(nullPointerException.getMessage(), nullPointerException);
        }
        return UriBuilder.fromUri(uRI);
    }

    public static UriBuilder fromPath(String string) {
        UriBuilder uriBuilder = UriBuilder.newInstance();
        uriBuilder.path(string);
        return uriBuilder;
    }

    public static UriBuilder fromResource(Class<?> clazz) {
        UriBuilder uriBuilder = UriBuilder.newInstance();
        uriBuilder.path(clazz);
        return uriBuilder;
    }

    public abstract UriBuilder clone();

    public abstract UriBuilder uri(URI var1);

    public abstract UriBuilder scheme(String var1);

    public abstract UriBuilder schemeSpecificPart(String var1);

    public abstract UriBuilder userInfo(String var1);

    public abstract UriBuilder host(String var1);

    public abstract UriBuilder port(int var1);

    public abstract UriBuilder replacePath(String var1);

    public abstract UriBuilder path(String var1);

    public abstract UriBuilder path(Class var1);

    public abstract UriBuilder path(Class var1, String var2);

    public abstract UriBuilder path(Method var1);

    public abstract UriBuilder segment(String ... var1);

    public abstract UriBuilder replaceMatrix(String var1);

    public abstract UriBuilder matrixParam(String var1, Object ... var2);

    public abstract UriBuilder replaceMatrixParam(String var1, Object ... var2);

    public abstract UriBuilder replaceQuery(String var1);

    public abstract UriBuilder queryParam(String var1, Object ... var2);

    public abstract UriBuilder replaceQueryParam(String var1, Object ... var2);

    public abstract UriBuilder fragment(String var1);

    public abstract URI buildFromMap(Map<String, ? extends Object> var1);

    public abstract URI buildFromEncodedMap(Map<String, ? extends Object> var1);

    public abstract URI build(Object ... var1);

    public abstract URI buildFromEncoded(Object ... var1);
}

