/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response$ResponseBuilder;
import javax.ws.rs.core.Response$Status;
import javax.ws.rs.core.Response$StatusType;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    protected Response() {
    }

    public abstract Object getEntity();

    public abstract int getStatus();

    public abstract MultivaluedMap<String, Object> getMetadata();

    public static Response$ResponseBuilder fromResponse(Response response) {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(response.getStatus());
        response$ResponseBuilder.entity(response.getEntity());
        for (String string : response.getMetadata().keySet()) {
            List list = (List)response.getMetadata().get(string);
            for (Object e2 : list) {
                response$ResponseBuilder.header(string, e2);
            }
        }
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder status(Response$StatusType response$StatusType) {
        Response$ResponseBuilder response$ResponseBuilder = Response$ResponseBuilder.newInstance();
        response$ResponseBuilder.status(response$StatusType);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder status(Response$Status response$Status) {
        return Response.status((Response$StatusType)response$Status);
    }

    public static Response$ResponseBuilder status(int n2) {
        Response$ResponseBuilder response$ResponseBuilder = Response$ResponseBuilder.newInstance();
        response$ResponseBuilder.status(n2);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder ok() {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.OK);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder ok(Object object) {
        Response$ResponseBuilder response$ResponseBuilder = Response.ok();
        response$ResponseBuilder.entity(object);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder ok(Object object, MediaType mediaType) {
        Response$ResponseBuilder response$ResponseBuilder = Response.ok();
        response$ResponseBuilder.entity(object);
        response$ResponseBuilder.type(mediaType);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder ok(Object object, String string) {
        Response$ResponseBuilder response$ResponseBuilder = Response.ok();
        response$ResponseBuilder.entity(object);
        response$ResponseBuilder.type(string);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder ok(Object object, Variant variant) {
        Response$ResponseBuilder response$ResponseBuilder = Response.ok();
        response$ResponseBuilder.entity(object);
        response$ResponseBuilder.variant(variant);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder serverError() {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.INTERNAL_SERVER_ERROR);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder created(URI uRI) {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.CREATED).location(uRI);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder noContent() {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.NO_CONTENT);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder notModified() {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.NOT_MODIFIED);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder notModified(EntityTag entityTag) {
        Response$ResponseBuilder response$ResponseBuilder = Response.notModified();
        response$ResponseBuilder.tag(entityTag);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder notModified(String string) {
        Response$ResponseBuilder response$ResponseBuilder = Response.notModified();
        response$ResponseBuilder.tag(string);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder seeOther(URI uRI) {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.SEE_OTHER).location(uRI);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder temporaryRedirect(URI uRI) {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.TEMPORARY_REDIRECT).location(uRI);
        return response$ResponseBuilder;
    }

    public static Response$ResponseBuilder notAcceptable(List<Variant> list) {
        Response$ResponseBuilder response$ResponseBuilder = Response.status(Response$Status.NOT_ACCEPTABLE).variants(list);
        return response$ResponseBuilder;
    }
}

