/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.MediaType$1;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.ext.RuntimeDelegate$HeaderDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType {
    private String type;
    private String subtype;
    private Map<String, String> parameters;
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    private static final RuntimeDelegate$HeaderDelegate<MediaType> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(MediaType.class);
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType();
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");

    public static MediaType valueOf(String string) {
        return delegate.fromString(string);
    }

    public MediaType(String string, String string2, Map<String, String> map) {
        this.type = string == null ? MEDIA_TYPE_WILDCARD : string;
        String string3 = this.subtype = string2 == null ? MEDIA_TYPE_WILDCARD : string2;
        if (map == null) {
            this.parameters = emptyMap;
        } else {
            TreeMap<String, String> treeMap = new TreeMap<String, String>(new MediaType$1(this));
            for (Map.Entry<String, String> entry : map.entrySet()) {
                treeMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            this.parameters = Collections.unmodifiableMap(treeMap);
        }
    }

    public MediaType(String string, String string2) {
        this(string, string2, emptyMap);
    }

    public MediaType() {
        this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(MEDIA_TYPE_WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(MEDIA_TYPE_WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (this.type.equals(MEDIA_TYPE_WILDCARD) || mediaType.type.equals(MEDIA_TYPE_WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(mediaType.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || mediaType.subtype.equals(MEDIA_TYPE_WILDCARD))) {
            return true;
        }
        return this.type.equalsIgnoreCase(mediaType.type) && this.subtype.equalsIgnoreCase(mediaType.subtype);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaType mediaType = (MediaType)object;
        return this.type.equalsIgnoreCase(mediaType.type) && this.subtype.equalsIgnoreCase(mediaType.subtype) && ((Object)this.parameters).equals(mediaType.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + ((Object)this.parameters).hashCode();
    }

    public String toString() {
        return delegate.toString(this);
    }
}

