/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlAdapterJsonSerializer
extends StdSerializer<Object>
implements SchemaAware,
ContextualSerializer {
    protected final XmlAdapter<?, Object> _xmlAdapter;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _serializer;

    public XmlAdapterJsonSerializer(XmlAdapter<?, ?> xmlAdapter) {
        this(xmlAdapter, null, null);
    }

    protected XmlAdapterJsonSerializer(XmlAdapter<?, Object> xmlAdapter, JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        super(Object.class);
        this._xmlAdapter = xmlAdapter;
        this._valueType = javaType;
        this._serializer = jsonSerializer;
    }

    public JsonSerializer<Object> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        JavaType javaType;
        JavaType javaType2;
        TypeFactory typeFactory = serializerProvider.getConfig().getTypeFactory();
        JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType2 = typeFactory.constructType(this._xmlAdapter.getClass()), XmlAdapter.class);
        if (javaTypeArray == null || javaTypeArray.length < 2) {
            javaType = TypeFactory.unknownType();
        } else {
            javaType = javaTypeArray[0];
            object = javaTypeArray[1];
            if (object != null && ((JavaType)object).getRawClass() == javaType.getRawClass()) {
                throw new IllegalArgumentException("Can not yet support 'identity' adapters");
            }
        }
        object = serializerProvider.findValueSerializer(javaType, beanProperty);
        return new XmlAdapterJsonSerializer(this._xmlAdapter, javaType, (JsonSerializer<Object>)object);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        try {
            object2 = this._xmlAdapter.marshal(object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new JsonMappingException("Unable to marshal: " + exception.getMessage(), exception);
        }
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else {
            this._checkSerializer();
            this._serializer.serialize(object2, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        this._checkSerializer();
        if (this._serializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._serializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    private final void _checkSerializer() {
        if (this._serializer == null) {
            throw new IllegalStateException("No serializer assigned for XmlAdapterJsonDeserializer (" + this._xmlAdapter.getClass().getName() + "): resolve() not called?");
        }
    }
}

