/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder$Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveArrayBuilder<T> {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    T _freeBuffer;
    PrimitiveArrayBuilder$Node<T> _bufferHead;
    PrimitiveArrayBuilder$Node<T> _bufferTail;
    int _bufferedEntryCount;

    protected PrimitiveArrayBuilder() {
    }

    public T resetAndStart() {
        this._reset();
        return this._freeBuffer == null ? this._constructArray(12) : this._freeBuffer;
    }

    public final T appendCompletedChunk(T t2, int n2) {
        PrimitiveArrayBuilder$Node<T> primitiveArrayBuilder$Node = new PrimitiveArrayBuilder$Node<T>(t2, n2);
        if (this._bufferHead == null) {
            this._bufferTail = primitiveArrayBuilder$Node;
            this._bufferHead = this._bufferTail;
        } else {
            this._bufferTail.linkNext(primitiveArrayBuilder$Node);
            this._bufferTail = primitiveArrayBuilder$Node;
        }
        this._bufferedEntryCount += n2;
        int n3 = n2;
        n3 = n3 < 16384 ? (n3 += n3) : (n3 += n3 >> 2);
        return this._constructArray(n3);
    }

    public T completeAndClearBuffer(T t2, int n2) {
        int n3 = n2 + this._bufferedEntryCount;
        T t3 = this._constructArray(n3);
        int n4 = 0;
        for (PrimitiveArrayBuilder$Node<T> primitiveArrayBuilder$Node = this._bufferHead; primitiveArrayBuilder$Node != null; primitiveArrayBuilder$Node = primitiveArrayBuilder$Node.next()) {
            n4 = primitiveArrayBuilder$Node.copyData(t3, n4);
        }
        System.arraycopy(t2, 0, t3, n4, n2);
        if ((n4 += n2) != n3) {
            throw new IllegalStateException("Should have gotten " + n3 + " entries, got " + n4);
        }
        return t3;
    }

    protected abstract T _constructArray(int var1);

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }
}

