/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayType
extends TypeBase {
    protected final JavaType _componentType;
    protected final Object _emptyArray;

    private ArrayType(JavaType javaType, Object object, Object object2, Object object3) {
        super(object.getClass(), javaType.hashCode(), object2, object3);
        this._componentType = javaType;
        this._emptyArray = object;
    }

    public static ArrayType construct(JavaType javaType, Object object, Object object2) {
        Object object3 = Array.newInstance(javaType.getRawClass(), 0);
        return new ArrayType(javaType, object3, null, null);
    }

    @Override
    public ArrayType withTypeHandler(Object object) {
        if (object == this._typeHandler) {
            return this;
        }
        return new ArrayType(this._componentType, this._emptyArray, this._valueHandler, object);
    }

    @Override
    public ArrayType withContentTypeHandler(Object object) {
        if (object == this._componentType.getTypeHandler()) {
            return this;
        }
        return new ArrayType(this._componentType.withTypeHandler(object), this._emptyArray, this._valueHandler, this._typeHandler);
    }

    @Override
    public ArrayType withValueHandler(Object object) {
        if (object == this._valueHandler) {
            return this;
        }
        return new ArrayType(this._componentType, this._emptyArray, object, this._typeHandler);
    }

    @Override
    public ArrayType withContentValueHandler(Object object) {
        if (object == this._componentType.getValueHandler()) {
            return this;
        }
        return new ArrayType(this._componentType.withValueHandler(object), this._emptyArray, this._valueHandler, this._typeHandler);
    }

    @Override
    protected String buildCanonicalName() {
        return this._class.getName();
    }

    @Override
    protected JavaType _narrow(Class<?> clazz) {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Incompatible narrowing operation: trying to narrow " + this.toString() + " to class " + clazz.getName());
        }
        Class<?> clazz2 = clazz.getComponentType();
        JavaType javaType = TypeFactory.defaultInstance().constructType(clazz2);
        return ArrayType.construct(javaType, this._valueHandler, this._typeHandler);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> clazz) {
        if (clazz == this._componentType.getRawClass()) {
            return this;
        }
        return ArrayType.construct(this._componentType.narrowBy(clazz), this._valueHandler, this._typeHandler);
    }

    @Override
    public JavaType widenContentsBy(Class<?> clazz) {
        if (clazz == this._componentType.getRawClass()) {
            return this;
        }
        return ArrayType.construct(this._componentType.widenBy(clazz), this._valueHandler, this._typeHandler);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public boolean hasGenericTypes() {
        return this._componentType.hasGenericTypes();
    }

    @Override
    public String containedTypeName(int n2) {
        if (n2 == 0) {
            return "E";
        }
        return null;
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public JavaType getContentType() {
        return this._componentType;
    }

    @Override
    public int containedTypeCount() {
        return 1;
    }

    @Override
    public JavaType containedType(int n2) {
        return n2 == 0 ? this._componentType : null;
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getGenericSignature(stringBuilder);
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getErasedSignature(stringBuilder);
    }

    @Override
    public String toString() {
        return "[array type, component type: " + this._componentType + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return this._componentType.equals(arrayType._componentType);
    }
}

