/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$CalendarKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$DateKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$StringKeySerializer;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StdKeySerializers$StringKeySerializer();

    private StdKeySerializers() {
    }

    public static JsonSerializer<Object> getStdKeySerializer(JavaType javaType) {
        if (javaType == null) {
            return DEFAULT_KEY_SERIALIZER;
        }
        Class<?> clazz = javaType.getRawClass();
        if (clazz == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (clazz == Object.class) {
            return DEFAULT_KEY_SERIALIZER;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return StdKeySerializers$DateKeySerializer.instance;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return StdKeySerializers$CalendarKeySerializer.instance;
        }
        return DEFAULT_KEY_SERIALIZER;
    }
}

