/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdSubtypeResolver
extends SubtypeResolver {
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    @Override
    public void registerSubtypes(NamedType ... namedTypeArray) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType namedType : namedTypeArray) {
            this._registeredSubtypes.add(namedType);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classArray) {
        NamedType[] namedTypeArray = new NamedType[classArray.length];
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            namedTypeArray[i2] = new NamedType(classArray[i2]);
        }
        this.registerSubtypes(namedTypeArray);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedMember annotatedMember, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector) {
        Object object;
        AnnotatedClass annotatedClass;
        Object object3;
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            object3 = annotatedMember.getRawType();
            for (NamedType object22 : this._registeredSubtypes) {
                if (!((Class)object3).isAssignableFrom(object22.getType())) continue;
                annotatedClass = AnnotatedClass.constructWithoutSuperTypes(object22.getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve(annotatedClass, object22, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        if ((object3 = annotationIntrospector.findSubtypes(annotatedMember)) != null) {
            object = object3.iterator();
            while (object.hasNext()) {
                NamedType namedType = (NamedType)object.next();
                annotatedClass = AnnotatedClass.constructWithoutSuperTypes(namedType.getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve(annotatedClass, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        object = new NamedType(annotatedMember.getRawType(), null);
        AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(annotatedMember.getRawType(), annotationIntrospector, mapperConfig);
        this._collectAndResolve(annotatedClass2, (NamedType)object, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedClass annotatedClass, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector) {
        Object object;
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            object = annotatedClass.getRawType();
            for (NamedType namedType : this._registeredSubtypes) {
                if (!((Class)object).isAssignableFrom(namedType.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType.getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve(annotatedClass2, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        object = new NamedType(annotatedClass.getRawType(), null);
        this._collectAndResolve(annotatedClass, (NamedType)object, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    protected void _collectAndResolve(AnnotatedClass annotatedClass, NamedType namedType, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, HashMap<NamedType, NamedType> hashMap) {
        List<NamedType> list;
        if (!namedType.hasName() && (list = annotationIntrospector.findTypeName(annotatedClass)) != null) {
            namedType = new NamedType(namedType.getType(), (String)((Object)list));
        }
        if (hashMap.containsKey(namedType)) {
            if (namedType.hasName() && !((NamedType)((Object)(list = hashMap.get(namedType)))).hasName()) {
                hashMap.put(namedType, namedType);
            }
            return;
        }
        hashMap.put(namedType, namedType);
        list = annotationIntrospector.findSubtypes(annotatedClass);
        if (list != null && !list.isEmpty()) {
            for (NamedType namedType2 : list) {
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), annotationIntrospector, mapperConfig);
                if (!namedType2.hasName()) {
                    namedType2 = new NamedType(namedType2.getType(), annotationIntrospector.findTypeName(annotatedClass2));
                }
                this._collectAndResolve(annotatedClass2, namedType2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
    }
}

