/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder$Value;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClassIntrospector
extends ClassIntrospector {
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    public static final BasicClassIntrospector instance;

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, classIntrospector$MixInResolver, true, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, classIntrospector$MixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, classIntrospector$MixInResolver, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, classIntrospector$MixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), bl ? mapperConfig.getAnnotationIntrospector() : null, classIntrospector$MixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(javaType.getRawClass(), bl ? annotationIntrospector : null, classIntrospector$MixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, boolean bl, String string) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), bl2 ? mapperConfig.getAnnotationIntrospector() : null, classIntrospector$MixInResolver);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string).collect();
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, boolean bl) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = bl2 ? mapperConfig.getAnnotationIntrospector() : null;
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), annotationIntrospector, classIntrospector$MixInResolver);
        JsonPOJOBuilder$Value jsonPOJOBuilder$Value = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
        String string = jsonPOJOBuilder$Value == null ? "with" : jsonPOJOBuilder$Value.withPrefix;
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string).collect();
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findCachedDesc(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == String.class) {
            return STRING_DESC;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN_DESC;
        }
        if (clazz == Integer.TYPE) {
            return INT_DESC;
        }
        if (clazz == Long.TYPE) {
            return LONG_DESC;
        }
        return null;
    }

    static {
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(String.class, null, null);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Boolean.TYPE, null, null);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Integer.TYPE, null, null);
        INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Long.TYPE, null, null);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), annotatedClass);
        instance = new BasicClassIntrospector();
    }
}

