/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$BoolKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$ByteKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$CalendarKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$CharKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$DateKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$DelegatingKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$DoubleKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$EnumKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$FloatKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$IntKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$LocaleKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$LongKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$ShortKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$StringCtorKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$StringFactoryKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$StringKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$UuidKD;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdKeyDeserializers {
    protected final HashMap<JavaType, KeyDeserializer> _keyDeserializers = new HashMap();

    protected StdKeyDeserializers() {
        this.add(new StdKeyDeserializer$BoolKD());
        this.add(new StdKeyDeserializer$ByteKD());
        this.add(new StdKeyDeserializer$CharKD());
        this.add(new StdKeyDeserializer$ShortKD());
        this.add(new StdKeyDeserializer$IntKD());
        this.add(new StdKeyDeserializer$LongKD());
        this.add(new StdKeyDeserializer$FloatKD());
        this.add(new StdKeyDeserializer$DoubleKD());
        this.add(new StdKeyDeserializer$DateKD());
        this.add(new StdKeyDeserializer$CalendarKD());
        this.add(new StdKeyDeserializer$UuidKD());
        this.add(new StdKeyDeserializer$LocaleKD());
    }

    private void add(StdKeyDeserializer stdKeyDeserializer) {
        Class<?> clazz = stdKeyDeserializer.getKeyClass();
        this._keyDeserializers.put(TypeFactory.defaultInstance().constructType(clazz), stdKeyDeserializer);
    }

    public static HashMap<JavaType, KeyDeserializer> constructAll() {
        return new StdKeyDeserializers()._keyDeserializers;
    }

    public static KeyDeserializer constructStringKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        return StdKeyDeserializer$StringKD.forType(javaType.getRawClass());
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer$EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer$EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer$DelegatingKD(javaType.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        Object t2 = deserializationConfig.introspect(javaType);
        Constructor<?> constructor = ((BeanDescription)t2).findSingleArgConstructor(String.class);
        if (constructor != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(constructor);
            }
            return new StdKeyDeserializer$StringCtorKeyDeserializer(constructor);
        }
        Method method = ((BeanDescription)t2).findFactoryMethod(String.class);
        if (method != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            return new StdKeyDeserializer$StringFactoryKeyDeserializer(method);
        }
        return null;
    }
}

