/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$IntBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
final class PrimitiveArrayDeserializers$IntDeser
extends PrimitiveArrayDeserializers$Base<int[]> {
    public PrimitiveArrayDeserializers$IntDeser() {
        super(int[].class);
    }

    @Override
    public int[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$IntBuilder arrayBuilders$IntBuilder = deserializationContext.getArrayBuilders().getIntBuilder();
        int[] nArray = (int[])arrayBuilders$IntBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            int n3 = this._parseIntPrimitive(jsonParser, deserializationContext);
            if (n2 >= nArray.length) {
                nArray = arrayBuilders$IntBuilder.appendCompletedChunk(nArray, n2);
                n2 = 0;
            }
            nArray[n2++] = n3;
        }
        return arrayBuilders$IntBuilder.completeAndClearBuffer(nArray, n2);
    }

    private final int[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new int[]{this._parseIntPrimitive(jsonParser, deserializationContext)};
    }
}

