/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeserializer$FactoryBasedDeserializer
extends StdScalarDeserializer<Object> {
    protected final Class<?> _enumClass;
    protected final Class<?> _inputType;
    protected final Method _factory;

    public EnumDeserializer$FactoryBasedDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, Class<?> clazz2) {
        super(Enum.class);
        this._enumClass = clazz;
        this._factory = annotatedMethod.getAnnotated();
        this._inputType = clazz2;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (this._inputType == null) {
            object = jsonParser.getText();
        } else if (this._inputType == Integer.class) {
            object = jsonParser.getValueAsInt();
        } else if (this._inputType == Long.class) {
            object = jsonParser.getValueAsLong();
        } else {
            throw deserializationContext.mappingException(this._enumClass);
        }
        try {
            return this._factory.invoke(this._enumClass, object);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception);
            return null;
        }
    }
}

