/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializer
extends BeanDeserializerBase {
    public BeanDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, HashSet<String> hashSet, boolean bl, boolean bl2) {
        super(beanDeserializerBuilder, beanDescription, beanPropertyMap, map, hashSet, bl, bl2);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase) {
        super(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase, bl);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase, nameTransformer);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, ObjectIdReader objectIdReader) {
        super(beanDeserializerBase, objectIdReader);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, HashSet<String> hashSet) {
        super(beanDeserializerBase, hashSet);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        return new BeanDeserializer((BeanDeserializerBase)this, nameTransformer);
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanDeserializer((BeanDeserializerBase)this, objectIdReader);
    }

    @Override
    public BeanDeserializer withIgnorableProperties(HashSet<String> hashSet) {
        return new BeanDeserializer((BeanDeserializerBase)this, hashSet);
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
            if (this._vanillaProcessing) {
                return this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken);
            }
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObject(jsonParser, deserializationContext);
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                return this.deserializeFromString(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_INT: {
                return this.deserializeFromNumber(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_FLOAT: {
                return this.deserializeFromDouble(jsonParser, deserializationContext);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jsonParser.getEmbeddedObject();
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return this.deserializeFromBoolean(jsonParser, deserializationContext);
            }
            case START_ARRAY: {
                return this.deserializeFromArray(jsonParser, deserializationContext);
            }
            case FIELD_NAME: 
            case END_OBJECT: {
                if (this._vanillaProcessing) {
                    return this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken);
                }
                if (this._objectIdReader != null) {
                    return this.deserializeWithObjectId(jsonParser, deserializationContext);
                }
                return this.deserializeFromObject(jsonParser, deserializationContext);
            }
        }
        throw deserializationContext.mappingException(this.getBeanClass());
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Object object2;
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        if (this._needViewProcesing && (object2 = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object, (Class<?>)object2);
        }
        while (jsonToken == JsonToken.FIELD_NAME) {
            object2 = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object2);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, (String)object2, deserializationContext);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(object2)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, (String)object2);
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, (String)object2);
            }
            jsonToken = jsonParser.nextToken();
        }
        return object;
    }

    private final Object vanillaDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) {
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                }
            } else {
                this._vanillaDeserializeHandleUnknown(jsonParser, deserializationContext, object, string);
            }
            jsonParser.nextToken();
        }
        return object;
    }

    private final void _vanillaDeserializeHandleUnknown(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
            jsonParser.skipChildren();
        } else if (this._anySetter != null) {
            try {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
            }
            catch (Exception exception) {
                this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
            }
        } else {
            this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
        }
    }

    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object2 = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object2);
        }
        if (this._needViewProcesing && (object = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object2, (Class<?>)object);
        }
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object2);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object2, (String)object, deserializationContext);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                try {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object2, (String)object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object2, (String)object, deserializationContext);
                }
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object2, (String)object);
            }
            jsonParser.nextToken();
        }
        return object2;
    }

    protected Object deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        String string = this._objectIdReader.propertyName;
        if (string.equals(jsonParser.getCurrentName())) {
            return this.deserializeFromObject(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        TokenBuffer tokenBuffer2 = null;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            object = jsonParser.getCurrentName();
            if (tokenBuffer2 == null) {
                if (string.equals(object)) {
                    tokenBuffer2 = new TokenBuffer(jsonParser.getCodec());
                    tokenBuffer2.writeFieldName((String)object);
                    jsonParser.nextToken();
                    tokenBuffer2.copyCurrentStructure(jsonParser);
                    tokenBuffer2.append(tokenBuffer);
                    tokenBuffer = null;
                } else {
                    tokenBuffer.writeFieldName((String)object);
                    jsonParser.nextToken();
                    tokenBuffer.copyCurrentStructure(jsonParser);
                }
            } else {
                tokenBuffer2.writeFieldName((String)object);
                jsonParser.nextToken();
                tokenBuffer2.copyCurrentStructure(jsonParser);
            }
            jsonParser.nextToken();
        }
        object = tokenBuffer2 == null ? tokenBuffer : tokenBuffer2;
        ((TokenBuffer)object).writeEndObject();
        JsonParser jsonParser2 = ((TokenBuffer)object).asParser();
        jsonParser2.nextToken();
        return this.deserializeFromObject(jsonParser2, deserializationContext);
    }

    protected Object deserializeFromObjectUsingNonDefault(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(jsonParser, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    public Object deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromString()) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        return this._valueInstantiator.createFromString(deserializationContext, jsonParser.getText());
    }

    public Object deserializeFromNumber(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        switch (jsonParser.getNumberType()) {
            case INT: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromInt(deserializationContext, jsonParser.getIntValue());
            }
            case LONG: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromLong(deserializationContext, jsonParser.getLongValue());
            }
        }
        if (this._delegateDeserializer != null) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON integer number");
    }

    public Object deserializeFromDouble(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.getNumberType()) {
            case FLOAT: 
            case DOUBLE: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromDouble()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromDouble(deserializationContext, jsonParser.getDoubleValue());
            }
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON floating-point number");
    }

    public Object deserializeFromBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromBoolean()) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        boolean bl = jsonParser.getCurrentToken() == JsonToken.VALUE_TRUE;
        return this._valueInstantiator.createFromBoolean(deserializationContext, bl);
    }

    public Object deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._delegateDeserializer != null) {
            try {
                Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            catch (Exception exception) {
                this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        throw deserializationContext.mappingException(this.getBeanClass());
    }

    protected final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext);
        TokenBuffer tokenBuffer = null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block19: {
                Object object2;
                object = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
                if (settableBeanProperty != null) {
                    object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    if (propertyValueBuffer.assignParameter(settableBeanProperty.getPropertyIndex(), object2)) {
                        Object object3;
                        jsonParser.nextToken();
                        try {
                            object3 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                            break block19;
                        }
                        if (object3.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(jsonParser, deserializationContext, object3, tokenBuffer);
                        }
                        if (tokenBuffer != null) {
                            object3 = this.handleUnknownProperties(deserializationContext, object3, tokenBuffer);
                        }
                        return this.deserialize(jsonParser, deserializationContext, object3);
                    }
                } else {
                    object2 = this._beanProperties.find((String)object);
                    if (object2 != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                        jsonParser.skipChildren();
                    } else if (this._anySetter != null) {
                        propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                    } else {
                        if (tokenBuffer == null) {
                            tokenBuffer = new TokenBuffer(jsonParser.getCodec());
                        }
                        tokenBuffer.writeFieldName((String)object);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
        if (tokenBuffer != null) {
            if (object.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, deserializationContext, object, tokenBuffer);
            }
            return this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        return object;
    }

    protected Object handlePolymorphic(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) {
        JsonDeserializer<Object> jsonDeserializer = this._findSubclassDeserializer(deserializationContext, object, tokenBuffer);
        if (jsonDeserializer != null) {
            if (tokenBuffer != null) {
                tokenBuffer.writeEndObject();
                JsonParser jsonParser2 = tokenBuffer.asParser();
                jsonParser2.nextToken();
                object = jsonDeserializer.deserialize(jsonParser2, deserializationContext, object);
            }
            if (jsonParser != null) {
                object = jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
            }
            return object;
        }
        if (tokenBuffer != null) {
            object = this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        if (jsonParser != null) {
            object = this.deserialize(jsonParser, deserializationContext, object);
        }
        return object;
    }

    protected final Object deserializeWithView(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Class<?> clazz) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (!settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
            }
            jsonToken = jsonParser.nextToken();
        }
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Class<?> clazz;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            }
            jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Class<?> clazz;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block15: {
                Object object2;
                object = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
                if (settableBeanProperty != null) {
                    object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    if (propertyValueBuffer.assignParameter(settableBeanProperty.getPropertyIndex(), object2)) {
                        Object object3;
                        jsonToken = jsonParser.nextToken();
                        try {
                            object3 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                            break block15;
                        }
                        while (jsonToken == JsonToken.FIELD_NAME) {
                            jsonParser.nextToken();
                            tokenBuffer.copyCurrentStructure(jsonParser);
                            jsonToken = jsonParser.nextToken();
                        }
                        tokenBuffer.writeEndObject();
                        if (object3.getClass() != this._beanType.getRawClass()) {
                            throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                        }
                        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object3, tokenBuffer);
                    }
                } else {
                    object2 = this._beanProperties.find((String)object);
                    if (object2 != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                        jsonParser.skipChildren();
                    } else {
                        tokenBuffer.writeFieldName((String)object);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                        if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jsonParser, deserializationContext);
        }
        return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (jsonParser.getCurrentToken().isScalarValue()) {
                    externalTypeHandler.handleTypePropertyValue(jsonParser, deserializationContext, string, object);
                }
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, object)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonParser.nextToken();
        }
        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block17: {
                Object object;
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, propertyValueBuffer)) {
                        object = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                        if (propertyValueBuffer.assignParameter(settableBeanProperty.getPropertyIndex(), object)) {
                            Object object2;
                            jsonToken = jsonParser.nextToken();
                            try {
                                object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block17;
                            }
                            while (jsonToken == JsonToken.FIELD_NAME) {
                                jsonParser.nextToken();
                                tokenBuffer.copyCurrentStructure(jsonParser);
                                jsonToken = jsonParser.nextToken();
                            }
                            if (object2.getClass() != this._beanType.getRawClass()) {
                                throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                            }
                            return externalTypeHandler.complete(jsonParser, deserializationContext, object2);
                        }
                    }
                } else {
                    object = this._beanProperties.find(string);
                    if (object != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object, ((SettableBeanProperty)object).deserialize(jsonParser, deserializationContext));
                    } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, null)) {
                        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                            jsonParser.skipChildren();
                        } else if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            return externalTypeHandler.complete(jsonParser, deserializationContext, propertyValueBuffer, propertyBasedCreator);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
    }
}

