/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.FailingSerializer;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializerProvider {
    protected static final JavaType TYPE_OBJECT = TypeFactory.defaultInstance().uncheckedSimpleType(Object.class);
    protected static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    public static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final Class<?> _serializationView;
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected final RootNameLookup _rootNames;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _nullValueSerializer = NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;

    public SerializerProvider() {
        this._config = null;
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
        this._rootNames = new RootNameLookup();
        this._serializationView = null;
    }

    public SerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        if (serializationConfig == null) {
            throw new NullPointerException();
        }
        this._serializerFactory = serializerFactory;
        this._config = serializationConfig;
        this._serializerCache = serializerProvider._serializerCache;
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._rootNames = serializerProvider._rootNames;
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
        this._serializationView = serializationConfig.getActiveView();
    }

    public void setDefaultKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._keySerializer = jsonSerializer;
    }

    public void setNullValueSerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullValueSerializer = jsonSerializer;
    }

    public void setNullKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullKeySerializer = jsonSerializer;
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    public final Class<?> getSerializationView() {
        return this._serializationView;
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public JavaType constructType(Type type) {
        return this._config.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this._config.constructSpecializedType(javaType, clazz);
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz, beanProperty)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this._handleContextual(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType, beanProperty)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(javaType.getRawClass());
            return jsonSerializer;
        }
        return this._handleContextual(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> clazz, boolean bl, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(clazz, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, this._config.constructType(clazz));
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType javaType, boolean bl, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(javaType, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, javaType);
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(javaType, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findKeySerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._serializerFactory.createKeySerializer(this._config, javaType);
        if (jsonSerializer == null) {
            jsonSerializer = this._keySerializer == null ? StdKeySerializers.getStdKeySerializer(javaType) : this._keySerializer;
        }
        return this._handleContextualResolvable(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType javaType, BeanProperty beanProperty) {
        return this.getDefaultNullKeySerializer();
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty beanProperty) {
        return this.getDefaultNullValueSerializer();
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> clazz) {
        return this._unknownTypeSerializer;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2);

    public abstract ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated var1, ObjectIdInfo var2);

    public final void defaultSerializeValue(Object object, JsonGenerator jsonGenerator) {
        if (object == null) {
            this.getDefaultNullValueSerializer().serialize(null, jsonGenerator, this);
        } else {
            Class<?> clazz = object.getClass();
            this.findTypedValueSerializer(clazz, true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeField(String string, Object object, JsonGenerator jsonGenerator) {
        jsonGenerator.writeFieldName(string);
        if (object == null) {
            this.getDefaultNullValueSerializer().serialize(null, jsonGenerator, this);
        } else {
            Class<?> clazz = object.getClass();
            this.findTypedValueSerializer(clazz, true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeDateValue(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(l2);
        } else {
            jsonGenerator.writeString(this._dateFormat().format(new Date(l2)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(date.getTime());
        } else {
            jsonGenerator.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(l2));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(new Date(l2)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(date.getTime()));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNull(JsonGenerator jsonGenerator) {
        this.getDefaultNullValueSerializer().serialize(null, jsonGenerator, this);
    }

    protected void _reportIncompatibleRootType(Object object, JavaType javaType) {
        Class<?> clazz;
        if (javaType.isPrimitive() && (clazz = ClassUtil.wrapperType(javaType.getRawClass())).isAssignableFrom(object.getClass())) {
            return;
        }
        throw new JsonMappingException("Incompatible types: declared root type (" + javaType + ") vs " + object.getClass().getName());
    }

    protected JsonSerializer<Object> _findExplicitUntypedSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.untypedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        try {
            return this._createAndCacheUntypedSerializer(clazz, beanProperty);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(this._config.constructType(clazz), beanProperty);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(clazz, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(javaType, beanProperty);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createUntypedSerializer(JavaType javaType, BeanProperty beanProperty) {
        return this._serializerFactory.createSerializer(this, javaType, beanProperty);
    }

    protected JsonSerializer<Object> _handleContextualResolvable(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return this._handleContextual(jsonSerializer, beanProperty);
    }

    protected JsonSerializer<Object> _handleResolvable(JsonSerializer<?> jsonSerializer) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _handleContextual(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }
}

