/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWriter
implements Versioned {
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _jsonFactory;
    protected final JavaType _rootType;
    protected final PrettyPrinter _prettyPrinter;
    protected final FormatSchema _schema;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootType = javaType;
        this._prettyPrinter = prettyPrinter;
        this._schema = null;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._prettyPrinter = null;
        this._schema = null;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._prettyPrinter = null;
        this._schema = formatSchema;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._jsonFactory = objectWriter._jsonFactory;
        this._rootType = javaType;
        this._prettyPrinter = prettyPrinter;
        this._schema = formatSchema;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._jsonFactory = objectWriter._jsonFactory;
        this._schema = objectWriter._schema;
        this._rootType = objectWriter._rootType;
        this._prettyPrinter = objectWriter._prettyPrinter;
    }

    @Override
    public Version version() {
        return DatabindVersion.instance.version();
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = this._config.with(dateFormat);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(new DefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return new ObjectWriter(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == this._prettyPrinter) {
            return this;
        }
        if (prettyPrinter == null) {
            prettyPrinter = NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this._config, this._rootType, prettyPrinter, this._schema);
    }

    public ObjectWriter withRootName(String string) {
        SerializationConfig serializationConfig = this._config.withRootName(string);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this._schema == formatSchema ? this : new ObjectWriter(this, this._config, this._rootType, this._prettyPrinter, formatSchema);
    }

    public ObjectWriter withType(JavaType javaType) {
        return javaType == this._rootType ? this : new ObjectWriter(this, this._config, javaType, this._prettyPrinter, this._schema);
    }

    public ObjectWriter withType(Class<?> clazz) {
        return this.withType(this._config.constructType(clazz));
    }

    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.withType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectWriter withView(Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this._config.withView((Class)clazz);
        return mapperConfigBase == this._config ? this : new ObjectWriter(this, (SerializationConfig)mapperConfigBase);
    }

    public ObjectWriter with(Locale locale) {
        SerializationConfig serializationConfig = this._config.with(locale);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(TimeZone timeZone) {
        SerializationConfig serializationConfig = this._config.with(timeZone);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return this._jsonFactory.isEnabled(jsonParser$Feature);
    }

    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, this._config);
        } else {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(writer), object);
    }

    public String writeValueAsString(Object object) {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(segmentedStringWriter), object);
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this._config).hasSerializerFor(clazz);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) {
        if (this._prettyPrinter != null) {
            PrettyPrinter prettyPrinter = this._prettyPrinter;
            jsonGenerator.setPrettyPrinter(prettyPrinter == NULL_PRETTY_PRINTER ? null : prettyPrinter);
        } else if (this._config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (this._schema != null) {
            jsonGenerator.setSchema(this._schema);
        }
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, this._config);
            return;
        }
        boolean bl = false;
        try {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType);
            }
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _configAndWriteCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            }
            if (this._schema != null) {
                jsonGenerator.setSchema(this._schema);
            }
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object, this._rootType);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

