/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException$Reference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMappingException
extends JsonProcessingException {
    private static final long serialVersionUID = 1L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<JsonMappingException$Reference> _path;

    public JsonMappingException(String string) {
        super(string);
    }

    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(string, jsonParser.getTokenLocation());
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException(string, jsonParser.getTokenLocation(), throwable);
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new JsonMappingException$Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n2) {
        return JsonMappingException.wrapWithPath(throwable, new JsonMappingException$Reference(object, n2));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, JsonMappingException$Reference jsonMappingException$Reference) {
        JsonMappingException jsonMappingException;
        if (throwable instanceof JsonMappingException) {
            jsonMappingException = (JsonMappingException)throwable;
        } else {
            String string = throwable.getMessage();
            if (string == null || string.length() == 0) {
                string = "(was " + throwable.getClass().getName() + ")";
            }
            jsonMappingException = new JsonMappingException(string, null, throwable);
        }
        jsonMappingException.prependPath(jsonMappingException$Reference);
        return jsonMappingException;
    }

    public List<JsonMappingException$Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    public void prependPath(Object object, String string) {
        JsonMappingException$Reference jsonMappingException$Reference = new JsonMappingException$Reference(object, string);
        this.prependPath(jsonMappingException$Reference);
    }

    public void prependPath(Object object, int n2) {
        JsonMappingException$Reference jsonMappingException$Reference = new JsonMappingException$Reference(object, n2);
        this.prependPath(jsonMappingException$Reference);
    }

    public void prependPath(JsonMappingException$Reference jsonMappingException$Reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(jsonMappingException$Reference);
        }
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String string = super.getMessage();
        if (this._path == null) {
            return string;
        }
        StringBuilder stringBuilder = string == null ? new StringBuilder() : new StringBuilder(string);
        stringBuilder.append(" (through reference chain: ");
        stringBuilder = this.getPathReference(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        Iterator iterator = this._path.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((JsonMappingException$Reference)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("->");
        }
    }
}

